/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;

public class FloatValueImpl
extends FieldValueImpl
implements FloatValue {
    private static final long serialVersionUID = 1L;
    protected float value;

    FloatValueImpl(float value) {
        this.value = value;
    }

    FloatValueImpl(String keyValue) {
        this.value = SortableString.floatFromSortable(keyValue);
    }

    @Override
    public FloatValueImpl clone() {
        return new FloatValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 4;
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof FloatValueImpl) {
            return Double.compare(this.value, ((FloatValueImpl)other).get()) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof FloatValueImpl) {
            return Double.compare(this.value, ((FloatValueImpl)other).get());
        }
        throw new ClassCastException("Object is not an DoubleValue");
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.FLOAT;
    }

    @Override
    public FloatDefImpl getDefinition() {
        return FieldDefImpl.floatDef;
    }

    @Override
    public FloatValue asFloat() {
        return this;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public void setFloat(float v) {
        this.value = v;
    }

    @Override
    public int castAsInt() {
        return (int)this.value;
    }

    @Override
    public long castAsLong() {
        return (long)this.value;
    }

    @Override
    public float castAsFloat() {
        return this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal castAsDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public String castAsString() {
        return Float.toString(this.value);
    }

    @Override
    public FieldValueImpl getNextValue() {
        return new FloatValueImpl(Math.nextUp(this.value));
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new FloatValueImpl(Float.MIN_VALUE);
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return FloatValueImpl.toKeyString(this.value);
    }

    @Override
    public JsonNode toJsonNode() {
        return new FloatNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    static String toKeyString(float value) {
        return SortableString.toSortable(value);
    }

    private static final class FloatNode
    extends ValueNode {
        private final float value;

        FloatNode(float value) {
            this.value = value;
        }

        @Override
        public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
            jg.writeNumber(this.value);
        }

        @Override
        public JsonToken asToken() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        @Override
        public int hashCode() {
            Float f = Float.valueOf(this.value);
            return f.hashCode();
        }

        @Override
        public JsonNodeType getNodeType() {
            return JsonNodeType.NUMBER;
        }

        @Override
        public String asText() {
            return Float.valueOf(this.value).toString();
        }
    }
}

