/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FieldValueFactory;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.JsonDef;
import oracle.kv.table.LongValue;
import oracle.kv.table.NumberValue;
import oracle.kv.table.StringValue;

public class JsonDefImpl
extends FieldDefImpl
implements JsonDef {
    private static final long serialVersionUID = 1L;

    JsonDefImpl(String description) {
        super(FieldDef.Type.JSON, description);
    }

    JsonDefImpl() {
        this((String)null);
    }

    @Override
    public JsonDefImpl clone() {
        return FieldDefImpl.jsonDef;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public JsonDef asJson() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JsonDefImpl;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public boolean isPrecise() {
        return false;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isJson() || superType.isAny();
    }

    @Override
    public short getRequiredSerialVersion() {
        return 12;
    }

    @Override
    public ArrayValueImpl createArray() {
        return new ArrayValueImpl(FieldDefImpl.arrayJsonDef);
    }

    @Override
    public BooleanValue createBoolean(boolean value) {
        return booleanDef.createBoolean(value);
    }

    @Override
    public DoubleValue createDouble(double value) {
        return doubleDef.createDouble(value);
    }

    @Override
    public FloatValue createFloat(float value) {
        return floatDef.createFloat(value);
    }

    @Override
    public IntegerValue createInteger(int value) {
        return integerDef.createInteger(value);
    }

    @Override
    public LongValue createLong(long value) {
        return longDef.createLong(value);
    }

    @Override
    public NumberValue createNumber(int value) {
        return numberDef.createNumber(value);
    }

    @Override
    public NumberValue createNumber(long value) {
        return numberDef.createNumber(value);
    }

    @Override
    public NumberValue createNumber(float value) {
        return numberDef.createNumber(value);
    }

    @Override
    public NumberValue createNumber(double value) {
        return numberDef.createNumber(value);
    }

    @Override
    public NumberValue createNumber(BigDecimal decimal) {
        return numberDef.createNumber(decimal);
    }

    @Override
    public MapValueImpl createMap() {
        return new MapValueImpl(FieldDefImpl.mapJsonDef);
    }

    @Override
    public StringValue createString(String value) {
        return stringDef.createString(value);
    }

    @Override
    public FieldValue createJsonNull() {
        return NullJsonValueImpl.getInstance();
    }

    static void validateJsonType(FieldValue value) {
        FieldDefImpl elemDef;
        FieldDef.Type type = value.getType();
        if (type == FieldDef.Type.BINARY || type == FieldDef.Type.FIXED_BINARY || type == FieldDef.Type.ENUM || type == FieldDef.Type.RECORD) {
            throw new IllegalArgumentException("Type is not supported in JSON: " + type);
        }
        if (!(type != FieldDef.Type.MAP && type != FieldDef.Type.ARRAY || (elemDef = (FieldDefImpl)value.getDefinition()).isSubtype(FieldDefImpl.jsonDef))) {
            throw new IllegalArgumentException("Type is not supported in JSON: " + type);
        }
    }

    public static FieldValue createFromJson(JsonParser jp, boolean getNext) {
        try {
            JsonToken token;
            JsonToken jsonToken = token = getNext ? jp.nextToken() : jp.getCurrentToken();
            if (token == null) {
                throw new IllegalStateException("createFromJson called with null token");
            }
            switch (token) {
                case VALUE_STRING: {
                    return FieldDefImpl.stringDef.createString(jp.getText());
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    JsonParser.NumberType numberType = jp.getNumberType();
                    switch (numberType) {
                        case BIG_INTEGER: 
                        case BIG_DECIMAL: {
                            return FieldDefImpl.numberDef.createNumber(TableJsonUtils.jsonParserGetDecimalValue(jp));
                        }
                        case INT: {
                            return FieldDefImpl.integerDef.createInteger(jp.getIntValue());
                        }
                        case LONG: {
                            return FieldDefImpl.longDef.createLong(jp.getLongValue());
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            BigDecimal bd;
                            double dbl = jp.getDoubleValue();
                            if ((Double.isInfinite(dbl) || dbl == 0.0) && (bd = TableJsonUtils.jsonParserGetDecimalValue(jp)).compareTo(BigDecimal.ZERO) != 0) {
                                return FieldDefImpl.numberDef.createNumber(bd);
                            }
                            return FieldDefImpl.doubleDef.createDouble(dbl);
                        }
                    }
                    throw new IllegalStateException("Unexpected numeric type: " + (Object)((Object)numberType));
                }
                case VALUE_TRUE: {
                    return FieldDefImpl.booleanDef.createBoolean(true);
                }
                case VALUE_FALSE: {
                    return FieldDefImpl.booleanDef.createBoolean(false);
                }
                case VALUE_NULL: {
                    return NullJsonValueImpl.getInstance();
                }
                case START_OBJECT: {
                    return JsonDefImpl.parseObject(jp);
                }
                case START_ARRAY: {
                    return JsonDefImpl.parseArray(jp);
                }
            }
            throw new IllegalStateException("Unexpected token while parsing JSON: " + (Object)((Object)token));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage());
        }
    }

    static FieldValue createFromReader(Reader jsonReader) {
        try {
            return FieldValueFactory.createValueFromJson(jsonReader);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }

    private static FieldValueImpl parseObject(JsonParser jp) throws IOException {
        JsonToken token;
        MapValueImpl map = FieldDefImpl.jsonDef.createMap();
        while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if (token == null || fieldName == null) {
                throw new IllegalArgumentException("null token or field name parsing JSON object");
            }
            FieldValue field = JsonDefImpl.createFromJson(jp, true);
            if (field.isJsonNull()) {
                map.put(fieldName, NullJsonValueImpl.getInstance());
                continue;
            }
            map.put(fieldName, field);
        }
        return map;
    }

    private static FieldValueImpl parseArray(JsonParser jp) throws IOException {
        JsonToken token;
        ArrayValueImpl array = FieldDefImpl.jsonDef.createArray();
        while ((token = jp.nextToken()) != JsonToken.END_ARRAY) {
            if (token == null) {
                throw new IllegalStateException("null token while parsing JSON array");
            }
            array.add(JsonDefImpl.createFromJson(jp, false));
        }
        return array;
    }
}

