/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.LongValue;

public class LongValueImpl
extends FieldValueImpl
implements LongValue {
    private static final long serialVersionUID = 1L;
    public static LongValueImpl ZERO = new LongValueImpl(0L);
    protected long value;

    LongValueImpl(long value) {
        this.value = value;
    }

    LongValueImpl(String keyValue) {
        this.value = SortableString.longFromSortable(keyValue);
    }

    @Override
    public LongValueImpl clone() {
        return new LongValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 8;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LongValueImpl) {
            return this.value == ((LongValueImpl)other).get();
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof LongValueImpl) {
            return LongValueImpl.compare(this.value, ((LongValueImpl)other).value);
        }
        if (other instanceof IntegerValueImpl) {
            return LongValueImpl.compare(this.value, ((IntegerValueImpl)other).get());
        }
        throw new ClassCastException("Value is not comparable to LongValue");
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.LONG;
    }

    @Override
    public LongDefImpl getDefinition() {
        return FieldDefImpl.longDef;
    }

    @Override
    public LongValue asLong() {
        return this;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public long get() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public void setLong(long v) {
        this.value = v;
    }

    @Override
    public int castAsInt() {
        return (int)this.value;
    }

    @Override
    public long castAsLong() {
        return this.value;
    }

    @Override
    public float castAsFloat() {
        return this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal castAsDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public String castAsString() {
        return Long.toString(this.value);
    }

    @Override
    FieldValueImpl getNextValue() {
        if (this.value == Long.MAX_VALUE) {
            return null;
        }
        return new LongValueImpl(this.value + 1L);
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return new LongValueImpl(Long.MIN_VALUE);
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return LongValueImpl.toKeyString(this.value, field);
    }

    @Override
    public JsonNode toJsonNode() {
        return new LongNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    static String toKeyString(long value, FieldDef field) {
        int len = field != null ? ((LongDefImpl)field).getEncodingLength() : 0;
        return SortableString.toSortable(value, len);
    }
}

