/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.MapDef;

public class MapDefImpl
extends FieldDefImpl
implements MapDef {
    private static final long serialVersionUID = 1L;
    private final FieldDefImpl element;

    MapDefImpl(FieldDefImpl element, String description) {
        super(FieldDef.Type.MAP, description);
        if (element == null) {
            throw new IllegalArgumentException("Map has no field and cannot be built");
        }
        this.element = element;
    }

    MapDefImpl(FieldDefImpl element) {
        this(element, null);
    }

    private MapDefImpl(MapDefImpl impl) {
        super(impl);
        this.element = impl.element.clone();
    }

    @Override
    public MapDefImpl clone() {
        if (this == FieldDefImpl.mapAnyDef || this == FieldDefImpl.mapJsonDef) {
            return this;
        }
        return new MapDefImpl(this);
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MapDefImpl) {
            return this.element.equals(((MapDefImpl)other).getElement());
        }
        return false;
    }

    @Override
    public MapDef asMap() {
        return this;
    }

    @Override
    public MapValueImpl createMap() {
        return new MapValueImpl(this);
    }

    @Override
    public FieldDefImpl getElement() {
        return this.element;
    }

    @Override
    public FieldDef getKeyDefinition() {
        return FieldDefImpl.stringDef;
    }

    @Override
    public boolean isPrecise() {
        return this.element.isPrecise();
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        if (this == superType) {
            return true;
        }
        if (superType.isMap()) {
            MapDefImpl supMap = (MapDefImpl)superType;
            return this.element.isSubtype(supMap.element);
        }
        if (superType.isJson()) {
            return this.element.isSubtype(jsonDef);
        }
        return superType.isAny();
    }

    @Override
    FieldDefImpl findField(String fieldName) {
        return this.element;
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        ObjectNode collNode = node.putObject("collection");
        if (this.element != null) {
            this.element.toJson(collNode);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Default value for type MAP is not a map");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for map must be null or an empty map");
        }
        return this.createMap();
    }

    @Override
    public short getRequiredSerialVersion() {
        return this.element.getRequiredSerialVersion();
    }

    @Override
    int countTypes() {
        return this.element.countTypes() + 1;
    }
}

