/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class NumberUtils {
    private static final byte TERMINATOR = -1;
    private static final byte POSI_INFINITY = -1;
    private static final byte NEG_INFINITY = 0;
    private static final byte ZERO = NumberUtils.excess128(0);
    private static final byte[] BYTES_ZERO = new byte[]{ZERO};
    private static final int LONG_MAX_DIGITS_NUM = String.valueOf(Long.MAX_VALUE).length();

    public static byte[] serialize(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return BYTES_ZERO;
        }
        BigDecimal decimal = value.stripTrailingZeros();
        int sign = decimal.signum();
        String mantissa = decimal.unscaledValue().abs().toString();
        int exponent = mantissa.length() - 1 - decimal.scale();
        return NumberUtils.writeBytes(sign, exponent, mantissa);
    }

    public static byte[] serialize(long value) {
        int mlen;
        if (value == 0L) {
            return BYTES_ZERO;
        }
        char[] digits = Long.toString(value).toCharArray();
        for (mlen = digits.length; mlen > 0 && digits[mlen - 1] == '0'; --mlen) {
        }
        int sign = value > 0L ? 1 : -1;
        int start = sign > 0 ? 0 : 1;
        int exponent = digits.length - 1 - start;
        return NumberUtils.writeBytes(sign, exponent, digits, start, mlen - start);
    }

    private static byte[] writeBytes(int sign, int exponent, String digits) {
        return NumberUtils.writeBytes(sign, exponent, digits.toCharArray(), 0, digits.length());
    }

    private static byte[] writeBytes(int sign, int exponent, char[] digits, int from, int len) {
        int nLeadingBytes = NumberUtils.getNumBytesExponent(sign, exponent);
        int size = nLeadingBytes + (len + 1) / 2 + 1;
        byte[] bytes = new byte[size];
        NumberUtils.writeExponent(bytes, 0, sign, exponent);
        NumberUtils.writeMantissa(bytes, nLeadingBytes, sign, digits, from, len);
        return bytes;
    }

    static void writeExponent(byte[] buffer, int offset, int sign, int value) {
        if (sign == 0) {
            buffer[offset] = -128;
        } else if (sign > 0) {
            if (value >= 4097) {
                NumberUtils.writeExponentMultiBytes(buffer, offset, (byte)-9, value - 4097);
            } else if (value >= 64) {
                NumberUtils.writeExponentTwoBytes(buffer, offset, (byte)-25, value - 64);
            } else if (value >= -16) {
                buffer[offset] = (byte)(151 + (value - -16));
            } else if (value >= -4096) {
                NumberUtils.writeExponentTwoBytes(buffer, offset, (byte)-121, value - -4096);
            } else {
                NumberUtils.writeExponentMultiBytes(buffer, offset, (byte)-125, value - Integer.MIN_VALUE);
            }
        } else if (value <= -4097) {
            NumberUtils.writeExponentMultiBytes(buffer, offset, (byte)122, -4097 - value);
        } else if (value <= -17) {
            NumberUtils.writeExponentTwoBytes(buffer, offset, (byte)106, -17 - value);
        } else if (value <= 63) {
            buffer[offset] = (byte)(26 + (63 - value));
        } else if (value <= 4096) {
            NumberUtils.writeExponentTwoBytes(buffer, offset, (byte)10, 4096 - value);
        } else {
            NumberUtils.writeExponentMultiBytes(buffer, offset, (byte)6, Integer.MAX_VALUE - value);
        }
    }

    private static void writeExponentTwoBytes(byte[] buffer, int offset, byte byte0, int exponent) {
        buffer[offset++] = (byte)(byte0 + (exponent >> 8 & 0xF));
        buffer[offset] = (byte)(exponent & 0xFF);
    }

    private static void writeExponentMultiBytes(byte[] buffer, int offset, byte byte0, int exponent) {
        int size = NumberUtils.getNumBytesExponentVarLen(exponent);
        buffer[offset++] = (byte)(byte0 + (size - 2));
        if (size > 4) {
            buffer[offset++] = (byte)(exponent >>> 24);
        }
        if (size > 3) {
            buffer[offset++] = (byte)(exponent >>> 16);
        }
        if (size > 2) {
            buffer[offset++] = (byte)(exponent >>> 8);
        }
        buffer[offset] = (byte)exponent;
    }

    static int getNumBytesExponent(int sign, int value) {
        if (sign == 0) {
            return 1;
        }
        if (sign > 0) {
            if (value >= 4097) {
                return NumberUtils.getNumBytesExponentVarLen(value - 4097);
            }
            if (value >= 64) {
                return 2;
            }
            if (value >= -16) {
                return 1;
            }
            if (value >= -4096) {
                return 2;
            }
            return NumberUtils.getNumBytesExponentVarLen(value - Integer.MIN_VALUE);
        }
        if (value <= -4097) {
            return NumberUtils.getNumBytesExponentVarLen(-4097 - value);
        }
        if (value <= -17) {
            return 2;
        }
        if (value <= 63) {
            return 1;
        }
        if (value <= 4096) {
            return 2;
        }
        return NumberUtils.getNumBytesExponentVarLen(Integer.MAX_VALUE - value);
    }

    private static int getNumBytesExponentVarLen(int exponent) {
        if ((exponent & 0xFF000000) != 0) {
            return 5;
        }
        if ((exponent & 0xFF0000) != 0) {
            return 4;
        }
        if ((exponent & 0xFF00) != 0) {
            return 3;
        }
        return 2;
    }

    private static void writeMantissa(byte[] buffer, int offset, int sign, char[] digits, int start, int len) {
        for (int ind = 0; ind < len / 2; ++ind) {
            NumberUtils.writeByte(buffer, offset++, sign, digits, start + ind * 2);
        }
        if (len % 2 == 1) {
            int last = start + len - 1;
            NumberUtils.writeByte(buffer, offset++, sign, new char[]{digits[last], '0'}, 0);
        }
        buffer[offset] = NumberUtils.excess128(-1);
    }

    private static void writeByte(byte[] buffer, int offset, int sign, char[] digits, int index) {
        assert (digits.length > index + 1);
        int value = (digits[index] - 48) * 10 + (digits[index + 1] - 48);
        if (sign < 0) {
            value = -1 * value;
        }
        buffer[offset] = NumberUtils.toUnsignedByte(value);
    }

    private static byte toUnsignedByte(int value) {
        if (value < 0) {
            value -= 2;
        }
        return NumberUtils.excess128(value);
    }

    public static Object deserialize(byte[] bytes) {
        return NumberUtils.deserialize(bytes, true, false);
    }

    public static Object deserialize(byte[] bytes, boolean returnBigDecimalOnly) {
        return NumberUtils.deserialize(bytes, returnBigDecimalOnly, false);
    }

    static void validateValue(byte[] bytes) {
        NumberUtils.deserialize(bytes, false, true);
    }

    private static Object deserialize(byte[] bytes, boolean returnBigDecimalOnly, boolean validate) {
        byte byte0;
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Invalid bytes for Number value, it must not be null or empty");
        }
        int offset = 0;
        if (!NumberUtils.isValidLeadingByte(byte0 = bytes[offset++])) {
            throw new IllegalArgumentException("Invalid leading byte: " + byte0);
        }
        int sign = NumberUtils.readSign(byte0);
        if (sign == 0) {
            if (offset != bytes.length) {
                throw new IllegalArgumentException("Invalid bytes for Number value");
            }
            return returnBigDecimalOnly ? new BigDecimal(0) : Integer.valueOf(0);
        }
        ReadBuffer in = new ReadBuffer(bytes, offset);
        int exponent = NumberUtils.readExponent(in, byte0, sign);
        if (in.available() < 2) {
            throw new IllegalArgumentException("Invalid bytes for Number value");
        }
        if (validate) {
            return null;
        }
        return NumberUtils.createNumericObject(in, returnBigDecimalOnly, sign, exponent);
    }

    static int readExponent(ReadBuffer in, byte byte0, int sign) {
        if (sign == 0) {
            return 0;
        }
        if (sign > 0) {
            if (byte0 >= -9) {
                return NumberUtils.readExponentMultiBytes(in, byte0, (byte)-9) + 4097;
            }
            if (byte0 >= -25) {
                return NumberUtils.readExponentTwoBytes(in, byte0, (byte)-25) + 64;
            }
            if (byte0 >= -105) {
                return byte0 - -105 + -16;
            }
            if (byte0 >= -121) {
                return NumberUtils.readExponentTwoBytes(in, byte0, (byte)-121) + -4096;
            }
            return NumberUtils.readExponentMultiBytes(in, byte0, (byte)-125) + Integer.MIN_VALUE;
        }
        if (byte0 >= 122) {
            return -4097 - NumberUtils.readExponentMultiBytes(in, byte0, (byte)122);
        }
        if (byte0 >= 106) {
            return -17 - NumberUtils.readExponentTwoBytes(in, byte0, (byte)106);
        }
        if (byte0 >= 26) {
            return 63 - (byte0 - 26);
        }
        if (byte0 >= 10) {
            return 4096 - NumberUtils.readExponentTwoBytes(in, byte0, (byte)10);
        }
        return Integer.MAX_VALUE - NumberUtils.readExponentMultiBytes(in, byte0, (byte)6);
    }

    private static boolean isValidLeadingByte(byte byte0) {
        return byte0 >= -125 && byte0 <= -6 || byte0 >= 6 && byte0 <= 125 || byte0 == -128 || byte0 == 0 || byte0 == -1;
    }

    private static int readExponentTwoBytes(ReadBuffer in, byte byte0, byte base) {
        if (in.available() == 0) {
            throw new IllegalArgumentException("Invalid exponent value for Number");
        }
        return byte0 - base << 8 | in.read() & 0xFF;
    }

    private static int readExponentMultiBytes(ReadBuffer in, byte byte0, byte base) {
        int len = byte0 - base + 1;
        int exp = 0;
        if (in.available() < len) {
            throw new IllegalArgumentException("Invalid exponent value for Number");
        }
        while (len-- > 0) {
            exp = exp << 8 | in.read() & 0xFF;
        }
        return exp;
    }

    private static Object createNumericObject(ReadBuffer in, boolean returnBigDecimalOnly, int sign, int expo) {
        int val;
        int size = (in.available() - 1) * 2;
        char[] buf = new char[size];
        int ind = 0;
        while ((val = NumberUtils.excess128(in.read())) != -1) {
            String group;
            if (val < 0) {
                val += 2;
            }
            if ((group = Integer.toString(Math.abs(val))).length() == 1) {
                buf[ind++] = 48;
                buf[ind++] = group.charAt(0);
                continue;
            }
            buf[ind++] = group.charAt(0);
            buf[ind++] = group.charAt(1);
        }
        if (buf[ind - 1] == '0') {
            --ind;
        }
        String digits = new String(buf, 0, ind);
        if (!returnBigDecimalOnly && expo >= 0 && expo < LONG_MAX_DIGITS_NUM && digits.length() <= expo + 1) {
            int num = expo + 1;
            if (digits.length() < num) {
                digits = String.format("%-" + num + "s", digits).replace(' ', '0');
            }
            String signedDigits = sign < 0 ? "-" + digits : digits;
            try {
                long lval = Long.parseLong(signedDigits);
                if (lval >= Integer.MIN_VALUE && lval <= Integer.MAX_VALUE) {
                    return (int)lval;
                }
                return lval;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BigInteger unscaled = new BigInteger(digits);
        if (sign < 0) {
            unscaled = unscaled.negate();
        }
        return new BigDecimal(unscaled, digits.length() - 1).scaleByPowerOfTen(expo);
    }

    static byte[] readTuple(TupleInput in) {
        byte b;
        byte byte0 = (byte)in.read();
        int sign = NumberUtils.readSign(byte0);
        if (sign == 0) {
            return new byte[]{byte0};
        }
        WriteBuffer buffer = new WriteBuffer();
        NumberUtils.readLeadingBytes(in, byte0, sign, buffer);
        byte end = NumberUtils.excess128(-1);
        while ((b = (byte)in.read()) != end) {
            buffer.write(b);
        }
        buffer.write(end);
        return buffer.toByteArray();
    }

    private static void readLeadingBytes(TupleInput in, byte byte0, int sign, WriteBuffer buffer) {
        buffer.write(byte0);
        if (sign == 0) {
            return;
        }
        if (in.available() == 0) {
            throw new IllegalStateException("Failed to read leading bytes");
        }
        if (sign > 0) {
            if (byte0 >= -9) {
                NumberUtils.readLeadingMultiBytes(in, byte0, (byte)-9, buffer);
            } else if (byte0 >= -25) {
                buffer.write((byte)in.read());
            } else {
                if (byte0 >= -105) {
                    return;
                }
                if (byte0 >= -121) {
                    buffer.write((byte)in.read());
                } else {
                    NumberUtils.readLeadingMultiBytes(in, byte0, (byte)-125, buffer);
                }
            }
        } else if (byte0 >= 122) {
            NumberUtils.readLeadingMultiBytes(in, byte0, (byte)122, buffer);
        } else if (byte0 >= 106) {
            buffer.write((byte)in.read());
        } else {
            if (byte0 >= 26) {
                return;
            }
            if (byte0 >= 10) {
                buffer.write((byte)in.read());
            } else {
                NumberUtils.readLeadingMultiBytes(in, byte0, (byte)6, buffer);
            }
        }
    }

    private static void readLeadingMultiBytes(TupleInput in, byte byte0, byte base, WriteBuffer buffer) {
        int len = byte0 - base + 1;
        if (in.available() < len) {
            throw new IllegalStateException("Failed to read leading bytes");
        }
        for (int i = 0; i < len; ++i) {
            buffer.write((byte)in.read());
        }
    }

    static byte[] nextUp(byte[] bytes) {
        if (NumberUtils.readSign(bytes[0]) == 0) {
            return new byte[]{(byte)(ZERO + 1)};
        }
        byte[] next = Arrays.copyOf(bytes, bytes.length);
        next[next.length - 1] = ZERO;
        return next;
    }

    private static int readSign(byte byte0) {
        return byte0 == -128 ? 0 : ((byte0 & 0x80) > 0 ? 1 : -1);
    }

    private static byte excess128(int b) {
        return (byte)(b ^ 0x80);
    }

    static byte[] getNegativeInfinity() {
        return new byte[]{0};
    }

    static byte[] getPositiveInfinity() {
        return new byte[]{-1};
    }

    static class WriteBuffer {
        private static final int INIT_SIZE = 32;
        private static final int BUMP_SIZE = 32;
        private byte[] bytes;
        private int offset;

        WriteBuffer() {
            this(32);
        }

        WriteBuffer(int size) {
            this.bytes = new byte[size];
            this.offset = 0;
        }

        void write(byte val) {
            if (this.offset == this.bytes.length) {
                this.increaseBytes();
            }
            this.bytes[this.offset++] = val;
        }

        byte[] toByteArray() {
            return Arrays.copyOf(this.bytes, this.offset);
        }

        private void increaseBytes() {
            this.offset = this.bytes.length;
            this.bytes = Arrays.copyOf(this.bytes, this.bytes.length + 32);
        }
    }

    static class ReadBuffer {
        private final byte[] bytes;
        private int offset;

        ReadBuffer(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }

        byte read() {
            if (this.offset < this.bytes.length) {
                return this.bytes[this.offset++];
            }
            return -1;
        }

        int available() {
            return this.bytes.length - this.offset;
        }
    }
}

