/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.RecordDef;

public class RecordBuilder
extends TableBuilderBase {
    private final String name;
    private String description;

    RecordBuilder(String name, String description) {
        this.name = name;
        this.description = description;
    }

    RecordBuilder(String name) {
        this.name = name;
    }

    @Override
    public String getBuilderType() {
        return "Record";
    }

    @Override
    public RecordDef build() {
        if (this.name == null) {
            return new RecordDefImpl(this.fields, this.description);
        }
        return new RecordDefImpl(this.name, this.fields, this.description);
    }

    @Override
    public TableBuilderBase addField(String name1, FieldDef def) {
        if (name1 == null) {
            throw new IllegalArgumentException("Record fields must have names");
        }
        return super.addField(name1, def);
    }

    @Override
    public TableBuilderBase setDescription(String description) {
        this.description = description;
        return this;
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        RecordDefImpl tmp = new RecordDefImpl(this.name, this.fields, this.description);
        tmp.toJson(o);
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }
}

