/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.RecordDef;

public class RecordDefImpl
extends FieldDefImpl
implements RecordDef {
    private static final long serialVersionUID = 1L;
    private final FieldMap fieldMap;
    private String name;

    RecordDefImpl(FieldMap fieldMap, String description) {
        super(FieldDef.Type.RECORD, description);
        if (fieldMap == null || fieldMap.isEmpty()) {
            throw new IllegalArgumentException("Record has no fields and cannot be built");
        }
        this.name = null;
        this.fieldMap = fieldMap;
    }

    RecordDefImpl(String name, FieldMap fieldMap, String description) {
        this(fieldMap, description);
        if (name == null) {
            throw new IllegalArgumentException("Record requires a name");
        }
        this.name = name;
    }

    RecordDefImpl(String name, FieldMap fieldMap) {
        this(name, fieldMap, null);
    }

    private RecordDefImpl(RecordDefImpl impl) {
        super(impl);
        this.name = impl.name;
        this.fieldMap = impl.fieldMap.clone();
    }

    @Override
    public RecordDefImpl clone() {
        return new RecordDefImpl(this);
    }

    @Override
    public int hashCode() {
        return this.fieldMap.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RecordDefImpl) {
            RecordDefImpl otherDef = (RecordDefImpl)other;
            if (this == otherDef) {
                return true;
            }
            return this.fieldMap.equals(otherDef.fieldMap);
        }
        return false;
    }

    @Override
    public RecordDef asRecord() {
        return this;
    }

    @Override
    public RecordValueImpl createRecord() {
        return new RecordValueImpl(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumFields() {
        return this.fieldMap.size();
    }

    @Override
    public boolean contains(String name1) {
        return this.fieldMap.exists(name1);
    }

    @Override
    public FieldDefImpl getField(String name1) {
        return this.getFieldDef(name1);
    }

    @Override
    public FieldDefImpl getFieldDef(String name1) {
        return this.fieldMap.getFieldDef(name1);
    }

    @Override
    public FieldDefImpl getField(int pos) {
        return this.getFieldDef(pos);
    }

    @Override
    public FieldDefImpl getFieldDef(int pos) {
        return this.fieldMap.getFieldDef(pos);
    }

    @Override
    public List<String> getFields() {
        return this.getFieldNames();
    }

    @Override
    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldMap.getFieldNames());
    }

    @Override
    public String getFieldName(int pos) {
        return this.fieldMap.getFieldName(pos);
    }

    @Override
    public int getFieldPos(String fname) {
        return this.fieldMap.getFieldPos(fname);
    }

    @Override
    public boolean isNullable(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.isNullable();
    }

    @Override
    public boolean isNullable(int pos) {
        return this.fieldMap.isNullable(pos);
    }

    @Override
    public FieldValueImpl getDefaultValue(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.getDefaultValue();
    }

    @Override
    public FieldValueImpl getDefaultValue(int pos) {
        return this.fieldMap.getDefaultValue(pos);
    }

    @Override
    public boolean isPrecise() {
        return this.fieldMap.isPrecise();
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        if (this == superType) {
            return true;
        }
        if (superType.isRecord()) {
            return this.fieldMap.isSubtype(((RecordDefImpl)superType).getFieldMap());
        }
        return superType.isAny() || superType.isAnyRecord();
    }

    @Override
    FieldDefImpl findField(String fieldName) {
        return this.fieldMap.getFieldDef(fieldName);
    }

    @Override
    void toJson(ObjectNode node) {
        node.put("name", this.name);
        super.toJson(node);
        this.fieldMap.putFields(node);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Default value for type RECORD is not a record");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for record must be null or an empty record");
        }
        return this.createRecord();
    }

    @Override
    public short getRequiredSerialVersion() {
        return this.fieldMap.getRequiredSerialVersion();
    }

    public List<String> getFieldNamesInternal() {
        return this.fieldMap.getFieldNames();
    }

    public void setName(String n) {
        this.name = n;
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Record types require a name");
        }
    }

    List<FieldMapEntry> getFieldProperties() {
        return this.getFieldMap().getFieldProperties();
    }

    public FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist) {
        FieldMapEntry fme = this.fieldMap.getFieldMapEntry(fieldName);
        if (fme != null) {
            return fme;
        }
        if (mustExist) {
            throw new IllegalArgumentException("Record definition does not have a field named " + fieldName);
        }
        return null;
    }

    @Override
    int countTypes() {
        int num = 1;
        for (int i = 0; i < this.getNumFields(); ++i) {
            FieldMapEntry fme = this.fieldMap.getFieldMapEntry(i);
            num += fme.getFieldDef().countTypes();
        }
        return num;
    }
}

