/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;

public class RecordValueImpl
extends ComplexValueImpl
implements RecordValue,
ValueSerializer.RecordValueSerializer {
    private static final long serialVersionUID = 1L;
    @Deprecated
    protected Map<String, FieldValue> valueMap;
    private int size;
    private FieldValue[] values;

    RecordValueImpl(RecordDef def) {
        super(def);
        this.size = 0;
        this.valueMap = null;
        this.values = new FieldValue[this.getDefinition().getNumFields()];
    }

    RecordValueImpl(RecordValueImpl other) {
        super(other.getDefinition());
        this.valueMap = null;
        this.values = new FieldValue[this.getDefinition().getNumFields()];
        this.copyFields(other);
    }

    RecordValueImpl() {
        super(null);
        this.size = 0;
        this.values = null;
        this.valueMap = null;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        try {
            int numFields = this.values.length;
            this.valueMap = new TreeMap<String, FieldValue>(FieldComparator.instance);
            for (int i = 0; i < numFields; ++i) {
                if (this.values[i] == null) continue;
                this.valueMap.put(this.getFieldName(i), this.values[i]);
            }
            out.defaultWriteObject();
            this.valueMap = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.convertToNewFormat();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    void convertToNewFormat() {
        int numFields = this.getDefinition().getNumFields();
        this.values = new FieldValue[numFields];
        this.size = 0;
        for (int i = 0; i < numFields; ++i) {
            FieldValue fvalue;
            String fname = this.getFieldName(i);
            this.values[i] = fvalue = this.valueMap.get(fname);
            if (fvalue == null) continue;
            ++this.size;
        }
        this.valueMap = null;
    }

    @Override
    public RecordValueImpl clone() {
        return new RecordValueImpl(this);
    }

    @Override
    public long sizeof() {
        long sz = super.sizeof();
        sz += (long)(2 * SizeOf.OBJECT_REF_OVERHEAD + 4 + SizeOf.objectArraySize(this.values.length));
        for (FieldValue fval : this.values) {
            sz += ((FieldValueImpl)fval).sizeof();
        }
        return sz;
    }

    public int hashCode() {
        int code = this.size;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            code += this.values[i].hashCode() + this.getFieldName(i).hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecordValueImpl)) {
            return false;
        }
        RecordValueImpl otherValue = (RecordValueImpl)other;
        if (this.size != otherValue.size || !this.getDefinition().equals(otherValue.getDefinition())) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) {
                if (otherValue.values[i] == null) continue;
                return false;
            }
            if (otherValue.values[i] == null) {
                return false;
            }
            if (this.values[i].equals(otherValue.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (!(other instanceof RecordValueImpl)) {
            throw new ClassCastException("Object is not an RecordValue");
        }
        RecordValueImpl otherImpl = (RecordValueImpl)other;
        if (!this.getDefinition().equals(otherImpl.getDefinition())) {
            throw new IllegalArgumentException("Cannot compare RecordValues with different definitions");
        }
        for (int i = 0; i < this.values.length; ++i) {
            int ret = RecordValueImpl.compareFieldValues(this.values[i], otherImpl.values[i]);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.RECORD;
    }

    @Override
    public RecordDefImpl getDefinition() {
        return (RecordDefImpl)this.fieldDef;
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    @Override
    public RecordValue asRecord() {
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public List<String> getFields() {
        return this.getFieldNames();
    }

    @Override
    public List<String> getFieldNames() {
        return this.getDefinition().getFieldNames();
    }

    public List<String> getFieldNamesInternal() {
        return this.getDefinition().getFieldNamesInternal();
    }

    @Override
    public String getFieldName(int pos) {
        return this.getDefinition().getFieldName(pos);
    }

    @Override
    public int getFieldPos(String fieldName) {
        return this.getDefinition().getFieldPos(fieldName);
    }

    @Override
    public FieldValueImpl get(String fieldName) {
        int pos = this.getDefinition().getFieldPos(fieldName);
        return (FieldValueImpl)this.values[pos];
    }

    @Override
    public FieldValueImpl get(int pos) {
        return (FieldValueImpl)this.values[pos];
    }

    @Override
    public boolean contains(String fieldName) {
        int pos = this.getFieldPos(fieldName);
        return this.values[pos] != null;
    }

    @Override
    public boolean contains(int pos) {
        return this.values[pos] != null;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
        this.size = 0;
    }

    @Override
    public FieldValue remove(String name) {
        int pos = this.getFieldPos(name);
        FieldValue val = this.values[pos];
        this.values[pos] = null;
        if (val != null) {
            --this.size;
        }
        return val;
    }

    @Override
    public void copyFrom(RecordValue source) {
        this.copyFrom(source, false);
    }

    @Override
    public RecordValue put(int pos, FieldValue value) {
        if (value.isNull()) {
            return this.putNull(pos);
        }
        if (value.isJsonNull()) {
            return this.putJsonNull(pos);
        }
        if (((FieldValueImpl)value).isEMPTY()) {
            return this.putEMPTY(pos);
        }
        value = this.validateValueType(pos, value);
        this.putInternal(pos, value);
        return this;
    }

    @Override
    public RecordValue put(String name, FieldValue value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(String name, int value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, int value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createInteger(value));
        return this;
    }

    @Override
    public RecordValue put(String name, long value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, long value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createLong(value));
        return this;
    }

    @Override
    public RecordValue put(String name, String value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, String value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createString(value));
        return this;
    }

    @Override
    public RecordValue put(String name, double value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, double value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createDouble(value));
        return this;
    }

    @Override
    public RecordValue putJson(String name, String jsonInput) {
        int pos = this.getFieldPos(name);
        return this.putJson(pos, jsonInput);
    }

    @Override
    public RecordValue putJson(String name, Reader jsonReader) {
        int pos = this.getFieldPos(name);
        return this.putJson(pos, jsonReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordValue putJson(int pos, String jsonInput) {
        StringReader reader = new StringReader(jsonInput);
        try {
            RecordValue recordValue = this.putJson(pos, (Reader)reader);
            return recordValue;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public RecordValue putJson(int pos, Reader jsonReader) {
        FieldDefImpl def = this.getFieldDef(pos);
        if (!def.isJson()) {
            throw new IllegalArgumentException("putJson: field at position " + pos + "is not of type JSON");
        }
        this.putInternal(pos, JsonDefImpl.createFromReader(jsonReader));
        return this;
    }

    @Override
    public RecordValue put(String name, float value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, float value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createFloat(value));
        return this;
    }

    @Override
    public RecordValue put(String name, boolean value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, boolean value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createBoolean(value));
        return this;
    }

    @Override
    public RecordValue putNumber(String name, int value) {
        int pos = this.getFieldPos(name);
        return this.putNumber(pos, value);
    }

    @Override
    public RecordValue putNumber(int pos, int value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createNumber(value));
        return this;
    }

    @Override
    public RecordValue putNumber(String name, long value) {
        int pos = this.getFieldPos(name);
        return this.putNumber(pos, value);
    }

    @Override
    public RecordValue putNumber(int pos, long value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createNumber(value));
        return this;
    }

    @Override
    public RecordValue putNumber(String name, float value) {
        int pos = this.getFieldPos(name);
        return this.putNumber(pos, value);
    }

    @Override
    public RecordValue putNumber(int pos, float value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createNumber(value));
        return this;
    }

    @Override
    public RecordValue putNumber(String name, double value) {
        int pos = this.getFieldPos(name);
        return this.putNumber(pos, value);
    }

    @Override
    public RecordValue putNumber(int pos, double value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createNumber(value));
        return this;
    }

    @Override
    public RecordValue putNumber(String name, BigDecimal value) {
        int pos = this.getFieldPos(name);
        return this.putNumber(pos, value);
    }

    @Override
    public RecordValue putNumber(int pos, BigDecimal value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createNumber(value));
        return this;
    }

    @Override
    public RecordValue put(String name, byte[] value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, byte[] value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createBinary(value));
        return this;
    }

    @Override
    public RecordValue putFixed(String name, byte[] value) {
        int pos = this.getFieldPos(name);
        return this.putFixed(pos, value);
    }

    @Override
    public RecordValue putFixed(int pos, byte[] value) {
        this.putInternal(pos, (FieldValue)this.getFieldDef(pos).createFixedBinary(value));
        return this;
    }

    @Override
    public RecordValue putEnum(String name, String value) {
        int pos = this.getFieldPos(name);
        return this.putEnum(pos, value);
    }

    @Override
    public RecordValue putEnum(int pos, String value) {
        EnumDefImpl fdef = (EnumDefImpl)this.getFieldDef(pos);
        this.putInternal(pos, (FieldValue)fdef.createEnum(value));
        return this;
    }

    @Override
    public RecordValue put(String name, Timestamp value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public RecordValue put(int pos, Timestamp value) {
        TimestampDefImpl fdef = (TimestampDefImpl)this.getFieldDef(pos);
        this.putInternal(pos, (FieldValue)fdef.createTimestamp(value));
        return this;
    }

    @Override
    public RecordValue putNull(String name) {
        int pos = this.getFieldPos(name);
        return this.putNull(pos);
    }

    @Override
    public RecordValue putJsonNull(String name) {
        int pos = this.getFieldPos(name);
        return this.putJsonNull(pos);
    }

    @Override
    public RecordValue putNull(int pos) {
        if (!this.getDefinition().isNullable(pos)) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Field \"" + fname + "\" is not nullable");
        }
        this.putInternal(pos, (FieldValue)NullValueImpl.getInstance());
        return this;
    }

    @Override
    public RecordValue putJsonNull(int pos) {
        FieldDefImpl fdef = this.getDefinition().getFieldDef(pos);
        if (!(fdef.isJson() || fdef.isJsonAtomic() || fdef.isAny() || fdef.isAnyAtomic())) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Field \"" + fname + "\" is not JSON. It's type is:\n" + this.getDefinition().getFieldDef(pos).getDDLString());
        }
        this.putInternal(pos, (FieldValue)NullJsonValueImpl.getInstance());
        return this;
    }

    public RecordValue putEMPTY(int pos) {
        if (!this.getDefinition().isNullable(pos)) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Field \"" + fname + "\" is not nullable");
        }
        this.putInternal(pos, (FieldValue)EmptyValueImpl.getInstance());
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String name) {
        int pos = this.getFieldPos(name);
        return this.putRecord(pos);
    }

    @Override
    public RecordValueImpl putRecord(int pos) {
        RecordValueImpl val = this.getFieldDef(pos).createRecord();
        this.putInternal(pos, (FieldValue)val);
        return val;
    }

    @Override
    public RecordValue putRecord(String name, Map<String, ?> map) {
        int pos = this.getFieldPos(name);
        return this.putRecord(pos, map);
    }

    @Override
    public RecordValue putRecord(int pos, Map<String, ?> map) {
        RecordValueImpl val;
        this.validateValueKind(pos, FieldDef.Type.RECORD);
        try {
            val = RecordValueImpl.fromJavaObjectValue(this.getFieldDef(pos), map);
        }
        catch (ClassCastException cce) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Cannot set field \"" + fname + "\" to the given java map object, because the java map doesn't match the type definition of the field.", cce);
        }
        this.putInternal(pos, (FieldValue)val);
        return this;
    }

    @Override
    public RecordValue putRecordAsJson(String name, String jsonInput, boolean exact) {
        return this.putRecordAsJson(name, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putRecordAsJson(String name, InputStream jsonInput, boolean exact) {
        int pos = this.getFieldPos(name);
        return this.putRecordAsJson(pos, jsonInput, exact);
    }

    @Override
    public RecordValue putRecordAsJson(int pos, String jsonInput, boolean exact) {
        return this.putRecordAsJson(pos, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putRecordAsJson(int pos, InputStream jsonInput, boolean exact) {
        RecordValueImpl record = this.getFieldDef(pos).createRecord();
        ComplexValueImpl.createFromJson(record, jsonInput, exact);
        this.putInternal(pos, (FieldValue)record);
        return this;
    }

    @Override
    public ArrayValueImpl putArray(String name) {
        int pos = this.getFieldPos(name);
        return this.putArray(pos);
    }

    @Override
    public ArrayValueImpl putArray(int pos) {
        ArrayValue val = this.getFieldDef(pos).createArray();
        this.putInternal(pos, (FieldValue)val);
        return (ArrayValueImpl)val;
    }

    @Override
    public RecordValue putArray(String name, Iterable<?> list) {
        int pos = this.getFieldPos(name);
        return this.putArray(pos, list);
    }

    @Override
    public RecordValue putArray(int pos, Iterable<?> list) {
        ArrayValueImpl val;
        this.validateValueKind(pos, FieldDef.Type.ARRAY);
        try {
            val = ArrayValueImpl.fromJavaObjectValue(this.getFieldDef(pos), list);
        }
        catch (ClassCastException cce) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Cannot set field \"" + fname + "\" to the given java list object, because the java list doesn't match the type definition of the field.", cce);
        }
        this.putInternal(pos, (FieldValue)val);
        return this;
    }

    @Override
    public RecordValue putArray(String name, Object[] array) {
        int pos = this.getFieldPos(name);
        return this.putArray(pos, array);
    }

    @Override
    public RecordValue putArray(int pos, Object[] array) {
        ArrayValueImpl val;
        this.validateValueKind(pos, FieldDef.Type.ARRAY);
        try {
            val = ArrayValueImpl.fromJavaObjectValue(this.getFieldDef(pos), array);
        }
        catch (ClassCastException cce) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Cannot set field \"" + fname + "\" to the given java array object, because the java array doesn't match the type definition of the field.", cce);
        }
        this.putInternal(pos, (FieldValue)val);
        return this;
    }

    @Override
    public RecordValue putArrayAsJson(String name, String jsonInput, boolean exact) {
        return this.putArrayAsJson(name, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putArrayAsJson(String name, InputStream jsonInput, boolean exact) {
        int pos = this.getFieldPos(name);
        return this.putArrayAsJson(pos, jsonInput, exact);
    }

    @Override
    public RecordValue putArrayAsJson(int pos, String jsonInput, boolean exact) {
        return this.putArrayAsJson(pos, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putArrayAsJson(int pos, InputStream jsonInput, boolean exact) {
        ArrayValue array = this.getFieldDef(pos).createArray();
        ComplexValueImpl.createFromJson((ArrayValueImpl)array, jsonInput, exact);
        this.putInternal(pos, (FieldValue)array);
        return this;
    }

    @Override
    public MapValueImpl putMap(String name) {
        int pos = this.getFieldPos(name);
        return this.putMap(pos);
    }

    @Override
    public MapValueImpl putMap(int pos) {
        MapValue val = this.getFieldDef(pos).createMap();
        this.putInternal(pos, (FieldValue)val);
        return (MapValueImpl)val;
    }

    @Override
    public RecordValue putMap(String name, Map<String, ?> map) {
        int pos = this.getFieldPos(name);
        return this.putMap(pos, map);
    }

    @Override
    public RecordValue putMap(int pos, Map<String, ?> map) {
        MapValueImpl val;
        this.validateValueKind(pos, FieldDef.Type.MAP);
        try {
            val = MapValueImpl.fromJavaObjectValue(this.getFieldDef(pos), map);
        }
        catch (ClassCastException cce) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Cannot set field \"" + fname + "\" to the given java map object, because the java map doesn't match the type definition of the field.", cce);
        }
        this.putInternal(pos, (FieldValue)val);
        return this;
    }

    @Override
    public RecordValue putMapAsJson(String name, String jsonInput, boolean exact) {
        return this.putMapAsJson(name, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putMapAsJson(String name, InputStream jsonInput, boolean exact) {
        int pos = this.getFieldPos(name);
        return this.putMapAsJson(pos, jsonInput, exact);
    }

    @Override
    public RecordValue putMapAsJson(int pos, String jsonInput, boolean exact) {
        return this.putMapAsJson(pos, (InputStream)new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putMapAsJson(int pos, InputStream jsonInput, boolean exact) {
        MapValue map = this.getFieldDef(pos).createMap();
        ComplexValueImpl.createFromJson((MapValueImpl)map, jsonInput, exact);
        this.putInternal(pos, (FieldValue)map);
        return this;
    }

    @Override
    public void addJsonFields(JsonParser jp, String currentFieldName, boolean exact, boolean addMissingFields) {
        int numFields = 0;
        try {
            JsonToken t = jp.getCurrentToken();
            JsonLocation location = jp.getCurrentLocation();
            if (t != JsonToken.START_OBJECT) {
                RecordValueImpl.jsonParseException("Expected { token to start object, instead found " + (Object)((Object)t), location);
            }
            while ((t = jp.nextToken()) != JsonToken.END_OBJECT) {
                int pos;
                String fieldName;
                if (t == null || t == JsonToken.END_ARRAY) {
                    RecordValueImpl.jsonParseException("Did not find end of object", location);
                }
                if ((fieldName = jp.getCurrentName()) == null) continue;
                try {
                    pos = this.getFieldPos(fieldName);
                }
                catch (IllegalArgumentException e) {
                    if (exact) {
                        throw new IllegalArgumentException("Unexpected field \"" + fieldName + "\" in JSON input. There is no corresponding field in record type definition");
                    }
                    JsonToken token = jp.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        RecordValueImpl.skipToJsonToken(jp, JsonToken.END_OBJECT);
                        continue;
                    }
                    if (token != JsonToken.START_ARRAY) continue;
                    RecordValueImpl.skipToJsonToken(jp, JsonToken.END_ARRAY);
                    continue;
                }
                JsonToken token = jp.nextToken();
                FieldDefImpl fdef = this.getFieldDef(pos);
                if (token == JsonToken.VALUE_NULL && !fdef.isJson()) {
                    if (this.getDefinition().isNullable(pos)) {
                        this.putNull(pos);
                        ++numFields;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldName);
                }
                switch (fdef.getType()) {
                    case INTEGER: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.INT, jp);
                        this.put(pos, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.LONG, jp);
                        this.put(pos, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.DOUBLE, jp);
                        this.put(pos, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.FLOAT, jp);
                        this.put(pos, jp.getFloatValue());
                        break;
                    }
                    case NUMBER: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.BIG_DECIMAL, jp);
                        this.putNumber(fieldName, TableJsonUtils.jsonParserGetDecimalValue(jp));
                        break;
                    }
                    case STRING: {
                        RecordValueImpl.checkType(fieldName, true, "STRING", jp);
                        this.put(pos, jp.getText());
                        break;
                    }
                    case BINARY: {
                        RecordValueImpl.checkType(fieldName, true, "BINARY", jp);
                        this.put(pos, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        RecordValueImpl.checkType(fieldName, true, "BINARY", jp);
                        this.putFixed(pos, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        RecordValueImpl.checkType(fieldName, true, "BOOLEAN", jp);
                        this.put(pos, jp.getBooleanValue());
                        break;
                    }
                    case TIMESTAMP: {
                        RecordValueImpl.checkType(fieldName, true, "TIMESTAMP", jp);
                        this.put(pos, (FieldValue)fdef.asTimestamp().fromString(jp.getText()));
                        break;
                    }
                    case ARRAY: {
                        RecordValueImpl.checkType(fieldName, false, "ARRAY", jp);
                        ArrayValueImpl array = this.putArray(pos);
                        array.addJsonFields(jp, fieldName, exact, addMissingFields);
                        break;
                    }
                    case MAP: {
                        RecordValueImpl.checkType(fieldName, false, "MAP", jp);
                        MapValueImpl map = this.putMap(pos);
                        map.addJsonFields(jp, fieldName, exact, addMissingFields);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl.checkType(fieldName, false, "RECORD", jp);
                        RecordValueImpl record = this.putRecord(pos);
                        record.addJsonFields(jp, fieldName, exact, addMissingFields);
                        break;
                    }
                    case ENUM: {
                        RecordValueImpl.checkType(fieldName, true, "ENUM", jp);
                        this.putEnum(pos, jp.getText());
                        break;
                    }
                    case JSON: 
                    case ANY_JSON_ATOMIC: {
                        this.put(pos, JsonDefImpl.createFromJson(jp, false));
                        break;
                    }
                    case ANY: 
                    case ANY_ATOMIC: 
                    case ANY_RECORD: 
                    case EMPTY: 
                    case GEOMETRY: 
                    case POINT: {
                        throw new IllegalStateException("A record field cannot have type " + fdef.getType());
                    }
                }
                ++numFields;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        catch (RuntimeException re) {
            if (re instanceof IllegalArgumentException) {
                throw re;
            }
            throw new IllegalArgumentException("Failed to parse JSON input: " + re.toString(), re);
        }
        if (this.getNumFields() != numFields) {
            if (exact) {
                throw new IllegalArgumentException("Not enough fields for value in JSON input.Found " + numFields + ", expected " + this.getNumFields());
            }
            if (addMissingFields) {
                this.addMissingFields();
            }
        }
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (int i = 0; i < this.values.length; ++i) {
            String fieldName = this.getFieldName(i);
            FieldValueImpl val = (FieldValueImpl)this.values[i];
            if (val == null) continue;
            node.set(fieldName, val.toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        boolean wroteFirstField = false;
        sb.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            String fieldName = this.getFieldName(i);
            FieldValueImpl val = (FieldValueImpl)this.values[i];
            if (val == null) continue;
            if (wroteFirstField) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(fieldName);
            sb.append('\"');
            sb.append(':');
            val.toStringBuilder(sb);
            wroteFirstField = true;
        }
        sb.append('}');
    }

    static RecordValueImpl fromJavaObjectValue(FieldDef definition, Object obj) {
        Map javaMap = (Map)obj;
        RecordValueImpl record = (RecordValueImpl)definition.createRecord();
        for (int i = 0; i < record.values.length; ++i) {
            String fieldName = record.getFieldName(i);
            Object o = javaMap.get(fieldName);
            if (o != null) {
                record.put(i, FieldValueImpl.fromJavaObjectValue(record.getFieldDef(i), o));
                continue;
            }
            record.put(i, (FieldValue)record.getDefinition().getDefaultValue(i));
        }
        return record;
    }

    public int getNumFields() {
        return this.values.length;
    }

    public FieldDefImpl getFieldDef(String fieldName) {
        return this.getDefinition().getFieldDef(fieldName);
    }

    public FieldDefImpl getFieldDef(int pos) {
        return this.getDefinition().getFieldDef(pos);
    }

    FieldMapEntry getFieldMapEntry(String fieldName) {
        return this.getDefinition().getFieldMapEntry(fieldName, false);
    }

    public void addMissingFields() {
        for (int i = 0; i < this.values.length; ++i) {
            FieldValue fv = this.values[i];
            if (fv != null) continue;
            fv = this.getDefinition().getDefaultValue(i);
            if (fv.isNull() && !this.getDefinition().isNullable(i)) {
                throw new IllegalArgumentException("The field '" + this.getFieldName(i) + "\n cannot be NULL");
            }
            this.putInternal(i, fv);
        }
    }

    public void convertEmptyToNull() {
        for (int i = 0; i < this.size; ++i) {
            if (!((FieldValueImpl)this.values[i]).isEMPTY()) continue;
            this.values[i] = NullValueImpl.getInstance();
        }
    }

    void putInternal(String name, FieldValue value) {
        this.putInternal(name, value, true);
    }

    void putInternal(String name, FieldValue value, boolean fromUser) {
        int pos = this.getFieldPos(name);
        this.putInternal(pos, value, fromUser);
    }

    public void putInternal(int pos, FieldValue value) {
        this.putInternal(pos, value, true);
    }

    public void putInternal(int pos, FieldValue value, boolean fromUser) {
        assert (value != null);
        if (fromUser) {
            this.checkIdentity(pos, value);
        }
        if (this.values[pos] == null) {
            ++this.size;
        }
        if (value.isFloat() && this.getFieldDef(pos).isJson()) {
            value = FieldDefImpl.doubleDef.createDouble(value.asFloat().get());
        }
        this.values[pos] = value;
    }

    void checkIdentity(int pos, FieldValue value) {
    }

    void removeInternal(int pos) {
        if (this.values[pos] == null) {
            return;
        }
        this.values[pos] = null;
        --this.size;
    }

    RecordValue putEnum(String name, int value) {
        int pos = this.getFieldPos(name);
        this.putInternal(pos, (FieldValue)((EnumDefImpl)this.getFieldDef(pos)).createEnum(value));
        return this;
    }

    void copyFields(RecordValueImpl from) {
        for (int pos = 0; pos < from.values.length; ++pos) {
            if (from.values[pos] == null) continue;
            if (pos >= this.values.length) break;
            this.putInternal(pos, from.values[pos]);
        }
    }

    public void copyFrom(RecordValue source, boolean ignoreDefinition) {
        RecordValueImpl src = (RecordValueImpl)source;
        if (!ignoreDefinition) {
            if (!this.getDefinition().equals(src.getDefinition())) {
                throw new IllegalArgumentException("Types of source and destination RecordValues do notmatch.\nSource type:\n" + src.getDefinition() + "\nDest type:\n" + this.getDefinition());
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (src.values[i] == null) continue;
                this.putInternal(i, src.values[i]);
            }
        } else {
            for (FieldMapEntry fme : this.getDefinition().getFieldProperties()) {
                FieldValueImpl val = src.get(fme.getFieldName());
                if (val == null) continue;
                this.put(fme.getFieldName(), (FieldValue)val);
            }
        }
    }

    private FieldValue validateValueType(int pos, FieldValue value) {
        FieldDefImpl fdef = this.getFieldDef(pos);
        FieldDefImpl valDef = (FieldDefImpl)value.getDefinition();
        if (!valDef.isSubtype(fdef)) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Type mismatch. Value of type\n" + valDef.getDDLString() + "\ncannot be used as the value of field " + fname + " with type\n" + fdef.getDDLString());
        }
        if (value.isComplex() && (fdef.isJson() || fdef.equals(FieldDefImpl.arrayJsonDef) || fdef.equals(FieldDefImpl.mapJsonDef)) && !valDef.equals(FieldDefImpl.arrayJsonDef) && !valDef.equals(FieldDefImpl.mapJsonDef)) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Type mismatch. Value of type\n" + valDef.getDDLString() + "\ncannot be used as the value of field " + fname + " with type\n" + fdef.getDDLString());
        }
        value = ((FieldValueImpl)value).castToSuperType(fdef);
        if (fdef.hasMin() || fdef.hasMax()) {
            this.validateRangeValue(fdef, value);
        }
        return value;
    }

    void validateValueKind(int pos, FieldDef.Type type) {
        FieldDefImpl fdef = this.getFieldDef(pos);
        if (fdef.getType() != type) {
            String fname = this.getFieldName(pos);
            throw new IllegalArgumentException("Type mismatch. Value of kind\n" + type + "\ncannot be used as the value of field " + fname + " with type\n" + fdef.getDDLString());
        }
    }

    void validateIndexFields() {
        RecordValueImpl.validIndexFields(this, this.getClassNameForError());
    }

    static void validIndexFields(ValueSerializer.RecordValueSerializer record, String classNameForError) {
        int numFound = 0;
        RecordDef recordDef = record.getDefinition();
        for (int i = 0; i < recordDef.getNumFields(); ++i) {
            ValueSerializer.FieldValueSerializer val = record.get(i);
            if (val == null) continue;
            if (i != numFound) {
                throw new IllegalArgumentException(classNameForError + " is missing fields more significant than field: " + recordDef.getFieldName(i));
            }
            if (val.isNull() && !recordDef.isNullable(i)) {
                throw new IllegalArgumentException("Field value is null, which is invalid for " + classNameForError + ": " + recordDef.getFieldName(i));
            }
            ++numFound;
        }
    }

    private static void checkType(String fieldName, boolean mustBeScalar, String type, JsonParser jp) throws IOException {
        JsonToken tok = jp.getCurrentToken();
        if (tok.isScalarValue() != mustBeScalar || tok.isNumeric()) {
            throw new IllegalArgumentException("Illegal value for field " + fieldName + ": " + jp.getText() + ". Expected " + type);
        }
    }

    protected String getClassNameForError() {
        return "RecordValue";
    }

    @Override
    public ValueSerializer.RecordValueSerializer asRecordValueSerializer() {
        return this;
    }
}

