/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.kv.impl.api.table.ArrayBuilder;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.MapBuilder;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Table;

public class TableBuilder
extends TableBuilderBase {
    private final String name;
    private String description;
    private final TableImpl parent;
    private final String namespace;
    private List<String> primaryKey;
    private List<String> shardKey;
    private HashMap<String, Integer> primaryKeySizes;
    private boolean r2compat;
    private int schemaId;
    private ResourceOwner owner;
    private boolean sysTable;

    private TableBuilder(String namespace, String name, String description, Table parent, boolean copyParentInfo, boolean isSysTable) {
        this.name = name;
        this.namespace = namespace;
        this.description = description;
        this.r2compat = false;
        this.parent = parent != null ? (TableImpl)parent : null;
        this.sysTable = isSysTable;
        this.primaryKey = new ArrayList<String>();
        this.shardKey = new ArrayList<String>();
        if (parent != null && copyParentInfo) {
            this.addParentInfo();
        }
        TableImpl.validateTableName(name, this.sysTable);
        if (namespace != null) {
            TableImpl.validateNamespace(namespace);
        }
    }

    private void addParentInfo() {
        for (String fieldName : this.parent.getPrimaryKey()) {
            this.fields.put(this.parent.getFieldMapEntry(fieldName, true));
            this.primaryKey.add(fieldName);
        }
        if (this.parent.getPrimaryKeySizes() != null) {
            this.primaryKeySizes = new HashMap();
            List<String> parentKeys = this.parent.getPrimaryKey();
            for (int i = 0; i < this.parent.getPrimaryKeySizes().size(); ++i) {
                int index = this.parent.getPrimaryKeySizes().get(i);
                if (index == 0) continue;
                this.primaryKeySizes.put(parentKeys.get(i), index);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public TableBuilderBase setDescription(String description) {
        this.description = description;
        return this;
    }

    public TableImpl getParent() {
        return this.parent;
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<String> getShardKey() {
        return this.shardKey;
    }

    public boolean isR2compatible() {
        return this.r2compat;
    }

    @Override
    public TableBuilderBase setR2compat(boolean value) {
        this.r2compat = value;
        return this;
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    public TableBuilderBase setSchemaId(int id) {
        this.schemaId = id;
        this.r2compat = true;
        return this;
    }

    public ResourceOwner getOwner() {
        return this.owner;
    }

    public TableBuilderBase setOwner(ResourceOwner newOwner) {
        this.owner = newOwner;
        return this;
    }

    public boolean isSysTable() {
        return this.sysTable;
    }

    @Override
    public TableBuilderBase primaryKey(String ... key) {
        for (String field : key) {
            if (this.primaryKey.contains(field)) {
                throw new IllegalArgumentException("The primary key field already exists: " + field);
            }
            this.primaryKey.add(field);
        }
        return this;
    }

    @Override
    public void validatePrimaryKeyFields() {
        if (this.primaryKey == null) {
            return;
        }
        for (String key : this.primaryKey) {
            FieldMapEntry fme = this.fields.getFieldMapEntry(key);
            if (fme == null) {
                throw new IllegalArgumentException("Field does not exist: " + key);
            }
            if (fme.getDefaultValueInternal() == null) continue;
            throw new IllegalArgumentException("Primary key fields can not have default values");
        }
        for (FieldMapEntry fme : this.fields.getFieldProperties()) {
            if (this.primaryKey.contains(fme.getFieldName()) || fme.isNullable() || fme.getDefaultValueInternal() != null) continue;
            throw new IllegalArgumentException("Not nullable field " + fme.getFieldName() + " must have a default value");
        }
    }

    @Override
    public TableBuilderBase shardKey(String ... key) {
        if (this.parent != null) {
            throw new IllegalArgumentException("Child tables cannot have a shard key.");
        }
        for (String field : key) {
            if (this.shardKey.contains(field)) {
                throw new IllegalArgumentException("The shard key field already exists: " + field);
            }
            this.shardKey.add(field);
        }
        return this;
    }

    @Override
    public TableBuilderBase primaryKey(List<String> pKey) {
        this.primaryKey = pKey;
        return this;
    }

    @Override
    public TableBuilderBase shardKey(List<String> mKey) {
        if (this.parent != null) {
            throw new IllegalArgumentException("Child tables cannot have a shard key.");
        }
        this.shardKey = mKey;
        return this;
    }

    @Override
    public TableBuilderBase primaryKeySize(String keyField, int size) {
        if (this.primaryKey == null) {
            throw new IllegalArgumentException("primaryKeySize() cannot be called before primaryKey()");
        }
        int index = this.primaryKey.indexOf(keyField);
        if (index < 0) {
            throw new IllegalArgumentException("Field is not part of primary key: " + keyField);
        }
        FieldDef field = this.getField(keyField);
        if (field != null && !field.isInteger()) {
            throw new IllegalArgumentException("primaryKeySize() requires an INTEGER field type: " + keyField);
        }
        if (size <= 0 || size > 5) {
            throw new IllegalArgumentException("Invalid primary key size: " + size + ". Size must be 1-5.");
        }
        if (size < 5) {
            if (this.primaryKeySizes == null) {
                this.primaryKeySizes = new HashMap();
            }
            this.primaryKeySizes.put(keyField, size);
        }
        return this;
    }

    @Override
    public TableImpl buildTable() {
        if (this.shardKey == null || this.shardKey.isEmpty()) {
            this.shardKey = this.parent != null ? new ArrayList<String>(this.parent.getShardKey()) : this.primaryKey;
        }
        return TableImpl.createTable(NameUtils.switchToInternalUse(this.namespace), this.getName(), this.parent, this.getPrimaryKey(), this.getPrimaryKeySizes(), this.getShardKey(), this.fields, this.r2compat, this.schemaId, this.getDescription(), true, this.owner, this.ttl, null, this.sysTable, this.getIdentityColumnInfo());
    }

    @Override
    void validateFieldAddition(String fieldName, String pathName, FieldMapEntry fme) {
        super.validateFieldAddition(fieldName, pathName, fme);
        if (this.parent != null && this.parent.isKeyComponent(fieldName)) {
            throw new IllegalArgumentException("Cannot add field, it already exists in primary key fields of its parent table: " + fieldName);
        }
    }

    @Override
    public TableBuilderBase validate() {
        this.buildTable();
        return this;
    }

    public String toJsonString(boolean pretty) {
        TableImpl t = TableImpl.createTable(NameUtils.switchToInternalUse(this.namespace), this.getName(), this.parent, this.getPrimaryKey(), this.getPrimaryKeySizes(), this.getShardKey(), this.fields, this.r2compat, this.schemaId, this.getDescription(), false, this.owner, this.ttl, null, this.sysTable, this.getIdentityColumnInfo());
        return t.toJsonString(pretty);
    }

    public List<Integer> getPrimaryKeySizes() {
        if (this.primaryKeySizes == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.primaryKey.size());
        for (String key : this.primaryKey) {
            Integer size = this.primaryKeySizes.get(key);
            if (size == null) {
                size = 0;
            }
            list.add(size);
        }
        return list;
    }

    public static TableImpl fromJsonString(String jsonString, Table parent) {
        return TableJsonUtils.fromJsonString(jsonString, (TableImpl)parent);
    }

    public static TableBuilder createTableBuilder(String namespace, String name, String description, Table parent, boolean copyParentInfo) {
        return new TableBuilder(namespace, name, description, parent, copyParentInfo, false);
    }

    public static TableBuilder createTableBuilder(String namespace, String name, String description, Table parent) {
        return TableBuilder.createTableBuilder(namespace, name, description, parent, true);
    }

    public static TableBuilder createTableBuilder(String namespace, String name) {
        return TableBuilder.createTableBuilder(namespace, name, null, null, false);
    }

    public static TableBuilder createTableBuilder(String name, String description, Table parent) {
        return TableBuilder.createTableBuilder(null, name, description, parent, true);
    }

    public static TableBuilder createTableBuilder(String name) {
        return TableBuilder.createTableBuilder(null, name, null, null, false);
    }

    public static TableBuilder createSystemTableBuilder(String name) {
        return new TableBuilder(null, name, null, null, false, true);
    }

    public static ArrayBuilder createArrayBuilder(String description) {
        return new ArrayBuilder(description);
    }

    public static ArrayBuilder createArrayBuilder() {
        return new ArrayBuilder();
    }

    public static MapBuilder createMapBuilder(String description) {
        return new MapBuilder(description);
    }

    public static MapBuilder createMapBuilder() {
        return new MapBuilder();
    }

    public static RecordBuilder createRecordBuilder(String name, String description) {
        return new RecordBuilder(name, description);
    }

    public static RecordBuilder createRecordBuilder(String name) {
        return new RecordBuilder(name);
    }
}

