/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.kv.Key;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.util.ArrayPosition;
import oracle.kv.table.FieldRange;
import oracle.kv.table.Row;
import oracle.kv.table.Table;

public class TableKey {
    private final ArrayList<String> major;
    private final ArrayList<String> minor;
    private final ArrayPosition pkIterator;
    private final Iterator<String> majorIterator;
    private final boolean allowPartial;
    private final ValueSerializer.RowSerializer row;
    private final TableImpl table;
    private Key key;
    private boolean majorComplete;
    private boolean keyComplete;
    private boolean done;
    private ArrayList<String> current;
    private KVStoreImpl store;
    private final TableAPIImpl.IdentityInfo idInfo;

    private TableKey(TableImpl table, ValueSerializer.RowSerializer row, boolean allowPartial, KVStoreImpl store, TableAPIImpl.IdentityInfo idInfo) {
        this.row = row;
        this.allowPartial = allowPartial;
        this.major = new ArrayList();
        this.minor = new ArrayList();
        this.pkIterator = new ArrayPosition(table.getPrimaryKey().size());
        this.majorIterator = table.getShardKey().iterator();
        this.current = this.major;
        this.keyComplete = true;
        this.table = table;
        this.store = store;
        this.idInfo = idInfo;
    }

    public static TableKey createKey(Table table, Row row, boolean allowPartial) {
        return TableKey.createKeyInternal(table, (ValueSerializer.RowSerializer)((Object)row), allowPartial);
    }

    static TableKey createKeyInternal(Table table, ValueSerializer.RowSerializer row, boolean allowPartial) {
        if (row.size() == 0) {
            if (!allowPartial) {
                throw new IllegalArgumentException("Primary key is empty");
            }
            return new TableKey((TableImpl)table, row, allowPartial, null, null).create();
        }
        return new TableKey((TableImpl)table, row, allowPartial, null, null).create();
    }

    static TableKey createKeyInternal(Table table, ValueSerializer.RowSerializer row, boolean allowPartial, KVStoreImpl store, TableAPIImpl.IdentityInfo idInfo) {
        if (row.size() == 0) {
            if (!allowPartial) {
                throw new IllegalArgumentException("Primary key is empty");
            }
            return new TableKey((TableImpl)table, row, allowPartial, store, idInfo).create();
        }
        return new TableKey((TableImpl)table, row, allowPartial, store, idInfo).create();
    }

    public TableKey create() {
        this.createPrimaryKey(this.table);
        this.key = Key.createKey(this.major, this.minor);
        return this;
    }

    TableImpl getTable() {
        return this.table;
    }

    public boolean getKeyComplete() {
        return this.keyComplete;
    }

    public boolean getMajorKeyComplete() {
        return this.majorComplete;
    }

    public Key getKey() {
        return this.key;
    }

    RowImpl getRow() {
        return this.row instanceof RowImpl ? (RowImpl)this.row : null;
    }

    public byte[] getKeyBytes() {
        return this.key.toByteArray();
    }

    public int getKeySize(boolean skipFirst) {
        int totalLen = 0;
        for (String component : this.major) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            totalLen += component.length();
        }
        for (String component : this.minor) {
            totalLen += component.length();
        }
        return totalLen;
    }

    private void incrementMajor() {
        if (this.majorIterator.hasNext()) {
            this.majorIterator.next();
        } else {
            this.current = this.minor;
            this.majorComplete = true;
        }
    }

    private void createPrimaryKey(TableImpl currentTable) {
        if (currentTable.getParent() != null) {
            this.createPrimaryKey((TableImpl)currentTable.getParent());
        }
        if (!this.done) {
            this.current.add(currentTable.getIdString());
        }
        int lastPrimKeyCol = currentTable.getPrimaryKeySize() - 1;
        while (this.pkIterator.hasNext()) {
            int pkFieldPos;
            int pos = this.pkIterator.next();
            int n = pkFieldPos = this.row.isPrimaryKey() ? pos : this.table.getPrimKeyPositions()[pos];
            if (!this.done) {
                this.incrementMajor();
            }
            ValueSerializer.FieldValueSerializer fv = this.row.get(pkFieldPos);
            if (this.store != null && this.table.hasIdentityColumn() && this.table.getIdentityColumn() == pkFieldPos) {
                fv = TableAPIImpl.fillIdentityValue(this.row, pkFieldPos, this.table, this.idInfo, this.store);
            }
            if (fv != null) {
                if (!this.keyComplete) {
                    throw new IllegalArgumentException("A required field is missing from the Primary Key");
                }
                String keyStr = this.formatToKey(fv, currentTable.getPrimaryKeySize(pos));
                this.current.add(keyStr);
            } else {
                this.keyComplete = false;
                if (!this.allowPartial) {
                    String fName = this.table.getRowDef().getFieldName(pkFieldPos);
                    throw new IllegalArgumentException("Missing primary key field: " + fName);
                }
                this.done = true;
            }
            if (pos != lastPrimKeyCol) continue;
            if (this.done) break;
            this.incrementMajor();
            break;
        }
    }

    private String formatToKey(ValueSerializer.FieldValueSerializer value, int keyLen) {
        FieldDefImpl def = (FieldDefImpl)value.getDefinition();
        switch (def.getType()) {
            case BOOLEAN: {
                return BooleanValueImpl.toKeyString(value.getBoolean());
            }
            case INTEGER: {
                return IntegerValueImpl.toKeyString(value.getInt(), def, keyLen);
            }
            case LONG: {
                return LongValueImpl.toKeyString(value.getLong(), def);
            }
            case STRING: {
                return StringValueImpl.toKeyString(value.getString());
            }
            case ENUM: {
                return EnumValueImpl.toKeyString((EnumDefImpl)def, ((EnumDefImpl)def).indexOf(value.getEnumString()));
            }
            case DOUBLE: {
                return DoubleValueImpl.toKeyString(value.getDouble());
            }
            case FLOAT: {
                return FloatValueImpl.toKeyString(value.getFloat());
            }
            case NUMBER: {
                return NumberValueImpl.toKeyString(value.getNumberBytes());
            }
            case TIMESTAMP: {
                return TimestampValueImpl.toKeyString(value.getTimestampBytes());
            }
        }
        throw new IllegalArgumentException("Invalid type for primary key " + def.getType());
    }

    void validateFieldOrder(FieldRange range) {
        if (range != null) {
            List<String> primaryKey = this.table.getPrimaryKey();
            int index = primaryKey.indexOf(range.getFieldName());
            if (index < 0) {
                throw new IllegalArgumentException("Field is not part of primary key: " + range.getFieldName());
            }
            if (this.row.size() < index) {
                throw new IllegalArgumentException("PrimaryKey is missing fields more significant than field: " + range.getFieldName());
            }
            if (this.row.size() > index) {
                throw new IllegalArgumentException("PrimaryKey has extra fields beyond field: " + range.getFieldName());
            }
        }
    }

    void validateFields() {
        if (this.row.isPrimaryKey()) {
            RecordValueImpl.validIndexFields(this.row, this.row.getClassNameForError());
        }
    }
}

