/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.shell.output.ResultOutputFactory;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;

public class TabularFormatter {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TTL = "ttl";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_NAMESPACE = "namespace";
    private static final String FIELD_SYSTABLE = "sysTable";
    private static final String FIELD_R2COMPAT = "r2compat";
    private static final String FIELD_PARENT = "parent";
    private static final String FIELD_CHILDREN = "children";
    private static final String FIELD_INDEXES = "indexes";
    private static final String FIELD_COMMENT = "description";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_NULLABLE = "nullable";
    private static final String FIELD_DEFAULT = "default";
    private static final String FIELD_SHARD_KEY = "shardKey";
    private static final String FIELD_PRIMARY_KEY = "primaryKey";
    private static final String FIELD_IDENTITY = "identity";
    private static final String FIELD_TABLE = "table";
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_MULTI_KEY = "multiKey";
    private static final String FIELD_TYPES = "declaredType";
    private static final String FIELD_ANNOTATIONS = "annotations";
    private static final String FIELD_PROPERTIES = "properties";
    private static TableImpl tableInfo = TabularFormatter.buildTableInfoTable();
    private static TableImpl tableFields = TabularFormatter.buildTableFieldsTable();
    private static TableImpl tableIndex = TabularFormatter.buildTableIndexTable(false);
    private static TableImpl tableTextIndex = TabularFormatter.buildTableIndexTable(true);
    private static int tableInfoNamespacePos;
    private static int tableIndexNamespacePos;

    public static String formatTable(TableImpl table, Map<String, Object> fields) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outStream = new PrintStream(out);
        if (fields == null) {
            int[] nArray;
            outStream.println(" === Information ===");
            RecordValue recordValue = TabularFormatter.generateTableInfoRecord(table);
            if (table.getInternalNamespace() == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = tableInfoNamespacePos;
            } else {
                nArray = null;
            }
            TabularFormatter.outputRecord(outStream, recordValue, nArray);
            outStream.println("\n === Fields ===");
        }
        TabularFormatter.outputRecords(outStream, TabularFormatter.generateFieldsRecords(table, fields), null);
        return out.toString();
    }

    public static String formatIndex(IndexImpl index) {
        int[] nArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        RecordValue recordValue = TabularFormatter.generateIndexRecord(index);
        if (index.getTable().getInternalNamespace() == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = tableIndexNamespacePos;
        } else {
            nArray = null;
        }
        TabularFormatter.outputRecord(printStream, recordValue, nArray);
        return out.toString();
    }

    private static RecordValue generateTableInfoRecord(TableImpl table) {
        RowImpl row = tableInfo.createRow();
        row.put(FIELD_NAMESPACE, TabularFormatter.emptyIfNull(table.getInternalNamespace()));
        row.put(FIELD_NAME, table.getFullName());
        row.put(FIELD_TTL, TabularFormatter.emptyIfNull(table.getDefaultTTL()));
        row.put(FIELD_OWNER, TabularFormatter.emptyIfNull(table.getOwner()));
        row.put(FIELD_SYSTABLE, TabularFormatter.booleanYesNo(table.isSystemTable()));
        row.put(FIELD_R2COMPAT, TabularFormatter.booleanYesNo(table.isR2compatible()));
        row.put(FIELD_PARENT, TabularFormatter.emptyIfNull(table.getParentName()));
        ArrayValue av = row.putArray(FIELD_CHILDREN);
        if (!table.getChildTables().isEmpty()) {
            for (String cname : table.getChildTables().keySet()) {
                av.add(cname);
            }
        }
        av = row.putArray(FIELD_INDEXES);
        if (!table.getIndexes().isEmpty()) {
            for (String iname : table.getIndexes().keySet()) {
                av.add(iname);
            }
        }
        row.put(FIELD_COMMENT, TabularFormatter.emptyIfNull(table.getDescription()));
        return row;
    }

    private static List<RecordValue> generateFieldsRecords(TableImpl table, Map<String, Object> fieldMap) {
        ArrayList<RecordValue> records = new ArrayList<RecordValue>();
        int ind = 1;
        if (fieldMap == null) {
            for (String name : table.getFields()) {
                FieldDef fdef = table.getField(name);
                boolean isIdentity = table.hasIdentityColumn() && table.getIdentityColumn() == table.getFieldMap().getFieldPos(name);
                RecordValue record = TabularFormatter.createFieldRecord(ind++, name, fdef, table.isNullable(name), table.getDefaultValue(name), table.getShardKey().contains(name), table.getPrimaryKey().contains(name), isIdentity);
                records.add(record);
            }
            return records;
        }
        for (Map.Entry<String, Object> e : fieldMap.entrySet()) {
            RecordValue record;
            String name = e.getKey();
            if (e.getValue() instanceof FieldDef) {
                record = TabularFormatter.createFieldRecord(ind++, name, (FieldDef)e.getValue(), false, null, false, false, false);
            } else {
                assert (e.getValue() instanceof FieldMapEntry);
                FieldMapEntry fme = (FieldMapEntry)e.getValue();
                boolean isIdentity = table.hasIdentityColumn() && table.getIdentityColumn() == table.getFieldMap().getFieldPos(name);
                record = TabularFormatter.createFieldRecord(ind++, name, fme.getFieldDef(), fme.isNullable(), fme.getDefaultValue(), table.getShardKey().contains(name), table.getPrimaryKey().contains(name), isIdentity);
            }
            records.add(record);
        }
        return records;
    }

    private static RecordValue createFieldRecord(int id, String name, FieldDef fdef, boolean isNullable, FieldValue defVal, boolean isShardKey, boolean isPrimaryKey, boolean isIdentity) {
        RowImpl row = tableFields.createRow();
        row.put(FIELD_ID, id);
        row.put(FIELD_NAME, name);
        String[] lines = ((FieldDefImpl)fdef).getDDLString().split("\\n");
        ArrayValue av = row.putArray(FIELD_TYPE);
        for (String line : lines) {
            av.add(line);
        }
        row.put(FIELD_NULLABLE, TabularFormatter.booleanYesNo(isNullable));
        row.put(FIELD_DEFAULT, TabularFormatter.emptyIfNull(defVal));
        row.put(FIELD_SHARD_KEY, TabularFormatter.booleanYes(isShardKey));
        row.put(FIELD_PRIMARY_KEY, TabularFormatter.booleanYes(isPrimaryKey));
        row.put(FIELD_IDENTITY, TabularFormatter.booleanYes(isIdentity));
        return row;
    }

    private static RecordValue generateIndexRecord(IndexImpl index) {
        boolean isTextIndex = index.getType() == Index.IndexType.TEXT;
        RowImpl row = isTextIndex ? tableTextIndex.createRow() : tableIndex.createRow();
        row.put(FIELD_NAMESPACE, TabularFormatter.emptyIfNull(index.getTable().getInternalNamespace()));
        row.put(FIELD_TABLE, index.getTable().getFullName());
        row.put(FIELD_NAME, index.getName());
        row.put(FIELD_TYPE, index.getType().name());
        row.put(FIELD_MULTI_KEY, TabularFormatter.booleanYesNo(index.isMultiKey()));
        ArrayValue av = row.putArray(FIELD_FIELDS);
        for (String field : index.getFields()) {
            av.add(field);
        }
        if (!isTextIndex) {
            av = row.putArray(FIELD_TYPES);
            if (index.getTypes() != null) {
                for (FieldDef.Type t : index.getTypes()) {
                    av.add(TabularFormatter.emptyIfNull(t));
                }
            }
        } else {
            av = row.putArray(FIELD_ANNOTATIONS);
            for (String field : index.getFields()) {
                av.add(TabularFormatter.emptyIfNull(index.getAnnotationForField(field)));
            }
            MapValue mv = row.putMap(FIELD_PROPERTIES);
            for (Map.Entry<String, String> e : index.getProperties().entrySet()) {
                mv.put(e.getKey(), e.getValue());
            }
        }
        row.put(FIELD_COMMENT, TabularFormatter.emptyIfNull(index.getDescription()));
        return row;
    }

    private static void outputRecord(PrintStream output, RecordValue record, int[] hiddenColumns) {
        TabularFormatter.outputRecords(output, Arrays.asList(record), hiddenColumns);
    }

    private static void outputRecords(PrintStream output, List<RecordValue> records, int[] hiddenColumns) {
        RecordDef recordDef = records.get(0).getDefinition();
        ResultOutputFactory.ResultOutput ro = ResultOutputFactory.getOutput(ResultOutputFactory.OutputMode.COLUMN, null, output, recordDef, records.iterator(), false, 0, hiddenColumns);
        try {
            ro.outputResultSet();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to output records: " + ioe.getMessage());
        }
    }

    private static TableImpl buildTableInfoTable() {
        TableBuilder tb = TableBuilder.createTableBuilder("tableInfo");
        tb.addString(FIELD_NAMESPACE);
        tb.addString(FIELD_NAME);
        tb.addString(FIELD_TTL);
        tb.addString(FIELD_OWNER);
        tb.addString(FIELD_SYSTABLE);
        tb.addString(FIELD_R2COMPAT);
        tb.addString(FIELD_PARENT);
        tb.addField(FIELD_CHILDREN, TableBuilder.createArrayBuilder().addString().build());
        tb.addField(FIELD_INDEXES, TableBuilder.createArrayBuilder().addString().build());
        tb.addString(FIELD_COMMENT);
        tb.primaryKey(FIELD_NAMESPACE, FIELD_NAME);
        return tb.buildTable();
    }

    private static TableImpl buildTableFieldsTable() {
        TableBuilder tb = TableBuilder.createTableBuilder("tableFields");
        tb.addInteger(FIELD_ID);
        tb.addString(FIELD_NAME);
        tb.addField(FIELD_TYPE, TableBuilder.createArrayBuilder().addString().build());
        tb.addString(FIELD_NULLABLE);
        tb.addString(FIELD_DEFAULT);
        tb.addString(FIELD_SHARD_KEY);
        tb.addString(FIELD_PRIMARY_KEY);
        tb.addString(FIELD_IDENTITY);
        tb.primaryKey(FIELD_ID);
        return tb.buildTable();
    }

    private static TableImpl buildTableIndexTable(boolean isTextIndex) {
        String name = isTextIndex ? "tableTextIndex" : "tableIndex";
        TableBuilder tb = TableBuilder.createTableBuilder(name);
        tb.addString(FIELD_NAMESPACE);
        tb.addString(FIELD_TABLE);
        tb.addString(FIELD_NAME);
        tb.addString(FIELD_TYPE);
        tb.addString(FIELD_MULTI_KEY);
        tb.addField(FIELD_FIELDS, TableBuilder.createArrayBuilder().addString().build());
        if (!isTextIndex) {
            tb.addField(FIELD_TYPES, TableBuilder.createArrayBuilder().addString().build());
        } else {
            tb.addField(FIELD_ANNOTATIONS, TableBuilder.createArrayBuilder().addString().build());
            tb.addField(FIELD_PROPERTIES, TableBuilder.createMapBuilder().addString().build());
        }
        tb.addString(FIELD_COMMENT);
        tb.primaryKey(FIELD_NAMESPACE, FIELD_NAME);
        return tb.buildTable();
    }

    private static String booleanYes(boolean val) {
        return val ? "Y" : "";
    }

    private static String booleanYesNo(boolean val) {
        return val ? "Y" : "N";
    }

    private static String emptyIfNull(String val) {
        return val == null ? "" : val;
    }

    private static String emptyIfNull(Object val) {
        return val == null ? "" : val.toString();
    }

    static {
        int i = 0;
        for (String field : tableInfo.getFields()) {
            if (field.equals(FIELD_NAMESPACE)) {
                tableInfoNamespacePos = i;
                break;
            }
            ++i;
        }
        i = 0;
        for (String field : tableIndex.getFields()) {
            if (field.equals(FIELD_NAMESPACE)) {
                tableIndexNamespacePos = i;
                break;
            }
            ++i;
        }
    }
}

