/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.serialize;

public class BinaryData {
    private BinaryData() {
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int skipLong(byte[] bytes, int start) {
        int i = start;
        byte b = bytes[i++];
        while ((b & 0x80) != 0) {
            b = bytes[i++];
        }
        return i;
    }

    public static int encodeBoolean(boolean b, byte[] buf, int pos) {
        buf[pos] = b ? (byte)1 : 0;
        return 1;
    }

    public static int encodeInt(int n, byte[] buf, int pos) {
        n = n << 1 ^ n >> 31;
        int start = pos;
        if ((n & 0xFFFFFF80) != 0) {
            buf[pos++] = (byte)((n | 0x80) & 0xFF);
            if ((n >>>= 7) > 127) {
                buf[pos++] = (byte)((n | 0x80) & 0xFF);
                if ((n >>>= 7) > 127) {
                    buf[pos++] = (byte)((n | 0x80) & 0xFF);
                    if ((n >>>= 7) > 127) {
                        buf[pos++] = (byte)((n | 0x80) & 0xFF);
                        n >>>= 7;
                    }
                }
            }
        }
        buf[pos++] = (byte)n;
        return pos - start;
    }

    public static int encodeLong(long n, byte[] buf, int pos) {
        n = n << 1 ^ n >> 63;
        int start = pos;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
            if ((n >>>= 7) > 127L) {
                buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                if ((n >>>= 7) > 127L) {
                    buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                    if ((n >>>= 7) > 127L) {
                        buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                        if ((n >>>= 7) > 127L) {
                            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                            if ((n >>>= 7) > 127L) {
                                buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                if ((n >>>= 7) > 127L) {
                                    buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                    if ((n >>>= 7) > 127L) {
                                        buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                        if ((n >>>= 7) > 127L) {
                                            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                            n >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        buf[pos++] = (byte)n;
        return pos - start;
    }

    public static int encodeFloat(float f, byte[] buf, int pos) {
        int len = 1;
        int bits = Float.floatToRawIntBits(f);
        buf[pos] = (byte)(bits & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 8 & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 16 & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 24 & 0xFF);
        return 4;
    }

    public static int encodeDouble(double d, byte[] buf, int pos) {
        long bits = Double.doubleToRawLongBits(d);
        int first = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
        int second = (int)(bits >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[pos] = (byte)(first & 0xFF);
        buf[pos + 4] = (byte)(second & 0xFF);
        buf[pos + 5] = (byte)(second >>> 8 & 0xFF);
        buf[pos + 1] = (byte)(first >>> 8 & 0xFF);
        buf[pos + 2] = (byte)(first >>> 16 & 0xFF);
        buf[pos + 6] = (byte)(second >>> 16 & 0xFF);
        buf[pos + 7] = (byte)(second >>> 24 & 0xFF);
        buf[pos + 3] = (byte)(first >>> 24 & 0xFF);
        return 8;
    }
}

