/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.serialize;

import java.io.IOException;
import java.io.InputStream;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.serialize.BinaryDecoder;
import oracle.kv.impl.api.table.serialize.Decoder;
import oracle.kv.impl.api.table.serialize.ResolvingDecoder;

public class DecoderFactory {
    private static final DecoderFactory DEFAULT_FACTORY = new DefaultDecoderFactory();
    static final int DEFAULT_BUFFER_SIZE = 8192;
    int binaryDecoderBufferSize = 8192;

    public static DecoderFactory get() {
        return DEFAULT_FACTORY;
    }

    public BinaryDecoder binaryDecoder(InputStream in, BinaryDecoder reuse) {
        if (null == reuse || !reuse.getClass().equals(BinaryDecoder.class)) {
            return new BinaryDecoder(in, this.binaryDecoderBufferSize);
        }
        return reuse.configure(in, this.binaryDecoderBufferSize);
    }

    public BinaryDecoder binaryDecoder(byte[] bytes, int offset, int length, BinaryDecoder reuse) {
        if (null == reuse || !reuse.getClass().equals(BinaryDecoder.class)) {
            return new BinaryDecoder(bytes, offset, length);
        }
        return reuse.configure(bytes, offset, length);
    }

    public BinaryDecoder binaryDecoder(byte[] bytes, BinaryDecoder reuse) {
        return this.binaryDecoder(bytes, 0, bytes.length, reuse);
    }

    public ResolvingDecoder resolvingDecoder(FieldDefImpl writer, FieldDefImpl reader, Decoder wrapped) throws IOException {
        return new ResolvingDecoder(writer, reader, wrapped);
    }

    private static class DefaultDecoderFactory
    extends DecoderFactory {
        private DefaultDecoderFactory() {
        }
    }
}

