/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.serialize;

import java.io.OutputStream;
import oracle.kv.impl.api.table.serialize.BinaryEncoder;
import oracle.kv.impl.api.table.serialize.BufferedBinaryEncoder;

public class EncoderFactory {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final int DEFAULT_BLOCK_BUFFER_SIZE = 65536;
    private static final EncoderFactory DEFAULT_FACTORY = new DefaultEncoderFactory();
    protected int binaryBufferSize = 2048;
    protected int binaryBlockSize = 65536;

    public static EncoderFactory get() {
        return DEFAULT_FACTORY;
    }

    public EncoderFactory configureBufferSize(int size) {
        if (size < 32) {
            size = 32;
        }
        if (size > 0x1000000) {
            size = 0x1000000;
        }
        this.binaryBufferSize = size;
        return this;
    }

    public BinaryEncoder binaryEncoder(OutputStream out, BinaryEncoder reuse) {
        if (null == reuse || !reuse.getClass().equals(BufferedBinaryEncoder.class)) {
            return new BufferedBinaryEncoder(out, this.binaryBufferSize);
        }
        return ((BufferedBinaryEncoder)reuse).configure(out, this.binaryBufferSize);
    }

    private static class DefaultEncoderFactory
    extends EncoderFactory {
        private DefaultEncoderFactory() {
        }

        @Override
        public EncoderFactory configureBufferSize(int size) {
            throw new RuntimeException("Default EncoderFactory cannot be configured");
        }
    }
}

