/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.serialize.parsing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FixedBinaryValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.serialize.BinaryEncoder;
import oracle.kv.impl.api.table.serialize.Encoder;
import oracle.kv.impl.api.table.serialize.EncoderFactory;
import oracle.kv.impl.api.table.serialize.SerializationRuntimeException;
import oracle.kv.impl.api.table.serialize.parsing.Symbol;
import oracle.kv.impl.api.table.serialize.parsing.ValidatingGrammarGenerator;
import oracle.kv.table.FieldDef;

public class ResolvingGrammarGenerator
extends ValidatingGrammarGenerator {
    private static EncoderFactory factory = new EncoderFactory().configureBufferSize(32);

    public final Symbol generate(FieldDefImpl writer, FieldDefImpl reader) throws IOException {
        return Symbol.root(this.generate(writer, reader, new HashMap<ValidatingGrammarGenerator.LitS, Symbol>()));
    }

    private Symbol generateNullable(FieldMapEntry writerFme, FieldMapEntry readerFme, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        if (writerFme.isNullable()) {
            return this.resolveUnion(writerFme, readerFme, seen);
        }
        if (readerFme.isNullable()) {
            Symbol ret = null;
            if (readerFme.getDefaultValue().isNull()) {
                int j;
                int n = j = ResolvingGrammarGenerator.bestBranch(readerFme.getFieldDef(), writerFme.getFieldDef()) ? 1 : -1;
                if (j == 1) {
                    Symbol s = this.generate(writerFme.getFieldDef(), readerFme.getFieldDef(), seen);
                    ret = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                } else {
                    ret = Symbol.error("Found " + writerFme.getFieldName() + ", expecting " + readerFme.getFieldName());
                }
            } else {
                int j;
                int n = j = ResolvingGrammarGenerator.bestBranch(readerFme.getFieldDef(), writerFme.getFieldDef()) ? 0 : -1;
                if (j == 0) {
                    Symbol s = this.generate(writerFme.getFieldDef(), readerFme.getFieldDef(), seen);
                    ret = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                } else {
                    ret = Symbol.error("Found " + writerFme.getFieldName() + ", expecting " + readerFme.getFieldName());
                }
            }
            return ret;
        }
        return this.generate(writerFme.getFieldDef(), readerFme.getFieldDef(), seen);
    }

    private Symbol generateSymbolForNull(FieldMapEntry wfme, FieldMapEntry rfme) {
        FieldDef.Type readerType;
        FieldDefImpl writer = wfme.getFieldDef();
        FieldDefImpl reader = rfme.getFieldDef();
        FieldDef.Type writerType = writer.getType();
        if (writerType == (readerType = reader.getType())) {
            return Symbol.NULL;
        }
        return Symbol.error("Found " + wfme.getFieldName() + ", expecting " + rfme.getFieldName());
    }

    private Symbol generate(FieldDefImpl writer, FieldDefImpl reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        FieldDef.Type readerType;
        FieldDef.Type writerType;
        block36: {
            block35: {
                writerType = writer.getType();
                if (writerType != (readerType = reader.getType())) break block35;
                switch (writerType) {
                    case BOOLEAN: {
                        return Symbol.BOOLEAN;
                    }
                    case INTEGER: {
                        return Symbol.INT;
                    }
                    case LONG: {
                        return Symbol.LONG;
                    }
                    case FLOAT: {
                        return Symbol.FLOAT;
                    }
                    case DOUBLE: {
                        return Symbol.DOUBLE;
                    }
                    case STRING: {
                        return Symbol.STRING;
                    }
                    case FIXED_BINARY: {
                        if (((FixedBinaryDefImpl)writer).getName().equals(((FixedBinaryDefImpl)reader).getName()) && ((FixedBinaryDefImpl)writer).getSize() == ((FixedBinaryDefImpl)reader).getSize()) {
                            return Symbol.seq(Symbol.intCheckAction(((FixedBinaryDefImpl)writer).getSize()), Symbol.FIXED);
                        }
                        break block36;
                    }
                    case ENUM: {
                        if (((EnumDefImpl)writer).getName() == null || ((EnumDefImpl)writer).getName().equals(((EnumDefImpl)reader).getName())) {
                            return Symbol.seq(ResolvingGrammarGenerator.mkEnumAdjust(((EnumDefImpl)writer).getValues(), ((EnumDefImpl)reader).getValues()), Symbol.ENUM);
                        }
                        break block36;
                    }
                    case ARRAY: {
                        return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(((ArrayDefImpl)writer).getElement(), ((ArrayDefImpl)reader).getElement(), seen)), Symbol.ARRAY_START);
                    }
                    case MAP: {
                        return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(((MapDefImpl)writer).getElement(), ((MapDefImpl)reader).getElement(), seen), Symbol.STRING), Symbol.MAP_START);
                    }
                    case RECORD: {
                        return this.resolveRecords((RecordDefImpl)writer, (RecordDefImpl)reader, seen);
                    }
                    case JSON: {
                        return Symbol.BYTES;
                    }
                    case BINARY: {
                        return Symbol.BYTES;
                    }
                    case TIMESTAMP: {
                        return Symbol.BYTES;
                    }
                    case NUMBER: {
                        return Symbol.BYTES;
                    }
                    case ANY: 
                    case ANY_ATOMIC: 
                    case ANY_JSON_ATOMIC: 
                    case ANY_RECORD: {
                        throw new IllegalStateException("Wildcard types are not invalid: " + writerType);
                    }
                    default: {
                        throw new IllegalStateException("Unknown type: " + writerType);
                    }
                }
            }
            switch (readerType) {
                case LONG: {
                    switch (writerType) {
                        case INTEGER: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.LONG);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (writerType) {
                        case INTEGER: 
                        case LONG: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.FLOAT);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (writerType) {
                        case INTEGER: 
                        case LONG: 
                        case FLOAT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.DOUBLE);
                        }
                    }
                    break;
                }
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case FIXED_BINARY: 
                case ENUM: 
                case ARRAY: 
                case MAP: 
                case RECORD: 
                case JSON: 
                case BINARY: 
                case TIMESTAMP: 
                case NUMBER: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type: " + readerType);
                }
            }
        }
        return Symbol.error("Found " + writerType + ", expecting " + readerType);
    }

    private Symbol resolveUnion(FieldMapEntry writer, FieldMapEntry reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        int size = 2;
        Symbol[] symbols = new Symbol[2];
        String[] labels = new String[2];
        int j = 0;
        if (writer.getDefaultValue().isNull()) {
            if (reader.isNullable()) {
                if (reader.getDefaultValue().isNull()) {
                    j = 0;
                    labels[0] = "null";
                    Symbol s = this.generateSymbolForNull(writer, reader);
                    symbols[0] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                    labels[1] = writer.getFieldName();
                    int n = j = ResolvingGrammarGenerator.bestBranch(reader.getFieldDef(), writer.getFieldDef()) ? 1 : -1;
                    if (j == 1) {
                        s = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
                        symbols[1] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                    } else {
                        symbols[1] = Symbol.error("Found " + writer.getFieldName() + ", expecting " + reader.getFieldName());
                    }
                } else {
                    j = 1;
                    labels[0] = "null";
                    Symbol s = this.generateSymbolForNull(writer, reader);
                    symbols[0] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                    labels[1] = writer.getFieldName();
                    int n = j = ResolvingGrammarGenerator.bestBranch(reader.getFieldDef(), writer.getFieldDef()) ? 0 : -1;
                    if (j == 0) {
                        s = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
                        symbols[1] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                    } else {
                        symbols[1] = Symbol.error("Found " + writer.getFieldName() + ", expecting " + reader.getFieldName());
                    }
                }
            } else {
                symbols[0] = this.generateSymbolForNull(writer, reader);
                labels[0] = "null";
                symbols[1] = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
                labels[1] = writer.getFieldName();
            }
        } else if (reader.isNullable()) {
            if (reader.getDefaultValue().isNull()) {
                j = 0;
                labels[1] = "null";
                Symbol s = this.generateSymbolForNull(writer, reader);
                symbols[1] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                labels[0] = writer.getFieldName();
                int n = j = ResolvingGrammarGenerator.bestBranch(reader.getFieldDef(), writer.getFieldDef()) ? 1 : -1;
                if (j == 1) {
                    s = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
                    symbols[0] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                } else {
                    symbols[0] = Symbol.error("Found " + writer.getFieldName() + ", expecting " + reader.getFieldName());
                }
            } else {
                j = 1;
                labels[1] = "null";
                Symbol s = this.generateSymbolForNull(writer, reader);
                symbols[1] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                labels[0] = writer.getFieldName();
                int n = j = ResolvingGrammarGenerator.bestBranch(reader.getFieldDef(), writer.getFieldDef()) ? 0 : -1;
                if (j == 0) {
                    s = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
                    symbols[0] = Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                } else {
                    symbols[0] = Symbol.error("Found " + writer.getFieldName() + ", expecting " + reader.getFieldName());
                }
            }
        } else {
            symbols[0] = this.generate(writer.getFieldDef(), reader.getFieldDef(), seen);
            labels[0] = writer.getFieldName();
            symbols[1] = this.generateSymbolForNull(writer, reader);
            labels[1] = "null";
        }
        return Symbol.seq(Symbol.alt(symbols, labels), Symbol.writerUnionAction());
    }

    private Symbol resolveRecords(RecordDefImpl writer, RecordDefImpl reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        LitS2 wsc = new LitS2(writer, reader);
        Symbol result = seen.get(wsc);
        if (result == null) {
            List<String> wfname = writer.getFieldNames();
            List<String> rfname = reader.getFieldNames();
            FieldMapEntry[] reordered = new FieldMapEntry[reader.getNumFields()];
            int ridx = 0;
            int count = 1 + writer.getNumFields();
            for (String f : wfname) {
                FieldDefImpl rdrField = reader.getField(f);
                if (rdrField == null) continue;
                FieldMapEntry fme = reader.getFieldMapEntry(f, true);
                reordered[ridx++] = fme;
            }
            for (String rf : rfname) {
                if (writer.getField(rf) != null) continue;
                FieldValueImpl fv = reader.getDefaultValue(rf);
                if ((fv == null || fv.isNull()) && !reader.isNullable(rf)) {
                    result = Symbol.error("Found " + writer.getName() + ", expecting " + reader.getName() + ", missing required field " + rf);
                    seen.put(wsc, result);
                    return result;
                }
                reordered[ridx++] = reader.getFieldMapEntry(rf, true);
                count += 3;
            }
            Symbol[] production = new Symbol[count];
            production[--count] = Symbol.fieldOrderAction(reordered);
            result = Symbol.seq(production);
            seen.put(wsc, result);
            for (String fname : wfname) {
                FieldDefImpl rf = reader.getField(fname);
                FieldMapEntry wfme = writer.getFieldMapEntry(fname, true);
                if (rf == null) {
                    production[--count] = Symbol.skipAction(this.generateNullable(wfme, wfme, seen));
                    continue;
                }
                FieldMapEntry rfme = reader.getFieldMapEntry(fname, true);
                production[--count] = this.generateNullable(wfme, rfme, seen);
            }
            for (String fname : rfname) {
                FieldMapEntry rfme = reader.getFieldMapEntry(fname, true);
                FieldDefImpl wf = writer.getField(fname);
                if (wf != null) continue;
                byte[] bb = ResolvingGrammarGenerator.getBinary(rfme, reader.getDefaultValue(fname));
                production[--count] = Symbol.defaultStartAction(bb);
                production[--count] = this.generateNullable(rfme, rfme, seen);
                production[--count] = Symbol.DEFAULT_END_ACTION;
            }
        }
        return result;
    }

    private static byte[] getBinary(FieldMapEntry s, FieldValueImpl n) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = factory.binaryEncoder(out, null);
        ResolvingGrammarGenerator.encodeNullable(e, s, n);
        e.flush();
        return out.toByteArray();
    }

    private static void encodeNullable(Encoder encoder, FieldMapEntry fme, FieldValueImpl n) throws IOException {
        FieldValueImpl fv = n;
        if (fv == null || fv.isNull()) {
            if (fv == null) {
                fv = fme.getDefaultValue();
            }
            if (fv.isNull()) {
                if (!fme.isNullable()) {
                    String fieldName = fme.getFieldName();
                    throw new IllegalCommandException("The field can not be null: " + fieldName);
                }
                encoder.writeIndex(fme.hasDefaultValue() ? 1 : 0);
                encoder.writeNull();
                return;
            }
        }
        if (fme.isNullable()) {
            encoder.writeIndex(fme.hasDefaultValue() ? 0 : 1);
        }
        ResolvingGrammarGenerator.encode(encoder, fme.getFieldDef(), n);
    }

    private static void encode(Encoder e, FieldDefImpl s, FieldValueImpl n) throws IOException {
        switch (s.getType()) {
            case RECORD: {
                for (String name : ((RecordDefImpl)s).getFields()) {
                    FieldMapEntry fme = ((RecordDefImpl)s).getFieldMapEntry(name, true);
                    FieldValueImpl v = null;
                    v = n == null || n.isNull() ? ((RecordDefImpl)s).getDefaultValue(name) : ((RecordValueImpl)n).get(name);
                    if (v == null) {
                        throw new SerializationRuntimeException("No default value for: " + name);
                    }
                    ResolvingGrammarGenerator.encodeNullable(e, fme, v);
                }
                break;
            }
            case ENUM: {
                e.writeEnum(((EnumDefImpl)s).indexOf(((EnumValueImpl)n).get()));
                break;
            }
            case FIXED_BINARY: {
                if (!n.isFixedBinary()) {
                    throw new SerializationRuntimeException("Non-string default value for fixed: " + n);
                }
                byte[] bb = ((FixedBinaryValueImpl)n).get();
                if (bb.length != ((FixedBinaryDefImpl)s).getSize()) {
                    bb = Arrays.copyOf(bb, ((FixedBinaryDefImpl)s).getSize());
                }
                e.writeFixed(bb);
                break;
            }
            case STRING: {
                if (!n.isString()) {
                    throw new SerializationRuntimeException("Non-string default value for string: " + n);
                }
                e.writeString(((StringValueImpl)n).get());
                break;
            }
            case TIMESTAMP: {
                if (!n.isTimestamp()) {
                    throw new SerializationRuntimeException("Non-string default value for timestamp: " + n);
                }
                e.writeBytes(((TimestampValueImpl)n).getTimestampBytes());
                break;
            }
            case NUMBER: {
                if (!n.isNumeric()) {
                    throw new SerializationRuntimeException("Non-string default value for number: " + n);
                }
                e.writeBytes(((NumberValueImpl)n).getNumberBytes());
                break;
            }
            case BINARY: {
                if (!n.isBinary()) {
                    throw new SerializationRuntimeException("Non-string default value for binary: " + n);
                }
                e.writeBytes(((BinaryValueImpl)n).getBytes());
                break;
            }
            case INTEGER: {
                if (!n.isNumeric()) {
                    throw new SerializationRuntimeException("Non-numeric default value for int: " + n);
                }
                e.writeInt(((IntegerValueImpl)n).get());
                break;
            }
            case LONG: {
                if (!n.isNumeric()) {
                    throw new SerializationRuntimeException("Non-numeric default value for long: " + n);
                }
                e.writeLong(((LongValueImpl)n).get());
                break;
            }
            case FLOAT: {
                if (!n.isNumeric()) {
                    throw new SerializationRuntimeException("Non-numeric default value for float: " + n);
                }
                e.writeFloat(((FloatValueImpl)n).get());
                break;
            }
            case DOUBLE: {
                if (!n.isNumeric()) {
                    throw new SerializationRuntimeException("Non-numeric default value for double: " + n);
                }
                e.writeDouble(((DoubleValueImpl)n).get());
                break;
            }
            case BOOLEAN: {
                if (!n.isBoolean()) {
                    throw new SerializationRuntimeException("Non-boolean default for boolean: " + n);
                }
                e.writeBoolean(((BooleanValueImpl)n).get());
                break;
            }
            case ARRAY: 
            case MAP: 
            case JSON: {
                break;
            }
        }
    }

    private static Symbol mkEnumAdjust(String[] writer, String[] reader) {
        LockableArrayList<String> wsymbols = new LockableArrayList<String>();
        for (String w : writer) {
            wsymbols.add(w);
        }
        LockableArrayList<String> rsymbols = new LockableArrayList<String>();
        for (String r : reader) {
            rsymbols.add(r);
        }
        Object[] adjustments = new Object[wsymbols.size()];
        for (int i = 0; i < adjustments.length; ++i) {
            int j = rsymbols.indexOf(wsymbols.get(i));
            adjustments[i] = j == -1 ? "No match for " + (String)wsymbols.get(i) : Integer.valueOf(j);
        }
        return Symbol.enumAdjustAction(rsymbols.size(), adjustments);
    }

    private static boolean bestBranch(FieldDefImpl r, FieldDefImpl w) {
        FieldDef.Type vt = w.getType();
        boolean find = false;
        if (vt == r.getType()) {
            if (vt == FieldDef.Type.RECORD || vt == FieldDef.Type.ENUM || vt == FieldDef.Type.FIXED_BINARY) {
                String wname = null;
                String rname = null;
                switch (vt) {
                    case RECORD: {
                        wname = ((RecordDefImpl)w).getName();
                        rname = ((RecordDefImpl)r).getName();
                        break;
                    }
                    case ENUM: {
                        wname = ((EnumDefImpl)w).getName();
                        rname = ((EnumDefImpl)r).getName();
                        break;
                    }
                    case FIXED_BINARY: {
                        wname = ((FixedBinaryDefImpl)w).getName();
                        rname = ((FixedBinaryDefImpl)r).getName();
                        break;
                    }
                }
                if (wname != null && wname.equals(rname) || wname == rname && vt == FieldDef.Type.RECORD) {
                    find = true;
                }
            } else {
                find = true;
            }
        }
        return find;
    }

    static class LockableArrayList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean locked = false;

        public LockableArrayList() {
        }

        public LockableArrayList(int size) {
            super(size);
        }

        public LockableArrayList(List<E> types) {
            super(types);
        }

        public List<E> lock() {
            this.locked = true;
            return this;
        }

        private void ensureUnlocked() {
            if (this.locked) {
                throw new IllegalStateException();
            }
        }

        @Override
        public boolean add(E e) {
            this.ensureUnlocked();
            return super.add(e);
        }

        @Override
        public boolean remove(Object o) {
            this.ensureUnlocked();
            return super.remove(o);
        }

        @Override
        public E remove(int index) {
            this.ensureUnlocked();
            return super.remove(index);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.ensureUnlocked();
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.ensureUnlocked();
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.ensureUnlocked();
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.ensureUnlocked();
            return super.retainAll(c);
        }

        @Override
        public void clear() {
            this.ensureUnlocked();
            super.clear();
        }
    }

    static class LitS2
    extends ValidatingGrammarGenerator.LitS {
        public FieldDefImpl expected;

        public LitS2(FieldDefImpl actual, FieldDefImpl expected) {
            super(actual);
            this.expected = expected;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LitS2)) {
                return false;
            }
            LitS2 other = (LitS2)o;
            return this.actual == other.actual && this.expected == other.expected;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.expected.hashCode();
        }
    }
}

