/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.serialize.parsing;

import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.serialize.parsing.Symbol;

class ValidatingGrammarGenerator {
    public static final String NULL = "null";

    ValidatingGrammarGenerator() {
    }

    protected Symbol generate(FieldDefImpl sc, Map<LitS, Symbol> seen) {
        switch (sc.getType()) {
            case BOOLEAN: {
                return Symbol.BOOLEAN;
            }
            case INTEGER: {
                return Symbol.INT;
            }
            case LONG: {
                return Symbol.LONG;
            }
            case FLOAT: {
                return Symbol.FLOAT;
            }
            case DOUBLE: {
                return Symbol.DOUBLE;
            }
            case STRING: {
                return Symbol.STRING;
            }
            case TIMESTAMP: 
            case NUMBER: 
            case BINARY: 
            case JSON: {
                return Symbol.BYTES;
            }
            case FIXED_BINARY: {
                return Symbol.seq(Symbol.intCheckAction(((FixedBinaryDefImpl)sc).getSize()), Symbol.FIXED);
            }
            case ENUM: {
                return Symbol.seq(Symbol.intCheckAction(((EnumDefImpl)sc).getValues().length), Symbol.ENUM);
            }
            case ARRAY: {
                return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(((ArrayDefImpl)sc).getElement(), seen)), Symbol.ARRAY_START);
            }
            case MAP: {
                return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(((MapDefImpl)sc).getElement(), seen), Symbol.STRING), Symbol.MAP_START);
            }
            case RECORD: {
                LitS wsc = new LitS(sc);
                Symbol rresult = seen.get(wsc);
                if (rresult == null) {
                    Symbol[] production = new Symbol[((RecordDefImpl)sc).getNumFields()];
                    rresult = Symbol.seq(production);
                    seen.put(wsc, rresult);
                    int i = production.length;
                    for (String fname : ((RecordDefImpl)sc).getFields()) {
                        FieldMapEntry fme = ((RecordDefImpl)sc).getFieldMapEntry(fname, true);
                        production[--i] = this.generateNullable(fme, seen);
                    }
                }
                return rresult;
            }
        }
        throw new RuntimeException("Unexpected schema type");
    }

    private Symbol generateNullable(FieldMapEntry fme, Map<LitS, Symbol> seen) {
        if (fme.isNullable()) {
            int size = 2;
            Symbol[] symbols = new Symbol[2];
            String[] labels = new String[2];
            if (fme.getDefaultValue().isNull()) {
                symbols[0] = Symbol.NULL;
                labels[0] = NULL;
                symbols[1] = this.generate(fme.getFieldDef(), seen);
                labels[1] = fme.getFieldName();
            } else {
                symbols[0] = this.generate(fme.getFieldDef(), seen);
                labels[0] = fme.getFieldName();
                symbols[1] = Symbol.NULL;
                labels[1] = NULL;
            }
            return Symbol.seq(Symbol.alt(symbols, labels), Symbol.UNION);
        }
        return this.generate(fme.getFieldDef(), seen);
    }

    static class LitS {
        public final FieldDefImpl actual;

        public LitS(FieldDefImpl actual) {
            this.actual = actual;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LitS)) {
                return false;
            }
            return this.actual == ((LitS)o).actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }
    }
}

