/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractCreatorEndpoint;
import oracle.kv.impl.async.AbstractListener;
import oracle.kv.impl.async.AbstractResponderEndpoint;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointGroup;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.SocketPrepared;
import oracle.kv.impl.util.ObjectUtil;

public abstract class AbstractEndpointGroup
implements EndpointGroup {
    private final Logger logger;
    private final ConcurrentHashMap<CreatorKey, AbstractCreatorEndpoint> creators = new ConcurrentHashMap();
    private final ConcurrentHashMap<ResponderKey, AbstractResponderEndpoint> responders = new ConcurrentHashMap();
    private final HashMap<ListenerConfig, Map<Integer, DialogHandlerFactory>> listenerDialogHandlerFactoryMap = new HashMap();
    private final HashMap<ListenerConfig, AbstractListener> listeners = new HashMap();
    private volatile boolean isShutdown = false;

    protected AbstractEndpointGroup(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public AbstractCreatorEndpoint getCreatorEndpoint(NetworkAddress remoteAddress, NetworkAddress localAddress, EndpointConfig endpointConfig) {
        AbstractCreatorEndpoint existingEndpoint;
        ObjectUtil.checkNull("remoteAddress", remoteAddress);
        ObjectUtil.checkNull("endpointConfig", endpointConfig);
        CreatorKey key = new CreatorKey(remoteAddress, endpointConfig);
        AbstractCreatorEndpoint endpoint = this.creators.get(key);
        if (endpoint == null && (existingEndpoint = this.creators.putIfAbsent(key, endpoint = this.newCreatorEndpoint(remoteAddress, localAddress, endpointConfig))) != null) {
            endpoint.shutdown("Concurrent creation of endpoint", true);
            endpoint = existingEndpoint;
        }
        if (this.isShutdown) {
            endpoint.shutdown("Endpoint group is shutdown", true);
            throw new IllegalStateException("Endpoint group is already shut down");
        }
        return endpoint;
    }

    @Override
    public AbstractResponderEndpoint getResponderEndpoint(NetworkAddress remoteAddress, ListenerConfig listenerConfig) {
        ObjectUtil.checkNull("remoteAddress", remoteAddress);
        ObjectUtil.checkNull("listenerConfig", listenerConfig);
        ResponderKey key = new ResponderKey(remoteAddress, listenerConfig);
        AbstractResponderEndpoint endpoint = this.responders.get(key);
        if (endpoint != null) {
            return endpoint;
        }
        return new AbstractResponderEndpoint.NullEndpoint(this, remoteAddress, listenerConfig, null);
    }

    public void addResponderEndpoint(AbstractResponderEndpoint endpoint) {
        ObjectUtil.checkNull("endpoint", endpoint);
        ResponderKey key = new ResponderKey(endpoint.getRemoteAddress(), endpoint.getListenerConfig());
        AbstractResponderEndpoint existingEndpoint = this.responders.putIfAbsent(key, endpoint);
        if (existingEndpoint != null) {
            existingEndpoint.shutdown("Race condition, should have been shut down", true);
            endpoint.shutdown("Race condition, existing one not shut down", true);
        }
    }

    public void removeResponderEndpoint(AbstractResponderEndpoint endpoint) {
        ObjectUtil.checkNull("endpoint", endpoint);
        ResponderKey key = new ResponderKey(endpoint.getRemoteAddress(), endpoint.getListenerConfig());
        AbstractResponderEndpoint existingEndpoint = this.responders.remove(key);
        if (existingEndpoint != endpoint && existingEndpoint != null) {
            existingEndpoint.shutdown("Race condition, not removing existing one", true);
        }
    }

    @Override
    public synchronized EndpointGroup.ListenHandle listen(ListenerConfig listenerConfig, int dialogType, DialogHandlerFactory handlerFactory) throws IOException {
        ObjectUtil.checkNull("listenerConfig", listenerConfig);
        ObjectUtil.checkNull("handlerFactory", handlerFactory);
        AbstractListener listener = this.getListener(listenerConfig);
        return listener.newListenHandle(dialogType, handlerFactory);
    }

    @Override
    public synchronized EndpointGroup.ListenHandle listen(ListenerConfig listenerConfig, SocketPrepared socketPrepared) throws IOException {
        ObjectUtil.checkNull("listenerConfig", listenerConfig);
        ObjectUtil.checkNull("socketPrepared", socketPrepared);
        AbstractListener listener = this.getListener(listenerConfig);
        return listener.newListenHandle(socketPrepared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean force) {
        this.isShutdown = true;
        while (!this.creators.isEmpty()) {
            Iterator<AbstractCreatorEndpoint> iter = this.creators.values().iterator();
            AbstractCreatorEndpoint endpoint = iter.next();
            iter.remove();
            if (endpoint == null) continue;
            endpoint.shutdown("Endpoint group is shut down", force);
        }
        AbstractEndpointGroup abstractEndpointGroup = this;
        synchronized (abstractEndpointGroup) {
            for (AbstractListener listener : new ArrayList<AbstractListener>(this.listeners.values())) {
                listener.shutdown();
            }
            this.listeners.clear();
        }
        this.shutdownInternal(force);
    }

    void removeListener(AbstractListener listener) {
        assert (Thread.holdsLock(this));
        this.listeners.remove(listener.getListenerConfig());
    }

    protected abstract AbstractCreatorEndpoint newCreatorEndpoint(NetworkAddress var1, NetworkAddress var2, EndpointConfig var3);

    protected abstract AbstractListener newListener(AbstractEndpointGroup var1, ListenerConfig var2, Map<Integer, DialogHandlerFactory> var3);

    protected abstract void shutdownInternal(boolean var1);

    private AbstractListener getListener(ListenerConfig listenerConfig) {
        AbstractListener listener;
        assert (Thread.holdsLock(this));
        if (this.isShutdown) {
            throw new IllegalStateException("Endpoint group is already shut down");
        }
        Map<Integer, DialogHandlerFactory> listenerDialogHandlerFactories = this.listenerDialogHandlerFactoryMap.get(listenerConfig);
        if (listenerDialogHandlerFactories == null) {
            listenerDialogHandlerFactories = new ConcurrentHashMap<Integer, DialogHandlerFactory>();
        }
        if ((listener = this.listeners.get(listenerConfig)) == null) {
            listener = this.newListener(this, listenerConfig, listenerDialogHandlerFactories);
            this.listeners.put(listenerConfig, listener);
        }
        return listener;
    }

    private class ResponderKey {
        private final NetworkAddress remoteAddress;
        private final ListenerConfig listenerConfig;

        public ResponderKey(NetworkAddress remoteAddress, ListenerConfig listenerConfig) {
            this.remoteAddress = remoteAddress;
            this.listenerConfig = listenerConfig;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResponderKey)) {
                return false;
            }
            ResponderKey that = (ResponderKey)obj;
            return this.remoteAddress.equals(that.remoteAddress) && this.listenerConfig.equals((Object)that.listenerConfig);
        }

        public int hashCode() {
            return 37 * this.remoteAddress.hashCode() + this.listenerConfig.hashCode();
        }
    }

    private class CreatorKey {
        private final NetworkAddress remoteAddress;
        private final EndpointConfig endpointConfig;

        public CreatorKey(NetworkAddress remoteAddress, EndpointConfig endpointConfig) {
            this.remoteAddress = remoteAddress;
            this.endpointConfig = endpointConfig;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatorKey)) {
                return false;
            }
            CreatorKey that = (CreatorKey)obj;
            return this.remoteAddress.equals(that.remoteAddress) && this.endpointConfig.equals(that.endpointConfig);
        }

        public int hashCode() {
            return 37 * this.remoteAddress.hashCode() + this.endpointConfig.hashCode();
        }
    }
}

