/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.concurrent.atomic.AtomicBoolean;
import oracle.kv.impl.async.ResultHandler;

public abstract class AbstractResultHandler<R>
implements ResultHandler<R> {
    private final AtomicBoolean called = new AtomicBoolean();

    protected AbstractResultHandler() {
    }

    protected IllegalStateException checkCallOnResult(R result, Throwable exception) {
        return AbstractResultHandler.checkCallOnResult(this.called, this, result, exception);
    }

    static IllegalStateException checkCallOnResult(AtomicBoolean called, ResultHandler<?> handler, Object result, Throwable exception) {
        return called.compareAndSet(false, true) ? null : new IllegalStateException("Attempt to call result handler more than once: handler=" + handler + " result=" + result + " exception=" + exception, exception);
    }

    static Throwable getUnexpectedException(ResultHandler<?> handler, Throwable exception) {
        return exception instanceof Error ? exception : new IllegalStateException("Unexpected exception: handler=" + handler + " exception=" + exception, exception);
    }
}

