/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.IterationSubscription;
import oracle.kv.impl.async.AsyncPublisherImpl;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.stats.DetailedMetrics;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AsyncIterationHandleImpl<E>
implements IterationHandleNotifier {
    private static final AtomicInteger openSubscriptions = new AtomicInteger();
    private final ThreadLocal<Boolean> inRequest = new ThreadLocal();
    private final Logger logger;
    private final Object lock = new Object();
    private AsyncTableIterator<E> asyncIterator;
    private Subscriber<? super E> subscriber;
    private boolean newSubscriber;
    private long requests;
    private boolean notifyingSubscriber;
    private boolean newNotify;
    private boolean onSubscribeCalled;
    private boolean complete;
    private boolean cancelCalled;
    private Throwable deliverException;

    public AsyncIterationHandleImpl(Logger logger) {
        this.logger = ObjectUtil.checkNull("logger", logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIterator(AsyncTableIterator<E> asyncIterator) {
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncIterator != null) {
                throw new AssertionError((Object)"Iterator has already been specified");
            }
            this.asyncIterator = ObjectUtil.checkNull("asyncIterator", asyncIterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super E> s) {
        assert (s != null) : "Caller should have checked for null";
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.subscriber != null) {
                    throw new AssertionError((Object)"Subscribe has already been called");
                }
                this.subscriber = s;
                if (this.asyncIterator == null) {
                    throw new AssertionError((Object)"No iterator");
                }
                this.newSubscriber = true;
            }
            this.notifyNext();
        }
        catch (Throwable t) {
            boolean callDummyOnSubscribe = false;
            boolean callOnError = false;
            Object object = this.lock;
            synchronized (object) {
                if (s != this.subscriber) {
                    callDummyOnSubscribe = true;
                    callOnError = true;
                } else {
                    if (!this.onSubscribeCalled) {
                        callDummyOnSubscribe = true;
                        this.onSubscribeCalled = true;
                    }
                    if (!this.complete) {
                        callOnError = true;
                        this.complete = true;
                    }
                }
            }
            if (callDummyOnSubscribe) {
                try {
                    s.onSubscribe(new AsyncPublisherImpl.DummySubscription());
                }
                catch (Throwable t2) {
                    this.logger.fine(() -> "Unexpected exception calling onSubscribe on subscriber: " + s + ", exception: " + t2);
                }
            }
            if (callOnError) {
                try {
                    s.onError(t);
                }
                catch (Throwable t2) {
                    this.logger.fine(() -> "Unexpected exception calling onError on subscriber: " + s + ", exception: " + t2);
                }
            }
            this.logger.log(Level.WARNING, "Unexpected exception: " + t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void request(long n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncIterator == null) {
                throw new AssertionError((Object)"No iterator");
            }
            if (n < 1L) {
                this.deliverException = new IllegalArgumentException("Request value must be greater than zero");
            } else {
                this.requests += n;
                if (this.requests <= 0L) {
                    this.requests = Long.MAX_VALUE;
                }
            }
        }
        if (this.inRequest.get() != null) {
            return;
        }
        this.inRequest.set(Boolean.TRUE);
        try {
            this.notifyNext();
        }
        finally {
            this.inRequest.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncIterator == null) {
                throw new AssertionError((Object)"No iterator");
            }
            if (this.cancelCalled) {
                return;
            }
            this.cancelCalled = true;
        }
        this.notifyNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DetailedMetrics> getPartitionMetrics() {
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncIterator == null) {
                return Collections.emptyList();
            }
        }
        return this.asyncIterator.getPartitionMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DetailedMetrics> getShardMetrics() {
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncIterator == null) {
                return Collections.emptyList();
            }
        }
        return this.asyncIterator.getShardMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNext() {
        boolean doOnSubscribe;
        if (Thread.holdsLock(this.lock)) {
            throw new AssertionError((Object)"Already holding lock in call to notifyNext");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.notifyingSubscriber) {
                this.newNotify = true;
                this.logger.finest("notifyNext newNotify=true");
                return;
            }
            if (this.subscriber == null) {
                return;
            }
            if (this.complete) {
                return;
            }
            doOnSubscribe = this.newSubscriber;
            this.newSubscriber = false;
            this.notifyingSubscriber = true;
            this.newNotify = false;
            this.logger.finest("notifyNext");
        }
        if (doOnSubscribe) {
            Subscription subscription = this.createSubscription();
            try {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.onSubscribeCalled = true;
                }
                this.subscriber.onSubscribe(subscription);
            }
            catch (Throwable e) {
                this.logger.fine(() -> "Unexpected exception calling onSubscribe on subscriber: " + this.subscriber + ", exception: " + e);
                Object object3 = this.lock;
                synchronized (object3) {
                    if (this.cancelCalled) {
                        this.notifyingSubscriber = false;
                        return;
                    }
                    this.cancelCalled = true;
                    this.deliverException = e instanceof Error ? e : new IllegalStateException("Unexpected exception calling onSubscribe on subscriber: " + this.subscriber + ", exception: " + e, e);
                }
            }
            this.noteOpeningSubscription();
        }
        Throwable exception = null;
        try {
            while (!this.notifyOneNext()) {
            }
        }
        catch (RuntimeException e) {
            exception = e;
            throw e;
        }
        catch (Error e) {
            exception = e;
            throw e;
        }
        finally {
            if (exception != null) {
                Object object4 = this.lock;
                synchronized (object4) {
                    this.notifyingSubscriber = false;
                }
                this.logger.log(Level.WARNING, "Unexpected exception: " + exception, exception);
            }
        }
    }

    protected Subscription createSubscription() {
        return new IterationSubscriptionImpl();
    }

    private void noteOpeningSubscription() {
        openSubscriptions.incrementAndGet();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Opening subscription, subscriber: " + this.subscriber + ", count: " + openSubscriptions.get());
        }
    }

    private void noteClosingSubscription(Subscriber<?> forSubscriber) {
        openSubscriptions.decrementAndGet();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Closing subscription, subscriber: " + forSubscriber + ", count: " + openSubscriptions.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyOneNext() {
        boolean done;
        assert (!this.complete);
        Object next = null;
        Throwable closeException = null;
        if (this.cancelCalled || this.deliverException != null) {
            closeException = this.deliverException;
            this.asyncIterator.close();
        } else if (this.requests > 0L && !this.asyncIterator.isClosed()) {
            try {
                next = this.asyncIterator.nextLocal();
            }
            catch (Throwable e) {
                closeException = e;
            }
        }
        if (next != null && (closeException = this.onNext(next)) != null) {
            this.asyncIterator.close();
            next = null;
        }
        boolean makeComplete = closeException != null ? true : (next != null ? false : this.asyncIterator.isClosed());
        Subscriber<? super E> savedSubscriber = this.subscriber;
        long originalRequests = this.requests;
        Object object = this.lock;
        synchronized (object) {
            if (next != null) {
                assert (this.requests > 0L);
                --this.requests;
            }
            if (makeComplete) {
                this.complete = true;
                this.subscriber = null;
                this.notifyingSubscriber = false;
                done = true;
            } else if (this.newNotify) {
                this.newNotify = false;
                done = false;
            } else if (next == null) {
                this.notifyingSubscriber = false;
                done = true;
            } else {
                done = false;
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("notifyNext next=" + next + " makeComplete=" + makeComplete + " newNotify=" + this.newNotify + " originalRequests=" + originalRequests + (closeException != null ? " closeException=" + closeException : "") + " done=" + done);
        }
        if (makeComplete) {
            if (closeException == null) {
                closeException = this.asyncIterator.getCloseException();
            }
            this.onComplete(savedSubscriber, closeException);
        }
        return done;
    }

    private Throwable onNext(E next) {
        try {
            this.subscriber.onNext(next);
            return null;
        }
        catch (Throwable t) {
            this.logger.fine(() -> "Unexpected exception calling onNext on subscriber: " + this.subscriber + ", exception: " + t);
            return t instanceof Error ? t : new IllegalStateException("Unexpected exception calling onNext on subscriber: " + this.subscriber + ", exception: " + t, t);
        }
    }

    private void onComplete(Subscriber<?> forSubscriber, Throwable exception) {
        this.noteClosingSubscription(forSubscriber);
        try {
            if (exception == null) {
                forSubscriber.onComplete();
            } else {
                forSubscriber.onError(exception);
            }
        }
        catch (Throwable t) {
            this.logger.fine(() -> "Unexpected exception calling " + (exception != null ? "onError" : "onComplete") + " on subscriber: " + forSubscriber + (exception != null ? ", exception being delivered: " + exception : "") + ", exception from subscriber: " + t);
        }
    }

    protected void finalize() {
        this.cancel();
    }

    protected class IterationSubscriptionImpl
    implements IterationSubscription {
        protected IterationSubscriptionImpl() {
        }

        @Override
        public void cancel() {
            AsyncIterationHandleImpl.this.cancel();
        }

        @Override
        public void request(long n) {
            AsyncIterationHandleImpl.this.request(n);
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return AsyncIterationHandleImpl.this.getPartitionMetrics();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return AsyncIterationHandleImpl.this.getShardMetrics();
        }
    }
}

