/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AsyncPublisherImpl<E>
implements Publisher<E> {
    private final Supplier<AsyncIterationHandleImpl<E>> handleSupplier;
    private final Logger logger;
    private Subscriber<? super E> subscriber;
    private boolean calledOnSubscribe;

    private AsyncPublisherImpl(Supplier<AsyncIterationHandleImpl<E>> handleSupplier, Logger logger) {
        this.handleSupplier = handleSupplier;
        this.logger = logger;
    }

    public static <E> Publisher<E> newInstance(Supplier<AsyncIterationHandleImpl<E>> handleSupplier, Logger logger) {
        return new AsyncPublisherImpl<E>(handleSupplier, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscriber<? super E> s) {
        AsyncIterationHandleImpl<E> handle;
        Objects.requireNonNull(s, "The subscriber must not be null");
        boolean callDummyOnSubscribe = false;
        boolean callOnError = false;
        AsyncPublisherImpl asyncPublisherImpl = this;
        synchronized (asyncPublisherImpl) {
            if (this.subscriber == null) {
                this.subscriber = s;
            } else {
                callOnError = true;
                if (!this.subscriber.equals(s)) {
                    callDummyOnSubscribe = true;
                } else if (!this.calledOnSubscribe) {
                    this.calledOnSubscribe = true;
                    callDummyOnSubscribe = true;
                }
            }
        }
        if (callDummyOnSubscribe) {
            this.callDummyOnSubscribe(s);
        }
        if (callOnError) {
            this.callOnError(s, new IllegalStateException("Calling subscribe multiple times on this publisher is not supported"));
            return;
        }
        try {
            handle = this.handleSupplier.get();
        }
        catch (Throwable e) {
            AsyncPublisherImpl asyncPublisherImpl2 = this;
            synchronized (asyncPublisherImpl2) {
                if (!this.calledOnSubscribe) {
                    this.calledOnSubscribe = true;
                    callDummyOnSubscribe = true;
                }
            }
            if (callDummyOnSubscribe) {
                this.callDummyOnSubscribe(s);
            }
            this.callOnError(s, e);
            return;
        }
        AsyncPublisherImpl asyncPublisherImpl3 = this;
        synchronized (asyncPublisherImpl3) {
            this.calledOnSubscribe = true;
        }
        handle.subscribe(s);
    }

    private void callDummyOnSubscribe(Subscriber<? super E> s) {
        try {
            s.onSubscribe(new DummySubscription());
        }
        catch (Throwable t) {
            this.logger.fine(() -> "Exception thrown when calling onSubscribe on subscriber: " + s + ", exception: " + t);
        }
    }

    private void callOnError(Subscriber<? super E> s, Throwable exception) {
        try {
            s.onError(exception);
        }
        catch (Throwable t) {
            this.logger.fine(() -> "Exception thrown when calling onError on subscriber: " + s + ", exception: " + t);
        }
    }

    static class DummySubscription
    implements Subscription {
        DummySubscription() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void request(long n) {
        }
    }
}

