/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncVersionedRemote;
import oracle.kv.impl.async.DialogContext;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializeExceptionUtil;

public abstract class AsyncVersionedRemoteDialogInitiator<R>
implements DialogHandler {
    private final MessageOutput request;
    private final Logger logger;
    private final ResultHandler<R> handler;
    private volatile State state = State.BEFORE_ON_START;

    protected AsyncVersionedRemoteDialogInitiator(MessageOutput request, Logger logger, ResultHandler<R> handler) {
        this.request = ObjectUtil.checkNull("request", request);
        this.logger = ObjectUtil.checkNull("logger", logger);
        this.handler = ObjectUtil.checkNull("handler", handler);
    }

    protected abstract R readResult(MessageInput var1, short var2) throws IOException;

    @Override
    public void onStart(DialogContext context, boolean aborted) {
        if (aborted) {
            return;
        }
        if (this.state != State.BEFORE_ON_START) {
            throw new IllegalStateException("Expected state BEFORE_ON_START, was " + (Object)((Object)this.state));
        }
        this.state = State.BEFORE_WRITE;
        if (context.write(this.request, true)) {
            this.state = State.BEFORE_READ;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format("Call initiator started %s dialogId=%x:%x peer=%s state=%s", new Object[]{this, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress(), this.state}));
        }
    }

    @Override
    public void onCanWrite(DialogContext context) {
        if (this.state != State.BEFORE_WRITE) {
            throw new IllegalStateException("Expected state BEFORE_WRITE, was " + (Object)((Object)this.state));
        }
        if (context.write(this.request, true)) {
            this.state = State.BEFORE_READ;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format("Call initiator write %s dialogId=%x:%x peer=%s state=%s", new Object[]{this, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress(), this.state}));
        }
    }

    @Override
    public void onCanRead(DialogContext context, boolean finished) {
        Throwable exception;
        Object result;
        if (this.state != State.BEFORE_READ) {
            this.handler.onResult(null, new IllegalStateException("Expected state BEFORE_READ, was " + (Object)((Object)this.state)));
            return;
        }
        if (!finished) {
            this.handler.onResult(null, new IllegalStateException("Only expect one response"));
            return;
        }
        MessageInput response = context.read();
        if (response == null) {
            throw new IllegalStateException("Unexpected null read");
        }
        this.state = State.DONE;
        try {
            switch (AsyncVersionedRemote.ResponseType.readFastExternal(response, (short)14)) {
                case SUCCESS: {
                    short serialVersion = response.readShort();
                    result = this.readResult(response, serialVersion);
                    exception = null;
                    this.logger.fine(() -> String.format("Call initiator completed %s dialogId=%x:%x peer=%s result=%s", this, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress(), result));
                    break;
                }
                case FAILURE: {
                    short serialVersion = response.readShort();
                    result = null;
                    exception = SerializeExceptionUtil.readException(response, serialVersion);
                    this.logger.fine(() -> String.format("Call initiator failed %s dialogId=%x:%x peer=%s exception=%s", this, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress(), exception));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.FINE, e, () -> String.format("Call initiator unexpected exception %s dialogId=%x:%x peer=%s", this.handler, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress()));
            this.handler.onResult(null, new RuntimeException("Unexpected problem reading result: " + e, e));
            return;
        }
        this.handler.onResult(result, exception);
    }

    @Override
    public void onAbort(DialogContext context, Throwable exception) {
        this.state = State.DONE;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format("Call initiator aborted %s dialogId=%x:%x peer=%s", this.handler, context.getDialogId(), context.getConnectionId(), context.getRemoteAddress()), exception);
        }
        this.handler.onResult(null, exception);
    }

    static enum State {
        BEFORE_ON_START,
        BEFORE_WRITE,
        BEFORE_READ,
        DONE;

    }
}

