/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.concurrent.TimeUnit;
import oracle.kv.FaultException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.async.UncaughtResultHandler;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.impl.util.ObjectUtil;

public class BlockingResultHandler<R>
extends UncaughtResultHandler<R> {
    private R value;
    private Throwable exception;
    private boolean done;

    public BlockingResultHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    public R await(long timeoutMillis) {
        return this.await(timeoutMillis, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R await(long originalTimeoutMillis, long currentTimeoutMillis) {
        this.awaitInternal(currentTimeoutMillis);
        FaultException timeoutException = null;
        while (true) {
            BlockingResultHandler blockingResultHandler = this;
            synchronized (blockingResultHandler) {
                if (this.done) {
                    if (this.exception != null) {
                        this.rethrowException(this.exception, RuntimeException.class);
                    }
                    return this.value;
                }
                if (timeoutException != null) {
                    this.exception = timeoutException;
                    this.done = true;
                    throw timeoutException;
                }
            }
            timeoutException = this.getTimeoutException(originalTimeoutMillis);
            assert (timeoutException != null);
        }
    }

    protected FaultException getTimeoutException(long originalTimeoutMillis) {
        return new RequestTimeoutException((int)originalTimeoutMillis, "Request timed out" + this.getDescriptionString(), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> R awaitChecked(Class<E> exceptionType, long timeoutMillis) throws E {
        ObjectUtil.checkNull("exceptionType", exceptionType);
        this.awaitInternal(timeoutMillis);
        BlockingResultHandler blockingResultHandler = this;
        synchronized (blockingResultHandler) {
            if (!this.done) {
                throw new RequestTimeoutException((int)timeoutMillis, "Request timed out" + this.getDescriptionString(), null, false);
            }
            if (this.exception != null) {
                this.rethrowException(this.exception, exceptionType);
            }
            return this.value;
        }
    }

    protected String getDescription() {
        return null;
    }

    private String getDescriptionString() {
        String desc = this.getDescription();
        return desc == null ? "" : ": " + desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitInternal(long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Timeout must be 0 or greater");
        }
        long stop = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutMillis, TimeUnit.MILLISECONDS);
        while (true) {
            BlockingResultHandler blockingResultHandler = this;
            synchronized (blockingResultHandler) {
                if (this.done) {
                    break;
                }
                long wait = TimeUnit.MILLISECONDS.convert(stop - System.nanoTime(), TimeUnit.NANOSECONDS);
                if (wait <= 0L) {
                    break;
                }
                try {
                    this.wait(wait);
                }
                catch (InterruptedException e) {
                    throw new FaultException("Operation was interrupted while waiting for result" + this.getDescriptionString(), e, false);
                }
            }
        }
    }

    private <E extends Throwable> void rethrowException(Throwable e, Class<E> allowableThrowType) throws E {
        if (allowableThrowType.isInstance(e)) {
            CommonLoggerUtils.appendCurrentStack(e);
            throw (Throwable)allowableThrowType.cast(e);
        }
        if (e instanceof Error) {
            CommonLoggerUtils.appendCurrentStack(e);
            throw (Error)e;
        }
        throw new FaultException("Unexpected exception: " + e, e, false);
    }

    @Override
    protected synchronized void onResultInternal(R result, Throwable e) {
        if (!this.done) {
            this.value = result;
            this.exception = e;
            this.done = true;
            this.notifyAll();
        }
    }
}

