/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class BytesUtil {
    private static final int NUM_BYTES_PER_LINE = 16;
    private static final int LINE_NUM_WIDTH = 12;
    private static final int BYTE_ASCII_SEPARATE_WIDTH = 4;
    private static final int BYTE_REPR_WIDTH = 2;
    private static final int BYTE_SEPARATOR_WIDTH = 1;
    private static final int BYTE_REPR_SEP_WIDTH = 3;
    private static final int ASCII_CHAR_WIDTH = 1;
    private static final int LINE_WIDTH = 81;

    public static int bytesToInt(byte[] array, int offset) {
        return (array[offset] << 24) + ((array[offset + 1] & 0xFF) << 16) + ((array[offset + 2] & 0xFF) << 8) + (array[offset + 3] & 0xFF);
    }

    public static String toString(byte[] array) {
        if (array == null) {
            return "[/]";
        }
        return BytesUtil.toString(array, 0, array.length);
    }

    public static String toString(byte[] array, int offset, int len) {
        if (array == null) {
            return "[/]";
        }
        char lineEnd = offset % 16 + (len = Math.min(len, array.length - offset)) <= 16 ? (char)' ' : '\n';
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=").append(offset).append(", len=").append(len).append(lineEnd);
        builder.append(BytesUtil.bytesToHex(array, offset, len, lineEnd));
        builder.append("]");
        return builder.toString();
    }

    private static String bytesToHex(byte[] array, int offset, int len, char lineEnd) {
        return BytesUtil.bytesToHex((Integer i) -> array[i], offset, len, lineEnd);
    }

    private static String bytesToHex(Function<Integer, Byte> func, int offset, int len, char lineEnd) {
        int nlines = (offset % 16 + len + 16 - 1) / 16;
        char[] hexArray = new char[nlines * 81];
        Arrays.fill(hexArray, ' ');
        for (int i = 0; i < nlines; ++i) {
            hexArray[(i + 1) * 81 - 1] = lineEnd;
        }
        BytesUtil.fillLineNumbers(hexArray, nlines, offset);
        BytesUtil.fillLines(hexArray, func, offset, len);
        return new String(hexArray);
    }

    private static void fillLineNumbers(char[] hexArray, int nlines, int offset) {
        int curr = offset / 16 * 16;
        for (int i = 0; i < nlines; ++i) {
            hexArray[i * 81 + 0] = 48;
            hexArray[i * 81 + 1] = 120;
            int shift = curr;
            for (int j = 0; j < 8; ++j) {
                hexArray[i * 81 + 1 + (8 - j)] = Character.forDigit(shift & 0xF, 16);
                shift >>>= 4;
            }
            hexArray[i * 81 + 12 - 2] = 58;
            hexArray[i * 81 + 12 - 1] = 32;
            curr += 16;
        }
    }

    private static void fillLines(char[] hexArray, Function<Integer, Byte> func, int offset, int len) {
        int v;
        int i;
        int padding = offset - offset / 16 * 16;
        int idx = 12 + padding * 3;
        for (i = 0; i < len; ++i) {
            v = func.apply(i + offset) & 0xFF;
            hexArray[idx + i * 3] = Character.toUpperCase(Character.forDigit(v >>> 4, 16));
            hexArray[idx + i * 3 + 1] = Character.toUpperCase(Character.forDigit(v & 0xF, 16));
            if ((offset + i + 1) % 16 != 0) continue;
            idx += 33;
        }
        idx = 64 + padding * 1;
        for (i = 0; i < len; ++i) {
            v = func.apply(i + offset) & 0xFF;
            int val = v <= 31 || v >= 127 ? 46 : v;
            hexArray[idx + i * 1] = (char)val;
            if ((offset + i + 1) % 16 != 0) continue;
            idx += 65;
        }
    }

    public static String toString(ByteBuffer buf, int len) {
        if (buf == null) {
            return "[/]";
        }
        StringBuilder builder = new StringBuilder();
        int pos = buf.position();
        int lim = buf.limit();
        int cap = buf.capacity();
        char lineEnd = (len = Math.min(len, lim - pos)) < 16 ? (char)' ' : '\n';
        builder.append("[").append("pos=").append(pos).append(",lim=").append(lim).append(",cap=").append(cap).append(lineEnd);
        builder.append(BytesUtil.bytesToHex(buf, pos, len, lineEnd)).append(lineEnd);
        builder.append("]");
        return builder.toString();
    }

    private static String bytesToHex(ByteBuffer buf, int offset, int len, char lineEnd) {
        return BytesUtil.bytesToHex((Integer i) -> buf.get((int)i), offset, len, lineEnd);
    }

    public static String toString(ByteBuffer[] buffers, int offset, int nbufs, int len) {
        if (buffers == null) {
            return "{/}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("byte buffer offset=").append(offset).append("\n");
        builder.append(offset > 0 ? "...\n" : "\n");
        int end = Math.min(buffers.length, offset + nbufs);
        for (int i = offset; i < end; ++i) {
            builder.append(BytesUtil.toString(buffers[i], len)).append("\n");
        }
        builder.append(end < buffers.length ? "...\n" : "\n");
        builder.append("}");
        return builder.toString();
    }

    public static String toString(Collection<ByteBuffer> bufs, int offset, int nbufs, int len) {
        if (bufs == null) {
            return "{/}";
        }
        int cnt0 = offset;
        int cnt1 = Math.min(bufs.size(), nbufs);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("byte buffer offset=").append(offset).append("\n");
        builder.append(offset > 0 ? "...\n" : "\n");
        for (ByteBuffer buf : bufs) {
            if (--cnt0 > 0) continue;
            builder.append(BytesUtil.toString(buf, len)).append("\n");
            if (--cnt1 > 0) continue;
            break;
        }
        builder.append(offset + nbufs < bufs.size() ? "...\n" : "\n");
        builder.append("}");
        return builder.toString();
    }
}

