/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.kv.impl.async.AbstractResultHandler;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.util.ObjectUtil;

public class CompletableFutureHandler<T>
extends CompletableFuture<T>
implements ResultHandler<T> {
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final AtomicBoolean called = new AtomicBoolean();

    public CompletableFutureHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = ObjectUtil.checkNull("exceptionHandler", exceptionHandler);
    }

    @Override
    public void onResult(T result, Throwable exception) {
        IllegalStateException already = AbstractResultHandler.checkCallOnResult(this.called, this, result, exception);
        if (already != null) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), already);
            return;
        }
        try {
            if (exception != null) {
                this.completeExceptionally(exception);
            } else {
                this.complete(result);
            }
        }
        catch (Throwable t) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), AbstractResultHandler.getUnexpectedException(this, t));
        }
    }
}

