/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.IOBufferPool;
import oracle.kv.impl.util.ObjectUtil;

public abstract class IOBufSliceImpl
extends IOBufSliceList.Entry {
    private static final String TRACK_SLICE = "oracle.kv.async.bufslice.track";
    private static final boolean trackSlice = Boolean.getBoolean("oracle.kv.async.bufslice.track");
    private static final int MAX_NUM_SLICES_TOSTRING = 16;
    private static final Map<Integer, SliceAndDescription> allocatedSlices = new ConcurrentHashMap<Integer, SliceAndDescription>();
    private static final int MAX_NUM_BYTES_TOSTRING = 8;
    private final ByteBuffer buffer;

    public static String remainingSlicesToString() {
        if (!trackSlice) {
            return String.format("unavailable (enable by -D%s=true)", TRACK_SLICE);
        }
        int cnt = 0;
        StringBuilder builder = new StringBuilder("\n");
        for (SliceAndDescription val : allocatedSlices.values()) {
            builder.append("\t").append(val).append("\n");
            if (cnt++ <= 16) continue;
            builder.append("...");
            break;
        }
        builder.append("\n");
        return builder.toString();
    }

    protected IOBufSliceImpl(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ByteBuffer buf() {
        return this.buffer;
    }

    @Override
    public IOBufSliceImpl forkAndAdvance(int len, String description) {
        if (len <= 0) {
            throw new IllegalArgumentException("Forking IOBufSlice with Invalid length: " + len);
        }
        ByteBuffer buf = this.buf();
        int advancedPos = buf.position() + len;
        ByteBuffer childBuf = buf.duplicate();
        buf.position(advancedPos);
        childBuf.limit(advancedPos);
        return this.forkNewSlice(childBuf, description);
    }

    @Override
    public IOBufSliceImpl forkBackwards(int len, String description) {
        if (len <= 0 || len > this.buf().position()) {
            throw new IllegalArgumentException(String.format("Forking IOBufSlice with Invalid length: %d, current position: %d", len, this.buf().position()));
        }
        ByteBuffer buf = this.buf();
        int pos = buf.position() - len;
        int lim = buf.position();
        ByteBuffer childBuf = buf.duplicate();
        childBuf.position(pos);
        childBuf.limit(lim);
        return this.forkNewSlice(childBuf, description);
    }

    protected abstract IOBufSliceImpl forkNewSlice(ByteBuffer var1, String var2);

    private static IOBufSliceImpl noteNewSlice(IOBufSliceImpl slice, String description) {
        if (trackSlice) {
            allocatedSlices.put(Objects.hashCode(slice), new SliceAndDescription(slice, description));
        }
        return slice;
    }

    private static void noteFreeSlice(IOBufSliceImpl slice) {
        if (trackSlice) {
            allocatedSlices.remove(Objects.hashCode(slice));
        }
    }

    private static class SliceAndDescription {
        private final IOBufSliceImpl slice;
        private final String description;

        private SliceAndDescription(IOBufSliceImpl slice, String description) {
            this.slice = slice;
            this.description = description;
        }

        public String toString() {
            return String.format("%s: %s", this.description, this.slice);
        }
    }

    private static class OutputPoolForkedBufSlice
    extends ThreadSafeRefCntPooledBufSlice {
        private final IOBufSliceImpl parent;

        protected OutputPoolForkedBufSlice(IOBufSliceImpl parent, ByteBuffer buffer) {
            super(buffer);
            ObjectUtil.checkNull("parent", parent);
            this.parent = parent;
        }

        @Override
        protected IOBufSliceImpl parent() {
            return this.parent;
        }

        @Override
        protected IOBufSliceImpl forkNewSlice(ByteBuffer buffer, String description) {
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new OutputPoolForkedBufSlice(this, buffer), description);
        }
    }

    private static class InputPoolForkedBufSlice
    extends ThreadUnsafeRefCntPooledBufSlice {
        private final IOBufSliceImpl parent;

        protected InputPoolForkedBufSlice(IOBufSliceImpl parent, ByteBuffer buffer) {
            super(buffer);
            ObjectUtil.checkNull("parent", parent);
            this.parent = parent;
        }

        @Override
        protected IOBufSliceImpl parent() {
            return this.parent;
        }

        @Override
        protected IOBufSliceImpl forkNewSlice(ByteBuffer buffer, String description) {
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new InputPoolForkedBufSlice(this, buffer), description);
        }
    }

    private static abstract class ThreadSafeRefCntPooledBufSlice
    extends PooledBufSlice {
        private static final AtomicIntegerFieldUpdater<ThreadSafeRefCntPooledBufSlice> refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(ThreadSafeRefCntPooledBufSlice.class, "refcnt");
        protected volatile int refcnt;

        protected ThreadSafeRefCntPooledBufSlice(ByteBuffer buffer) {
            super(buffer);
            refCntUpdater.set(this, 1);
        }

        @Override
        protected void incRefCnt() {
            refCntUpdater.incrementAndGet(this);
        }

        @Override
        protected int decRefCnt() {
            int val = refCntUpdater.decrementAndGet(this);
            if (val < 0) {
                throw new IllegalStateException(String.format("Reference count value %d less than zero for %s", val, this.getClass().getSimpleName()));
            }
            return val;
        }

        @Override
        protected int getRefCnt() {
            return refCntUpdater.get(this);
        }
    }

    private static abstract class ThreadUnsafeRefCntPooledBufSlice
    extends PooledBufSlice {
        protected int refcnt = 1;

        protected ThreadUnsafeRefCntPooledBufSlice(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        protected void incRefCnt() {
            ++this.refcnt;
        }

        @Override
        protected int decRefCnt() {
            if (this.refcnt <= 0) {
                throw new IllegalStateException(String.format("Invalid decRefCnt() on %s", this));
            }
            return --this.refcnt;
        }

        @Override
        protected int getRefCnt() {
            return this.refcnt;
        }
    }

    private static abstract class PooledBufSlice
    extends IOBufSliceImpl {
        protected PooledBufSlice(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public IOBufSliceImpl forkAndAdvance(int len, String description) {
            this.incRefCnt();
            return super.forkAndAdvance(len, description);
        }

        @Override
        public IOBufSliceImpl forkBackwards(int len, String description) {
            this.incRefCnt();
            return super.forkBackwards(len, description);
        }

        @Override
        public void markFree() {
            if (this.decRefCnt() == 0) {
                this.parent().markFree();
                IOBufSliceImpl.noteFreeSlice((IOBufSliceImpl)this);
            }
        }

        public String toString() {
            return String.format("(id=%x p=%x n=%x, r=%d, b=%x)%s", System.identityHashCode(this), System.identityHashCode(this.parent()), System.identityHashCode(this.next()), this.getRefCnt(), System.identityHashCode(this.buf()), BytesUtil.toString(this.buf(), Math.min(this.buf().limit(), 8)));
        }

        protected abstract IOBufSliceImpl parent();

        protected abstract void incRefCnt();

        protected abstract int decRefCnt();

        protected abstract int getRefCnt();
    }

    public static class HeapBufSlice
    extends IOBufSliceImpl {
        public HeapBufSlice(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public void markFree() {
        }

        @Override
        protected HeapBufSlice forkNewSlice(ByteBuffer buffer, String description) {
            return new HeapBufSlice(buffer);
        }

        public String toString() {
            return BytesUtil.toString(this.buf(), Math.min(this.buf().limit(), 8));
        }
    }

    public static class OutputPoolBufSlice
    extends ThreadSafeRefCntPooledBufSlice {
        private final IOBufferPool pool;

        private OutputPoolBufSlice(IOBufferPool pool, ByteBuffer buffer) {
            super(buffer);
            this.pool = pool;
        }

        @Override
        public void markFree() {
            if (this.decRefCnt() == 0) {
                this.pool.deallocate(this.buf());
                IOBufSliceImpl.noteFreeSlice((IOBufSliceImpl)this);
            }
        }

        @Override
        protected IOBufSliceImpl parent() {
            return null;
        }

        @Override
        protected IOBufSliceImpl forkNewSlice(ByteBuffer buffer, String description) {
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new OutputPoolForkedBufSlice(this, buffer), description);
        }

        public static IOBufSliceImpl createFromPool(IOBufferPool pool, String description) {
            ByteBuffer buffer = pool.allocPooled();
            if (buffer == null) {
                return new HeapBufSlice(pool.allocDiscarded());
            }
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new OutputPoolBufSlice(pool, buffer), description);
        }
    }

    public static class InputPoolBufSlice
    extends ThreadUnsafeRefCntPooledBufSlice {
        private final IOBufferPool pool;

        private InputPoolBufSlice(IOBufferPool pool, ByteBuffer buffer) {
            super(buffer);
            this.pool = pool;
        }

        @Override
        public void markFree() {
            if (this.decRefCnt() == 0) {
                this.pool.deallocate(this.buf());
                IOBufSliceImpl.noteFreeSlice((IOBufSliceImpl)this);
            }
        }

        @Override
        protected IOBufSliceImpl parent() {
            return null;
        }

        @Override
        protected IOBufSliceImpl forkNewSlice(ByteBuffer buffer, String description) {
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new InputPoolForkedBufSlice(this, buffer), description);
        }

        public static IOBufSliceImpl createFromPool(IOBufferPool pool, String description) {
            ByteBuffer buffer = pool.allocPooled();
            if (buffer == null) {
                return new HeapBufSlice(pool.allocDiscarded());
            }
            return IOBufSliceImpl.noteNewSlice((IOBufSliceImpl)new InputPoolBufSlice(pool, buffer), description);
        }
    }
}

