/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.nio.ByteBuffer;
import oracle.kv.impl.async.IOBufSlice;
import oracle.kv.impl.async.IOBufSliceImpl;
import oracle.kv.impl.util.ObjectUtil;

public class IOBufSliceList {
    private final Entry sentinel = new Sentinel();
    private Entry tail = null;
    private int size = 0;

    public Entry head() {
        return this.sentinel.next();
    }

    public Entry tail() {
        return this.tail;
    }

    public void add(Entry entry) {
        ObjectUtil.checkNull("entry", entry);
        if (this.tail == null) {
            this.sentinel.next(entry);
        } else {
            this.tail.next(entry);
        }
        entry.next(null);
        this.tail = entry;
        ++this.size;
    }

    public void extend(IOBufSliceList other) {
        if (other.isEmpty()) {
            return;
        }
        Entry last = this.tail == null ? this.sentinel : this.tail;
        last.next(other.head());
        other.tail.next(null);
        this.tail = other.tail;
        this.size += other.size;
        other.sentinel.next(null);
        other.tail = null;
        other.size = 0;
    }

    public Entry poll() {
        Entry head = this.head();
        if (head == null) {
            return null;
        }
        Entry next = head.next();
        this.sentinel.next(next);
        head.next(null);
        if (head == this.tail) {
            this.tail = null;
        }
        --this.size;
        return head;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ByteBuffer[] toBufArray() {
        ByteBuffer[] array = new ByteBuffer[this.size];
        if (this.size == 0) {
            return array;
        }
        Entry curr = this.head();
        for (int i = 0; i < this.size; ++i) {
            array[i] = curr.buf();
            curr = curr.next();
        }
        if (curr != null) {
            throw new AssertionError((Object)String.format("Expected null, got %s", curr));
        }
        return array;
    }

    public void freeEntries() {
        Entry entry;
        while ((entry = this.poll()) != null) {
            entry.markFree();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Entry curr = this.head(); curr != null; curr = curr.next()) {
            sb.append(curr);
            sb.append("->");
        }
        sb.append("}");
        return sb.toString();
    }

    private class Sentinel
    extends Entry {
        private Sentinel() {
        }

        @Override
        public ByteBuffer buf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IOBufSliceImpl forkAndAdvance(int len, String description) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IOBufSliceImpl forkBackwards(int len, String description) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void markFree() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Entry entryNotSentinel() {
            return null;
        }

        @Override
        protected boolean isSentinel() {
            return true;
        }
    }

    public static abstract class Entry
    implements IOBufSlice {
        private Entry next;

        Entry() {
            this(null);
        }

        Entry(Entry next) {
            this.next = next;
        }

        void next(Entry n) {
            this.next = n;
        }

        public Entry next() {
            return this.next == null ? null : this.next.entryNotSentinel();
        }

        protected Entry entryNotSentinel() {
            return this;
        }

        protected boolean isSentinel() {
            return false;
        }
    }
}

