/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.DataInput;
import java.io.EOFException;
import java.util.LinkedList;
import java.util.Queue;
import oracle.kv.impl.async.BytesInput;

public class MessageInput
implements DataInput {
    private final Queue<BytesInput> inputs = new LinkedList<BytesInput>();

    @Override
    public void readFully(byte[] b) throws EOFException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        int n;
        if (len == 0) {
            return;
        }
        do {
            BytesInput input;
            if ((input = this.inputs.peek()) == null) {
                throw new EOFException();
            }
            int remaining = input.remaining();
            n = Math.min(len, remaining);
            input.readFully(b, off, n);
            off += n;
            this.pollIfConsumed();
        } while ((len -= n) != 0);
    }

    @Override
    public int skipBytes(int len) {
        int n;
        int skipped = 0;
        do {
            BytesInput input;
            if ((input = this.inputs.peek()) == null) {
                return skipped;
            }
            int remaining = input.remaining();
            n = Math.min(remaining, len);
            try {
                input.skipBytes(n);
            }
            catch (EOFException e) {
                throw new AssertionError();
            }
            skipped += n;
            this.pollIfConsumed();
        } while ((len -= n) != 0);
        return skipped;
    }

    @Override
    public boolean readBoolean() throws EOFException {
        byte b = this.readByte();
        return b != 0;
    }

    @Override
    public byte readByte() throws EOFException {
        BytesInput input = this.inputs.peek();
        if (input == null) {
            throw new EOFException();
        }
        byte b = input.readByte();
        this.pollIfConsumed();
        return b;
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws EOFException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        return (short)(b0 << 8 | b1 & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        return (b0 & 0xFF) << 8 | b1 & 0xFF;
    }

    @Override
    public char readChar() throws EOFException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        return (char)(b0 << 8 | b1 & 0xFF);
    }

    @Override
    public int readInt() throws EOFException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        return b0 << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 0;
    }

    @Override
    public long readLong() throws EOFException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        byte b5 = this.readByte();
        byte b6 = this.readByte();
        byte b7 = this.readByte();
        return (long)b0 << 56 | (long)(b1 & 0xFF) << 48 | (long)(b2 & 0xFF) << 40 | (long)(b3 & 0xFF) << 32 | (long)(b4 & 0xFF) << 24 | (long)((b5 & 0xFF) << 16) | (long)((b6 & 0xFF) << 8) | (long)((b7 & 0xFF) << 0);
    }

    @Override
    public float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException("Use oracle.kv.impl.util.SerializationUtil.readString");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[");
        for (BytesInput input : this.inputs) {
            sb.append(input.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public void add(BytesInput input) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input.remaining() == 0) {
            return;
        }
        this.inputs.add(input);
    }

    public void discard() {
        BytesInput input;
        while ((input = this.inputs.poll()) != null) {
            input.discard();
        }
    }

    private void pollIfConsumed() {
        BytesInput input = this.inputs.peek();
        if (input == null) {
            return;
        }
        if (input.remaining() == 0) {
            this.inputs.poll();
        }
    }
}

