/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.DataOutput;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.kv.impl.async.IOBufSliceImpl;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.IOBufferPool;

public class MessageOutput
implements DataOutput {
    public static final int MAX_COPY_BYTES_SIZE = 16;
    private static final String FRAME_POLLED_MESSAGE = "The frames of this message output have already been polled. That is, the output has already either been written to the channel or discarded";
    private final IOBufferPool pool;
    private IOBufSliceImpl sliceForScatter;
    private ByteBuffer bufForScatter;
    private int pos = 0;
    private final IOBufSliceList outputs = new IOBufSliceList();
    private volatile int nbytesTotal = 0;
    private final AtomicBoolean framesPolled = new AtomicBoolean(false);

    public MessageOutput() {
        this(IOBufferPool.MESG_OUT_POOL);
    }

    public MessageOutput(IOBufferPool pool) {
        this.pool = pool;
        this.sliceForScatter = IOBufSliceImpl.OutputPoolBufSlice.createFromPool(pool, "scatter data 0 for message output");
        this.bufForScatter = this.sliceForScatter.buf();
    }

    @Override
    public void write(int b) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(1);
        this.bufForScatter.put((byte)b);
        ++this.nbytesTotal;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureFramesNotPolled();
        if (len == 0) {
            return;
        }
        if (len > 0 && len <= 16) {
            this.allocIfLessThan(len);
            this.bufForScatter.put(b, off, len);
        } else {
            this.appendBufferedToOutput();
            this.outputs.add(new IOBufSliceImpl.HeapBufSlice(ByteBuffer.wrap(b, off, len)));
        }
        this.nbytesTotal += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeShort(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(2);
        this.bufForScatter.putShort((short)v);
        this.nbytesTotal += 2;
    }

    @Override
    public void writeChar(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(2);
        this.bufForScatter.putChar((char)v);
        this.nbytesTotal += 2;
    }

    @Override
    public void writeInt(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(4);
        this.bufForScatter.putInt(v);
        this.nbytesTotal += 4;
    }

    @Override
    public void writeLong(long v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(8);
        this.bufForScatter.putLong(v);
        this.nbytesTotal += 8;
    }

    @Override
    public void writeFloat(float v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(4);
        this.bufForScatter.putFloat(v);
        this.nbytesTotal += 4;
    }

    @Override
    public void writeDouble(double v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(8);
        this.bufForScatter.putDouble(v);
        this.nbytesTotal += 8;
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) throws UTFDataFormatException {
        throw new UnsupportedOperationException("Use oracle.kv.impl.util.SerializationUtil.writeString");
    }

    public int size() {
        return this.nbytesTotal;
    }

    public void discard() {
        if (this.framesPolled.compareAndSet(false, true)) {
            this.sliceForScatter.markFree();
            this.outputs.freeEntries();
        }
    }

    public Queue<IOBufSliceList> pollFrames(int frameSize) {
        IOBufSliceList.Entry slice;
        if (frameSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.framesPolled.compareAndSet(false, true)) {
            throw new IllegalStateException(FRAME_POLLED_MESSAGE);
        }
        this.appendBufferedToOutput();
        LinkedList<IOBufSliceList> frames = new LinkedList<IOBufSliceList>();
        if (this.outputs.isEmpty()) {
            return frames;
        }
        IOBufSliceList frame = new IOBufSliceList();
        int size = 0;
        frames.add(frame);
        while ((slice = this.outputs.poll()) != null) {
            int remaining;
            ByteBuffer buf = slice.buf();
            while ((remaining = buf.remaining()) != 0) {
                if (size == frameSize) {
                    frame = new IOBufSliceList();
                    size = 0;
                    frames.add(frame);
                }
                int inc = Math.min(remaining, frameSize - size);
                frame.add(slice.forkAndAdvance(inc, "message output to frame"));
                size += inc;
            }
            slice.markFree();
        }
        this.sliceForScatter.markFree();
        return frames;
    }

    private void allocIfLessThan(int val) {
        if (this.bufForScatter.remaining() >= val) {
            return;
        }
        this.appendBufferedToOutput();
        this.sliceForScatter.markFree();
        this.sliceForScatter = IOBufSliceImpl.OutputPoolBufSlice.createFromPool(this.pool, "scatter data 1 for message output");
        this.bufForScatter = this.sliceForScatter.buf();
        if (this.bufForScatter.remaining() < val) {
            throw new IllegalStateException("Scatter-data buffer is too small: requested: " + val + " buffer: " + this.bufForScatter);
        }
        this.pos = 0;
    }

    private void appendBufferedToOutput() {
        int currpos = this.bufForScatter.position();
        if (this.bufForScatter.limit() != this.bufForScatter.capacity() || this.pos > currpos) {
            throw new IllegalStateException(String.format("Wrong buffer and position states: limit=%d, capacity=%d, pos=%d, currpos=%d", this.bufForScatter.limit(), this.bufForScatter.capacity(), this.pos, currpos));
        }
        if (this.pos == currpos) {
            return;
        }
        this.outputs.add(this.sliceForScatter.forkBackwards(currpos - this.pos, "append scatter data for message output"));
        this.pos = currpos;
    }

    private void ensureFramesNotPolled() {
        if (this.framesPolled.get()) {
            throw new IllegalStateException(FRAME_POLLED_MESSAGE);
        }
    }
}

