/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class NetworkAddress
extends SocketAddress
implements FastExternalizable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_PORT = 65535;
    private static final InetAddress ANY_LOCAL = new InetSocketAddress(0).getAddress();
    private final String hostname;
    private final int port;

    public NetworkAddress(String hostname, int port) {
        ObjectUtil.checkNull("hostname", hostname);
        this.hostname = hostname;
        this.port = port;
        NetworkAddress.checkPort(port);
    }

    public static NetworkAddress convert(InetSocketAddress address) {
        return address == null ? null : new NetworkAddress(address.getHostString(), address.getPort());
    }

    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port: " + port);
        }
    }

    public NetworkAddress(InetAddress address, int port) {
        ObjectUtil.checkNull("address", address);
        this.hostname = address.getHostName();
        this.port = port;
        NetworkAddress.checkPort(port);
    }

    public NetworkAddress(int port) {
        this(ANY_LOCAL, port);
        NetworkAddress.checkPort(port);
    }

    public NetworkAddress(DataInput in, short serialVersion) throws IOException {
        this.hostname = SerializationUtil.readNonNullString(in, serialVersion);
        this.port = in.readUnsignedShort();
        try {
            NetworkAddress.checkPort(this.port);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid field: " + e.getMessage(), e);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullString(out, serialVersion, this.hostname);
        out.writeShort(this.port);
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.hostname);
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkAddress)) {
            return false;
        }
        NetworkAddress addr = (NetworkAddress)obj;
        if (!addr.hostname.equals(this.hostname)) {
            return false;
        }
        return addr.port == this.port;
    }

    public int hashCode() {
        return this.hostname.hashCode() * 31 + this.port;
    }

    public String toString() {
        return this.hostname + ":" + this.port;
    }
}

