/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.NullDialogStart;
import oracle.kv.impl.async.dialog.DialogContextImpl;
import oracle.kv.impl.async.dialog.DialogEndpointHandler;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.ProtocolViolationException;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;
import oracle.kv.impl.async.exception.ConnectionException;
import oracle.kv.impl.async.exception.ConnectionIOException;
import oracle.kv.impl.async.exception.ConnectionIdleException;
import oracle.kv.impl.async.exception.ConnectionIncompatibleException;
import oracle.kv.impl.async.exception.ConnectionTimeoutException;
import oracle.kv.impl.async.exception.ConnectionUnknownException;
import oracle.kv.impl.async.exception.DialogLimitExceededException;
import oracle.kv.impl.async.exception.InitialConnectIOException;
import oracle.kv.impl.async.perf.EndpointHandlerPerf;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.util.CommonLoggerUtils;

public abstract class AbstractDialogEndpointHandler
implements DialogEndpointHandler {
    private static final SecureRandom random = new SecureRandom();
    private final Logger logger;
    private final EndpointHandlerManager parent;
    private final boolean isCreator;
    private final NetworkAddress remoteAddress;
    private final AtomicLong sequencer = new AtomicLong(0L);
    private final long uuid;
    private volatile long connid;
    private volatile int localMaxDlgs;
    private volatile int localMaxLen;
    private volatile int localMaxTotLen;
    private final int remoteMaxDlgs;
    private final int remoteMaxLen;
    private final int remoteMaxTotLen;
    private final int connectTimeout;
    private final int heartbeatTimeout;
    private final int idleTimeout;
    private volatile int heartbeatInterval;
    private final int flushBatchNumContexts;
    private final int flushNumBatches;
    private volatile State state = State.NEED_EXECUTOR;
    private final Map<Integer, DialogHandlerFactory> dialogHandlerFactories;
    private volatile long latestLocalStartedDialogId = 0L;
    private final ReentrantLock dialogLock = new ReentrantLock();
    private final Semaphore localDialogResource = new Semaphore(0);
    private long latestRemoteStartedDialogId = 0L;
    private final Semaphore remoteDialogResource = new Semaphore(0);
    private final Map<Long, DialogContextImpl> dialogContexts = new ConcurrentHashMap<Long, DialogContextImpl>();
    private final List<DialogContextImpl> preHandshakeContexts = new ArrayList<DialogContextImpl>();
    private final Set<DialogContextImpl> pendingDialogContexts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<DialogContextImpl> writingContexts = new LinkedHashSet<DialogContextImpl>();
    private final ReentrantLock writingLock = new ReentrantLock();
    private volatile boolean pendingShutdown = false;
    private volatile TerminationInfo terminationInfo = null;
    private final AtomicBoolean connectionAbortWritten = new AtomicBoolean(false);
    private final Map<Long, Runnable> pendingPings = new ConcurrentHashMap<Long, Runnable>();
    private final ContextNewWriteFlushTask contextNewWriteFlushTask = new ContextNewWriteFlushTask();
    private boolean lastFlushFinished = true;
    private volatile boolean needsFlush = false;
    private ReentrantLock flushLock = new ReentrantLock();
    private final ConnectTimeoutTask connectTimeoutTask = new ConnectTimeoutTask();
    private volatile boolean noReadLastInterval = true;
    private volatile boolean noDialogFlushLastInterval = true;
    private volatile boolean noDialogActive = true;
    private final List<Future<?>> scheduledTasks = Collections.synchronizedList(new ArrayList());
    private final EndpointHandlerPerf endpointPerf;
    public static volatile TestHook<AbstractDialogEndpointHandler> handshakeDoneTestHook;
    public static volatile TestHook<AbstractDialogEndpointHandler> flushTestHook;

    public AbstractDialogEndpointHandler(Logger logger, EndpointHandlerManager parent, EndpointConfig endpointConfig, boolean isCreator, NetworkAddress remoteAddress, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
        this.localMaxDlgs = endpointConfig.getOption(AsyncOption.DLG_LOCAL_MAXDLGS);
        this.localMaxLen = endpointConfig.getOption(AsyncOption.DLG_LOCAL_MAXLEN);
        this.localMaxTotLen = endpointConfig.getOption(AsyncOption.DLG_LOCAL_MAXTOTLEN);
        this.remoteMaxDlgs = endpointConfig.getOption(AsyncOption.DLG_REMOTE_MAXDLGS);
        this.remoteMaxLen = endpointConfig.getOption(AsyncOption.DLG_REMOTE_MAXLEN);
        this.remoteMaxTotLen = endpointConfig.getOption(AsyncOption.DLG_REMOTE_MAXTOTLEN);
        this.connectTimeout = endpointConfig.getOption(AsyncOption.DLG_CONNECT_TIMEOUT);
        this.heartbeatTimeout = endpointConfig.getOption(AsyncOption.DLG_HEARTBEAT_TIMEOUT);
        this.heartbeatInterval = endpointConfig.getOption(AsyncOption.DLG_HEARTBEAT_INTERVAL);
        this.idleTimeout = endpointConfig.getOption(AsyncOption.DLG_IDLE_TIMEOUT);
        this.flushBatchNumContexts = endpointConfig.getOption(AsyncOption.DLG_FLUSH_BATCHSZ);
        this.flushNumBatches = endpointConfig.getOption(AsyncOption.DLG_FLUSH_NBATCH);
        this.logger = logger;
        this.parent = parent;
        this.uuid = this.getNonZeroLongUUID();
        this.connid = isCreator ? this.uuid : 0L;
        this.isCreator = isCreator;
        this.remoteAddress = remoteAddress;
        this.dialogHandlerFactories = dialogHandlerFactories;
        this.remoteDialogResource.release(this.remoteMaxDlgs);
        this.endpointPerf = new EndpointHandlerPerf(this.getStringID(), logger);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public long getUUID() {
        return this.uuid;
    }

    @Override
    public long getConnID() {
        return this.connid;
    }

    @Override
    public String getStringID() {
        if (this.isCreator) {
            return String.format("%x", this.uuid);
        }
        return String.format("%x:%x", this.connid, this.uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContextDone(DialogContextImpl context) {
        boolean local;
        long dialogId = context.getDialogId();
        boolean bl = local = dialogId == 0L || this.isCreator && dialogId > 0L || !this.isCreator && dialogId < 0L;
        if (local) {
            this.localDialogResource.release();
        } else {
            this.remoteDialogResource.release();
        }
        if (dialogId != 0L) {
            this.dialogContexts.remove(dialogId);
        } else {
            this.dialogLock.lock();
            try {
                this.pendingDialogContexts.remove(context);
                dialogId = context.getDialogId();
                this.dialogContexts.remove(dialogId);
            }
            finally {
                this.dialogLock.unlock();
            }
        }
        if (context.isFin()) {
            this.endpointPerf.onDialogFinished(context.getPerf());
        } else {
            this.endpointPerf.onDialogAborted(context.getPerf());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Endpoint handler done with dialog: dialogId={0}, localActive={1}, remoteActive={2}", new Object[]{context.getStringID(), this.localMaxDlgs - this.localDialogResource.availablePermits(), this.remoteMaxDlgs - this.remoteDialogResource.availablePermits()});
        }
    }

    @Override
    public void onContextNewWrite(DialogContextImpl context) {
        assert (context.getDialogId() != 0L);
        this.writingLock.lock();
        try {
            this.writingContexts.add(context);
        }
        finally {
            this.writingLock.unlock();
        }
        this.contextNewWriteFlushTask.schedule();
    }

    @Override
    public int getMaxInputTotLen() {
        return this.remoteMaxTotLen;
    }

    @Override
    public int getMaxOutputTotLen() {
        return this.localMaxTotLen;
    }

    @Override
    public int getMaxInputProtocolMesgLen() {
        return this.remoteMaxLen;
    }

    @Override
    public int getMaxOutputProtocolMesgLen() {
        return this.localMaxLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeDialogStartForContext(boolean finish, boolean cont, int typeno, long timeoutMillis, IOBufSliceList frame, DialogContextImpl context) {
        long dialogId;
        if (context.getDialogId() != 0L) {
            throw new IllegalStateException(String.format("Writing dialog start when it already has a dialogId, context=%s, endpointHandlerId=%s", context, this.getStringID()));
        }
        this.dialogLock.lock();
        try {
            long l = dialogId = this.isCreator ? (this.latestLocalStartedDialogId = this.latestLocalStartedDialogId + 1L) : (this.latestLocalStartedDialogId = this.latestLocalStartedDialogId - 1L);
            if (this.pendingDialogContexts.remove(context)) {
                this.dialogContexts.put(dialogId, context);
            } else if (!context.isAborted()) {
                throw new IllegalStateException(String.format("Context not in the pending map while writing dialog start: %sendpointHandlerId=%s", context.toString(), this.getStringID()));
            }
            this.getProtocolWriter().writeDialogStart(context.getPerf().isSampled(), finish, cont, typeno, dialogId, timeoutMillis, frame);
        }
        finally {
            this.dialogLock.unlock();
        }
        return dialogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Time out value must large than zero");
        }
        if (timeoutMillis == 0L) {
            timeoutMillis = Integer.MAX_VALUE;
        }
        if (this.isShuttingDownOrAfter() || this.pendingShutdown) {
            this.dropDialog(dialogHandler, this.terminationInfo.exception().getDialogException(false));
            return;
        }
        DialogContextImpl context = new DialogContextImpl(this, dialogHandler, this.sequencer.incrementAndGet(), 0L, dialogType, timeoutMillis);
        if (!this.isNormalOrAfter()) {
            List<DialogContextImpl> list = this.preHandshakeContexts;
            synchronized (list) {
                if (!this.isNormalOrAfter()) {
                    if (this.preHandshakeContexts.size() > this.localMaxDlgs) {
                        this.dropDialog(context.getDialogHandler(), new DialogLimitExceededException(this.localMaxDlgs));
                    } else {
                        this.preHandshakeContexts.add(context);
                    }
                    return;
                }
            }
        }
        this.tryStartDialog(context);
        this.noDialogActive = false;
        if (this.isShuttingDownOrAfter() || this.pendingShutdown) {
            this.abortContextAfterShuttingDown(context);
        }
    }

    @Override
    public int getNumDialogsLimit() {
        if (this.isNormalOrAfter()) {
            return this.localMaxDlgs;
        }
        return -1;
    }

    @Override
    public void shutdown(String detail, boolean force) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Endpoint handler shutting down, detail=[{0}], {1}", new Object[]{detail, this.toString()});
        }
        if (force) {
            this.markTerminating(new ConnectionEndpointShutdownException(false, String.format("Shut down with force, detail=[%s]", detail)));
            this.terminate();
        } else {
            this.markShuttingDown(detail);
            this.terminateIfNotActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination(long timeoutMillis) throws InterruptedException {
        long curr;
        long waitTime;
        if (this.isTerminated()) {
            return;
        }
        if (timeoutMillis <= 0L) {
            return;
        }
        long ts = System.currentTimeMillis();
        long te = ts + timeoutMillis;
        while (!this.isTerminated() && (waitTime = te - (curr = System.currentTimeMillis())) > 0L) {
            AbstractDialogEndpointHandler abstractDialogEndpointHandler = this;
            synchronized (abstractDialogEndpointHandler) {
                if (!this.isTerminated()) {
                    this.wait(waitTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void awaitHandshakeDone() {
        try {
            while (true) {
                AbstractDialogEndpointHandler abstractDialogEndpointHandler = this;
                synchronized (abstractDialogEndpointHandler) {
                    if (this.isNormalOrAfter()) return;
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        int written = this.writeDialogFrameBatches();
        if (written != 0) {
            this.noDialogFlushLastInterval = false;
        }
        this.needsFlush = true;
        while (this.needsFlush && this.flushLock.tryLock()) {
            this.needsFlush = false;
            long ts = this.logger.isLoggable(Level.FINEST) ? System.currentTimeMillis() : 0L;
            this.logger.log(Level.FINEST, () -> String.format("Flushing for %s(%s) in %s", this.getClass().getSimpleName(), this.getStringID(), Thread.currentThread()));
            try {
                this.lastFlushFinished = this.flushInternal(this.hasContextsToWrite());
            }
            finally {
                this.logger.log(Level.FINEST, () -> String.format("Flush done for %s(%s) in %s, lasted %s ms.", this.getClass().getSimpleName(), this.getStringID(), Thread.currentThread(), System.currentTimeMillis() - ts));
                this.flushLock.unlock();
                if ($assertionsDisabled || TestHookExecute.doHookIfSet(flushTestHook, this)) continue;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void flushOrTerminate() {
        try {
            this.flush();
        }
        catch (Throwable t) {
            this.markTerminating(t);
        }
        this.terminateIfNotActive();
    }

    public void ping(long cookie, Runnable callback) {
        if (this.isTerminatingOrAfter()) {
            throw new IllegalStateException(this.terminationInfo.exception());
        }
        this.pendingPings.put(cookie, callback);
        this.getProtocolWriter().writePing(cookie);
        this.flushOrTerminate();
    }

    public boolean isCreator() {
        return this.isCreator;
    }

    public boolean isNormal() {
        return this.state == State.NORMAL;
    }

    public boolean isNormalOrAfter() {
        return State.NORMAL.compareTo(this.state) <= 0;
    }

    public boolean isShuttingDown() {
        return this.state == State.SHUTTINGDOWN;
    }

    public boolean isShuttingDownOrAfter() {
        return State.SHUTTINGDOWN.compareTo(this.state) <= 0;
    }

    public boolean isTerminatingOrAfter() {
        return State.TERMINATING.compareTo(this.state) <= 0;
    }

    public boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    public void onChannelReady() {
        this.logger.log(Level.FINE, "Endpoint handler channel ready: {0}", this);
        this.assertInExecutorThread();
        if (!this.transitStateOrShuttingDownOrDie(State.CONNECTING, State.HANDSHAKING_STEP1)) {
            return;
        }
        if (this.isCreator) {
            this.getProtocolWriter().writeProtocolVersion(1);
        }
        this.flushOrTerminate();
    }

    public ConnectionException getTerminationCause() {
        if (this.terminationInfo == null) {
            return null;
        }
        return this.terminationInfo.exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(").append(this.getStringID()).append(")");
        sb.append("{");
        sb.append(" isCreator=").append(this.isCreator);
        sb.append(" remoteAddress=").append(this.remoteAddress);
        sb.append(" state=").append((Object)this.state);
        sb.append(" pendingShutdown=").append(this.pendingShutdown);
        sb.append(" #dialogFactories=").append(this.dialogHandlerFactories.size());
        AbstractDialogEndpointHandler abstractDialogEndpointHandler = this;
        synchronized (abstractDialogEndpointHandler) {
            sb.append(" latestLocalStartedDialogId=").append(Long.toString(this.latestLocalStartedDialogId, 16));
            sb.append(" latestRemoteStartedDialogId=").append(Long.toString(this.latestRemoteStartedDialogId, 16));
        }
        sb.append(" approx#dialogContexts=").append(this.dialogContexts.size());
        sb.append(" approx#pendingDialogContexts=").append(this.pendingDialogContexts.size());
        this.writingLock.lock();
        try {
            sb.append(" #writingContexts=").append(this.writingContexts.size());
        }
        finally {
            this.writingLock.unlock();
        }
        sb.append(" terminationInfo=").append(this.terminationInfo);
        sb.append("}");
        return sb.toString();
    }

    protected abstract boolean flushInternal(boolean var1) throws IOException;

    protected abstract void cleanup() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExecutorReady() {
        Object object = this;
        synchronized (object) {
            if (this.state != State.NEED_EXECUTOR) {
                throw new IllegalStateException("onExecutorReady must be called first");
            }
            this.state = State.CONNECTING;
        }
        object = this.preHandshakeContexts;
        synchronized (object) {
            for (DialogContextImpl context : this.preHandshakeContexts) {
                context.startTimeout();
            }
        }
        this.connectTimeoutTask.schedule();
    }

    protected int writeDialogFrameBatches() {
        int n;
        int written = 0;
        for (int i = 0; i < this.flushNumBatches && (n = this.writeOneDialogFrameBatch()) > 0; ++i) {
            written += n;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            long maxBytesWritten = written * this.getMaxOutputProtocolMesgLen();
            this.logger.finest(String.format("Obtained %d pending frames (max %d bytes) to flush, %s(%s)", written, maxBytesWritten, this.getClass().getSimpleName(), this.getStringID()));
        }
        return written;
    }

    protected void onChannelInputRead() {
        this.assertInExecutorThread();
        this.noReadLastInterval = false;
        ProtocolMesg mesg = null;
        try {
            while (true) {
                if ((mesg = this.getProtocolReader().read()) == null) {
                    return;
                }
                this.onMessageReady(mesg);
            }
        }
        catch (Throwable t) {
            if (mesg != null) {
                mesg.discard();
            }
            this.markTerminating(t);
            this.terminate();
            return;
        }
    }

    protected void writeConnectionAbort() {
        if (!this.isShuttingDownOrAfter()) {
            throw new AssertionError();
        }
        if (this.isCreator) {
            return;
        }
        if (this.terminationInfo.fromRemote()) {
            return;
        }
        if (this.connectionAbortWritten.compareAndSet(false, true)) {
            ConnectionException e = this.terminationInfo.exception();
            this.getProtocolWriter().writeConnectionAbort(this.exceptionToCause(e), e.toString());
        }
    }

    protected synchronized void markShuttingDown(String detail) {
        if (this.isShuttingDownOrAfter()) {
            return;
        }
        this.setTerminationInfo(new ShutdownInfo(detail));
        if (!this.isNormalOrAfter()) {
            this.pendingShutdown = true;
            return;
        }
        this.state = State.SHUTTINGDOWN;
        this.pendingShutdown = false;
    }

    protected synchronized void markTerminating(Throwable t) {
        if (this.isTerminatingOrAfter()) {
            return;
        }
        ConnectionException wrapped = t instanceof IOException ? (this.state.compareTo(State.CONNECTING) <= 0 ? new InitialConnectIOException((IOException)t, this.remoteAddress) : new ConnectionIOException((IOException)t, this.remoteAddress)) : (t instanceof ConnectionException ? (ConnectionException)t : new ConnectionUnknownException(t));
        this.setTerminationInfo(new AbortInfo(wrapped));
        this.state = State.TERMINATING;
    }

    protected synchronized void markTerminating(ProtocolMesg.ConnectionAbort.Cause cause, String detail) {
        if (this.isTerminatingOrAfter()) {
            return;
        }
        this.setTerminationInfo(new AbortInfo(cause, detail));
        this.state = State.TERMINATING;
    }

    protected synchronized void markTerminated() {
        if (this.isTerminated()) {
            return;
        }
        this.state = State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void terminate() {
        block13: {
            if (this.isTerminated()) {
                return;
            }
            if (!this.isShuttingDownOrAfter()) {
                throw new IllegalStateException("The method terminate() is called before transiting to a required state (SHUTTINGDOWN or after). This is a coding error.");
            }
            this.logger.log(Level.FINE, "Endpoint handler terminating: {0}", this);
            this.abortDialogs();
            this.cancelScheduledTasks();
            this.writeConnectionAbort();
            try {
                this.flush();
            }
            catch (Throwable t) {
                try {
                    this.cleanup();
                }
                catch (Throwable t2) {
                    this.logger.log(Level.FINE, "Error cleaning up for endpoint handler: {0}", new Object[]{CommonLoggerUtils.getStackTrace(t2)});
                }
                break block13;
            }
            catch (Throwable throwable) {
                try {
                    this.cleanup();
                    throw throwable;
                }
                catch (Throwable t) {
                    this.logger.log(Level.FINE, "Error cleaning up for endpoint handler: {0}", new Object[]{CommonLoggerUtils.getStackTrace(t)});
                }
                throw throwable;
            }
            try {
                this.cleanup();
            }
            catch (Throwable t) {
                this.logger.log(Level.FINE, "Error cleaning up for endpoint handler: {0}", new Object[]{CommonLoggerUtils.getStackTrace(t)});
            }
        }
        this.endpointPerf.close();
        this.parent.onHandlerShutdown(this);
        this.markTerminated();
        AbstractDialogEndpointHandler abstractDialogEndpointHandler = this;
        synchronized (abstractDialogEndpointHandler) {
            this.notifyAll();
        }
        this.logger.log(Level.FINE, "Endpoint handler terminated: {0}", this);
    }

    private synchronized void setTerminationInfo(TerminationInfo info) {
        if (this.terminationInfo instanceof AbortInfo) {
            return;
        }
        if (this.terminationInfo instanceof ShutdownInfo && info instanceof ShutdownInfo) {
            return;
        }
        this.terminationInfo = info;
    }

    private void terminateIfNotActive() {
        if (this.lastFlushFinished() && this.isShuttingDown() && !this.hasActiveDialogs()) {
            this.markTerminating(new ConnectionEndpointShutdownException(false, "Shut down gracefully"));
            this.terminate();
        } else if (this.isTerminatingOrAfter()) {
            this.terminate();
        }
    }

    private boolean lastFlushFinished() {
        if (this.flushLock.tryLock()) {
            try {
                boolean bl = this.lastFlushFinished;
                return bl;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        return false;
    }

    private long getNonZeroLongUUID() {
        long result;
        while ((result = random.nextLong()) == 0L) {
        }
        return result;
    }

    private void dropDialog(DialogHandler handler, Throwable cause) {
        NullDialogStart.fail(handler, cause, this.getSchedExecService());
        this.endpointPerf.onDialogDropped();
    }

    private void tryStartDialog(DialogContextImpl context) {
        if (!this.localDialogResource.tryAcquire()) {
            this.dropDialog(context.getDialogHandler(), new DialogLimitExceededException(this.localMaxDlgs));
            return;
        }
        this.pendingDialogContexts.add(context);
        if (this.endpointPerf.onDialogStarted()) {
            context.getPerf().startSampling();
        }
        context.startTimeout();
        context.callOnStart();
    }

    private void abortContextAfterShuttingDown(DialogContextImpl context) {
        if (!this.isShuttingDownOrAfter()) {
            throw new AssertionError();
        }
        context.onLocalAbortConnectionException(this.terminationInfo.exception());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasActiveDialogs() {
        block11: {
            if (!this.dialogContexts.isEmpty()) {
                return true;
            }
            if (!this.pendingDialogContexts.isEmpty()) {
                return true;
            }
            if (this.dialogLock.tryLock()) {
                try {
                    if (!this.dialogContexts.isEmpty() || !this.pendingDialogContexts.isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    break block11;
                }
                finally {
                    this.dialogLock.unlock();
                }
            }
            return true;
        }
        List<DialogContextImpl> list = this.preHandshakeContexts;
        synchronized (list) {
            if (!this.preHandshakeContexts.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeOneDialogFrameBatch() {
        int written = 0;
        if (this.writingLock.tryLock()) {
            try {
                Iterator<DialogContextImpl> iter = this.writingContexts.iterator();
                while (iter.hasNext()) {
                    DialogContextImpl context = iter.next();
                    if (context.isDone()) {
                        iter.remove();
                    }
                    if (context.onWriteDialogFrame()) {
                        iter.remove();
                    }
                    if (++written < this.flushBatchNumContexts) continue;
                }
            }
            finally {
                this.writingLock.unlock();
            }
        } else {
            return -1;
        }
        return written;
    }

    private boolean hasContextsToWrite() {
        if (this.writingLock.tryLock()) {
            try {
                boolean bl = !this.writingContexts.isEmpty();
                return bl;
            }
            finally {
                this.writingLock.unlock();
            }
        }
        return true;
    }

    private void onMessageReady(ProtocolMesg mesg) throws IOException {
        switch (mesg.type()) {
            case 1: {
                this.onReadProtocolVersion((ProtocolMesg.ProtocolVersion)mesg);
                break;
            }
            case 2: {
                this.onReadProtocolVersionResponse((ProtocolMesg.ProtocolVersionResponse)mesg);
                break;
            }
            case 3: {
                this.onReadConnectionConfig((ProtocolMesg.ConnectionConfig)mesg);
                break;
            }
            case 4: {
                this.onReadConnectionConfigResponse((ProtocolMesg.ConnectionConfigResponse)mesg);
                break;
            }
            case 8: {
                this.onReadNoOperation();
                break;
            }
            case 9: {
                this.onReadConnectionAbort((ProtocolMesg.ConnectionAbort)mesg);
                break;
            }
            case 10: {
                this.onReadPing((ProtocolMesg.Ping)mesg);
                break;
            }
            case 11: {
                this.onReadPingAck((ProtocolMesg.PingAck)mesg);
                break;
            }
            case 16: {
                this.onReadDialogStart((ProtocolMesg.DialogStart)mesg);
                break;
            }
            case 32: {
                this.onReadDialogFrame((ProtocolMesg.DialogFrame)mesg);
                break;
            }
            case 48: {
                this.onReadDialogAbort((ProtocolMesg.DialogAbort)mesg);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected message type: %s", mesg.type()));
            }
        }
    }

    private void onReadProtocolVersion(ProtocolMesg.ProtocolVersion mesg) throws IOException {
        this.ensureStateOrShuttingDownOrDie(State.HANDSHAKING_STEP1);
        if (this.isCreator) {
            throw new ProtocolViolationException(false, "Invalid endpoint handler state:Received ProtocolVersion on creator endpoint");
        }
        if (mesg.version != 1) {
            throw new ConnectionIncompatibleException(false, String.format("Incompatible version error: supported=%d, got=%d", 1, mesg.version));
        }
        if (this.transitStateOrShuttingDownOrDie(State.HANDSHAKING_STEP1, State.HANDSHAKING_STEP2)) {
            this.getProtocolWriter().writeProtocolVersionResponse(1);
            this.flush();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Endpoint handler got protocol version v={0}: {1}", new Object[]{mesg.version, this});
        }
    }

    private void onReadProtocolVersionResponse(ProtocolMesg.ProtocolVersionResponse mesg) throws IOException {
        this.ensureStateOrShuttingDownOrDie(State.HANDSHAKING_STEP1);
        if (!this.isCreator) {
            throw new ProtocolViolationException(false, "Invalid endpoint handler state:Received ProtocolVersion on responder endpoint");
        }
        if (mesg.version != 1) {
            throw new ConnectionIncompatibleException(false, String.format("Incompatible version error: supported=%d, got=%d", 1, mesg.version));
        }
        if (this.transitStateOrShuttingDownOrDie(State.HANDSHAKING_STEP1, State.HANDSHAKING_STEP2)) {
            this.getProtocolWriter().writeConnectionConfig(this.connid, this.remoteMaxDlgs, this.remoteMaxLen, this.remoteMaxTotLen, this.heartbeatInterval);
            this.flush();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Endpoint handler got protocol version response v={0}: {1}", new Object[]{mesg.version, this});
        }
    }

    private void onReadConnectionConfig(ProtocolMesg.ConnectionConfig mesg) throws IOException {
        this.ensureStateOrShuttingDownOrDie(State.HANDSHAKING_STEP2);
        if (this.isCreator) {
            throw new ProtocolViolationException(false, "Invalid endpoint handler state:Received ConnectionConfig on creator endpoint");
        }
        this.connid = mesg.uuid;
        this.setConfiguration(mesg.maxDialogs, mesg.maxLength, mesg.maxTotLen, mesg.heartbeatInterval);
        this.getProtocolWriter().writeConnectionConfigResponse(this.remoteMaxDlgs, this.remoteMaxLen, this.remoteMaxTotLen, this.heartbeatInterval);
        this.flush();
        this.logger.log(Level.FINE, "Endpoint handler handshake done: {0}", this);
        this.onHandshakeDone();
    }

    private void onReadConnectionConfigResponse(ProtocolMesg.ConnectionConfigResponse mesg) {
        this.ensureStateOrShuttingDownOrDie(State.HANDSHAKING_STEP2);
        if (!this.isCreator) {
            throw new ProtocolViolationException(false, "Invalid endpoint handler state:Received ConnectionConfig on responder endpoint");
        }
        this.setConfiguration(mesg.maxDialogs, mesg.maxLength, mesg.maxTotLen, mesg.heartbeatInterval);
        this.logger.log(Level.FINE, "Endpoint handler handshake done: {0}", this);
        this.onHandshakeDone();
    }

    private void onReadNoOperation() {
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
    }

    private void onReadConnectionAbort(ProtocolMesg.ConnectionAbort mesg) {
        this.markTerminating(mesg.cause, mesg.detail);
        this.terminate();
    }

    private void onReadPing(ProtocolMesg.Ping mesg) throws IOException {
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
        this.getProtocolWriter().writePingAck(mesg.cookie);
        this.flush();
    }

    private void onReadPingAck(ProtocolMesg.PingAck mesg) {
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
        Runnable callback = this.pendingPings.get(mesg.cookie);
        if (callback == null) {
            throw new ProtocolViolationException(false, "Invalid endpoint handler state:" + String.format("Wrong cookie for PingAck: cookie=%d", mesg.cookie));
        }
        try {
            callback.run();
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Ping ack callback got exception: {0}", CommonLoggerUtils.getStackTrace(t));
        }
    }

    private void onReadDialogStart(ProtocolMesg.DialogStart mesg) throws IOException {
        int dialogType;
        DialogHandlerFactory factory;
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
        long dialogId = mesg.dialogId;
        this.ensureDialogStartIdValidOrDie(dialogId);
        this.latestRemoteStartedDialogId = dialogId;
        if (this.isShuttingDownOrAfter()) {
            String detail = String.format("cause=[%s]", this.terminationInfo.exception().getMessage());
            this.getProtocolWriter().writeDialogAbort(ProtocolMesg.DialogAbort.Cause.ENDPOINT_SHUTTINGDOWN, dialogId, String.format("Dialog rejected because endpoint is shutting down, %s", detail));
            this.flush();
        }
        if ((factory = this.dialogHandlerFactories.get(dialogType = mesg.typeno)) == null) {
            mesg.discard();
            StringBuilder sb = new StringBuilder("known type numbers:");
            for (int knownType : this.dialogHandlerFactories.keySet()) {
                sb.append(knownType);
                sb.append(",");
            }
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Endpoint handler encounters that remote wants to start unknown dialog type: {0}; {1}", new Object[]{mesg, sb});
            }
            this.getProtocolWriter().writeDialogAbort(ProtocolMesg.DialogAbort.Cause.UNKNOWN_TYPE, dialogId, sb.toString());
            this.flush();
            return;
        }
        DialogHandler handler = factory.create();
        if (!this.remoteDialogResource.tryAcquire()) {
            String detail = "Max number of dialogs exceeded:" + String.format("limit=%d #active=%d", this.remoteMaxDlgs, this.remoteMaxDlgs - this.remoteDialogResource.availablePermits());
            throw new ProtocolViolationException(false, detail);
        }
        this.noDialogActive = false;
        DialogContextImpl context = new DialogContextImpl(this, handler, this.sequencer.incrementAndGet(), dialogId, dialogType, mesg.timeoutMillis);
        this.dialogContexts.put(dialogId, context);
        if (this.isShuttingDownOrAfter()) {
            mesg.discard();
            this.abortContextAfterShuttingDown(context);
            return;
        }
        this.endpointPerf.onDialogStarted();
        if (mesg.sampled) {
            context.getPerf().startSampling();
        }
        context.callOnStart();
        context.startTimeout();
        context.onReadDialogFrame(mesg.finish, mesg.cont, mesg.frame);
    }

    private void onReadDialogFrame(ProtocolMesg.DialogFrame mesg) {
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
        long dialogId = mesg.dialogId;
        this.ensureDialogFrameAbortIdValidOrDie(dialogId);
        DialogContextImpl context = this.dialogContexts.get(dialogId);
        if (context == null) {
            mesg.discard();
            return;
        }
        context.onReadDialogFrame(mesg.finish, mesg.cont, mesg.frame);
    }

    private void onReadDialogAbort(ProtocolMesg.DialogAbort mesg) {
        this.ensureStateOrShuttingDownOrDie(State.NORMAL);
        long dialogId = mesg.dialogId;
        this.ensureDialogFrameAbortIdValidOrDie(dialogId);
        DialogContextImpl context = this.dialogContexts.get(dialogId);
        if (context == null) {
            mesg.discard();
            return;
        }
        context.onReadDialogAbort(mesg.cause, mesg.detail);
    }

    private synchronized void ensureStateOrShuttingDownOrDie(State target) {
        if (this.state == target) {
            return;
        }
        if (this.isShuttingDownOrAfter()) {
            return;
        }
        throw new ProtocolViolationException(false, "Invalid endpoint handler state:" + String.format("expected=%s, got=%s", new Object[]{target, this.state}));
    }

    private synchronized boolean transitStateOrShuttingDownOrDie(State from, State to) {
        if (this.state == from) {
            this.state = to;
            return true;
        }
        if (this.isShuttingDownOrAfter()) {
            return false;
        }
        throw new IllegalStateException(String.format("Trying to transit from %s, got %s", new Object[]{from, this.state}));
    }

    private void setConfiguration(long maxDialogs, long maxLength, long maxTotLen, long interval) {
        this.localMaxDlgs = Math.min(this.localMaxDlgs, (int)maxDialogs);
        this.localMaxLen = Math.min(this.localMaxLen, (int)maxLength);
        this.localMaxTotLen = Math.min(this.localMaxTotLen, (int)maxTotLen);
        this.heartbeatInterval = Math.max(this.heartbeatInterval, (int)interval);
        this.logger.log(Level.FINEST, () -> String.format("Setting config, localMaxDlgs=%d, localMaxLen=%d, localMaxTotLen=%d, heartbeatInterval=%d", this.localMaxDlgs, this.localMaxLen, this.localMaxTotLen, this.heartbeatInterval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHandshakeDone() {
        Object object;
        this.getProtocolWriter().setMaxLength(this.localMaxLen);
        this.localDialogResource.release(this.localMaxDlgs);
        if (this.transitStateOrShuttingDownOrDie(State.HANDSHAKING_STEP2, State.NORMAL)) {
            object = this.preHandshakeContexts;
            synchronized (object) {
                for (DialogContextImpl context : this.preHandshakeContexts) {
                    this.tryStartDialog(context);
                }
                this.preHandshakeContexts.clear();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        assert (TestHookExecute.doHookIfSet(handshakeDoneTestHook, this));
        if (this.pendingShutdown) {
            this.markShuttingDown(this.terminationInfo.exception().getMessage());
        }
        this.connectTimeoutTask.cancel();
        new HeartbeatTimeoutTask().schedule();
        new HeartbeatTask().schedule();
        new IdleTimeoutTask().schedule();
        this.endpointPerf.schedule(this.getSchedExecService());
    }

    private void ensureDialogStartIdValidOrDie(long dialogId) {
        boolean valid;
        boolean bl = this.isCreator ? dialogId < this.latestRemoteStartedDialogId : (valid = dialogId > this.latestRemoteStartedDialogId);
        if (!valid) {
            throw new ProtocolViolationException(false, "Invalid dialog state:" + String.format("Received DialogStart, isCreator=%s latestId=%s got=%s", this.isCreator, Long.toString(this.latestRemoteStartedDialogId, 16), Long.toString(dialogId, 16)));
        }
    }

    private void ensureDialogFrameAbortIdValidOrDie(long dialogId) {
        long latest;
        boolean validId = this.isCreator && dialogId > 0L && dialogId <= this.latestLocalStartedDialogId || this.isCreator && dialogId < 0L && dialogId >= this.latestRemoteStartedDialogId || !this.isCreator && dialogId > 0L && dialogId <= this.latestRemoteStartedDialogId || !this.isCreator && dialogId < 0L && dialogId >= this.latestLocalStartedDialogId;
        boolean local = this.isCreator && dialogId > 0L || !this.isCreator && dialogId < 0L;
        long l = latest = local ? this.latestLocalStartedDialogId : this.latestRemoteStartedDialogId;
        if (!validId) {
            throw new ProtocolViolationException(false, "Invalid dialog state:" + String.format("Received DialogFrame/DialogAbort, isCreator=%s dialogLocal=%s latestId=%s got=%s", this.isCreator, local, Long.toString(latest, 16), Long.toString(dialogId, 16)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortDialogs() {
        if (!this.isTerminatingOrAfter()) {
            throw new IllegalStateException("Abort dialogs should only happen after handler is terminating");
        }
        this.dialogLock.lock();
        try {
            DialogContextImpl context;
            Iterator<Object> iter;
            while (!this.pendingDialogContexts.isEmpty()) {
                iter = this.pendingDialogContexts.iterator();
                while (iter.hasNext()) {
                    context = iter.next();
                    this.abortContextAfterShuttingDown(context);
                    iter.remove();
                }
            }
            while (!this.dialogContexts.isEmpty()) {
                iter = this.dialogContexts.entrySet().iterator();
                while (iter.hasNext()) {
                    context = (DialogContextImpl)((Map.Entry)iter.next()).getValue();
                    this.abortContextAfterShuttingDown(context);
                    iter.remove();
                }
            }
        }
        finally {
            this.dialogLock.unlock();
        }
        List<DialogContextImpl> list = this.preHandshakeContexts;
        synchronized (list) {
            for (DialogContextImpl context : this.preHandshakeContexts) {
                NullDialogStart.fail(context.getDialogHandler(), this.terminationInfo.exception().getDialogException(false), this.getSchedExecService());
            }
            this.preHandshakeContexts.clear();
        }
        this.writingLock.lock();
        try {
            this.writingContexts.clear();
        }
        finally {
            this.writingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelScheduledTasks() {
        List<Future<?>> list = this.scheduledTasks;
        synchronized (list) {
            for (Future<?> future : this.scheduledTasks) {
                future.cancel(false);
            }
        }
        this.connectTimeoutTask.cancel();
    }

    private ConnectionException causeToException(ProtocolMesg.ConnectionAbort.Cause cause, String detail) {
        switch (cause) {
            case UNKNOWN_REASON: {
                return new ConnectionUnknownException(detail);
            }
            case ENDPOINT_SHUTDOWN: {
                return new ConnectionEndpointShutdownException(true, detail);
            }
            case HEARTBEAT_TIMEOUT: {
                return new ConnectionTimeoutException(true, false, detail);
            }
            case IDLE_TIMEOUT: {
                return new ConnectionIdleException(true, detail);
            }
            case INCOMPATIBLE_ERROR: {
                return new ConnectionIncompatibleException(true, detail);
            }
            case PROTOCOL_VIOLATION: {
                return new ProtocolViolationException(true, detail);
            }
        }
        throw new IllegalArgumentException();
    }

    private ProtocolMesg.ConnectionAbort.Cause exceptionToCause(ConnectionException e) {
        if (e instanceof ConnectionUnknownException) {
            return ProtocolMesg.ConnectionAbort.Cause.UNKNOWN_REASON;
        }
        if (e instanceof ConnectionEndpointShutdownException) {
            return ProtocolMesg.ConnectionAbort.Cause.ENDPOINT_SHUTDOWN;
        }
        if (e instanceof ConnectionTimeoutException) {
            return ProtocolMesg.ConnectionAbort.Cause.HEARTBEAT_TIMEOUT;
        }
        if (e instanceof ConnectionIdleException) {
            return ProtocolMesg.ConnectionAbort.Cause.IDLE_TIMEOUT;
        }
        if (e instanceof ConnectionIncompatibleException) {
            return ProtocolMesg.ConnectionAbort.Cause.INCOMPATIBLE_ERROR;
        }
        if (e instanceof ProtocolViolationException) {
            return ProtocolMesg.ConnectionAbort.Cause.PROTOCOL_VIOLATION;
        }
        if (e instanceof ConnectionIOException) {
            return ProtocolMesg.ConnectionAbort.Cause.UNKNOWN_REASON;
        }
        throw new IllegalArgumentException();
    }

    private class IdleTimeoutTask
    extends ChannelPeriodicTask {
        private IdleTimeoutTask() {
        }

        @Override
        public void run() {
            if (AbstractDialogEndpointHandler.this.noDialogActive) {
                AbstractDialogEndpointHandler.this.markTerminating(new ConnectionIdleException(false, String.format("Idle timeout, connection is idle during last %s ms, endpointHandlerId=%s", AbstractDialogEndpointHandler.this.idleTimeout, AbstractDialogEndpointHandler.this.getStringID())));
                AbstractDialogEndpointHandler.this.terminate();
            }
            AbstractDialogEndpointHandler.this.noDialogActive = true;
            if (AbstractDialogEndpointHandler.this.hasActiveDialogs()) {
                AbstractDialogEndpointHandler.this.noDialogActive = false;
            }
        }

        void schedule() {
            this.schedule(AbstractDialogEndpointHandler.this.idleTimeout, AbstractDialogEndpointHandler.this.idleTimeout);
        }
    }

    private class HeartbeatTask
    extends ChannelPeriodicTask {
        private HeartbeatTask() {
        }

        @Override
        public void run() {
            if (AbstractDialogEndpointHandler.this.noDialogFlushLastInterval) {
                AbstractDialogEndpointHandler.this.getProtocolWriter().writeNoOperation();
                AbstractDialogEndpointHandler.this.flushOrTerminate();
            }
            AbstractDialogEndpointHandler.this.noDialogFlushLastInterval = true;
        }

        void schedule() {
            this.schedule(0L, AbstractDialogEndpointHandler.this.heartbeatInterval);
        }
    }

    private class HeartbeatTimeoutTask
    extends ChannelPeriodicTask {
        private HeartbeatTimeoutTask() {
        }

        @Override
        public void run() {
            if (AbstractDialogEndpointHandler.this.noReadLastInterval) {
                AbstractDialogEndpointHandler.this.markTerminating(new ConnectionTimeoutException(false, false, String.format("Heartbeat timeout, no read event during last %d ms, endpointHandlerId=%s", AbstractDialogEndpointHandler.this.heartbeatTimeout * AbstractDialogEndpointHandler.this.heartbeatInterval, AbstractDialogEndpointHandler.this.getStringID())));
                AbstractDialogEndpointHandler.this.terminate();
            }
            AbstractDialogEndpointHandler.this.noReadLastInterval = true;
        }

        void schedule() {
            this.schedule(0L, AbstractDialogEndpointHandler.this.heartbeatTimeout * AbstractDialogEndpointHandler.this.heartbeatInterval);
        }
    }

    private abstract class ChannelPeriodicTask
    extends ChannelTask {
        private ChannelPeriodicTask() {
        }

        protected void schedule(long initialDelay, long period) {
            try {
                ScheduledFuture<?> future = AbstractDialogEndpointHandler.this.getSchedExecService().scheduleAtFixedRate(this, initialDelay, period, TimeUnit.MILLISECONDS);
                AbstractDialogEndpointHandler.this.scheduledTasks.add(future);
                if (AbstractDialogEndpointHandler.this.isShuttingDownOrAfter()) {
                    future.cancel(false);
                }
            }
            catch (Throwable t) {
                AbstractDialogEndpointHandler.this.markTerminating(t);
                AbstractDialogEndpointHandler.this.terminate();
            }
        }
    }

    private class ConnectTimeoutTask
    extends ChannelTask {
        private Future<?> future;

        private ConnectTimeoutTask() {
            this.future = null;
        }

        @Override
        public void run() {
            AbstractDialogEndpointHandler.this.markTerminating(new ConnectionTimeoutException(false, true, String.format("Connect timeout, handshake is not done within %d ms since the endpoint handler is created, endpointHandlerId=%s", AbstractDialogEndpointHandler.this.connectTimeout, AbstractDialogEndpointHandler.this.getStringID())));
            AbstractDialogEndpointHandler.this.terminate();
        }

        synchronized void schedule() {
            if (this.future != null) {
                throw new AssertionError();
            }
            try {
                this.future = AbstractDialogEndpointHandler.this.getSchedExecService().schedule(this, (long)AbstractDialogEndpointHandler.this.connectTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                AbstractDialogEndpointHandler.this.markTerminating(t);
                AbstractDialogEndpointHandler.this.terminate();
            }
        }

        synchronized void cancel() {
            if (this.future == null) {
                return;
            }
            this.future.cancel(false);
        }
    }

    private abstract class ChannelTask
    implements Runnable {
        private ChannelTask() {
        }

        public String toString() {
            return String.format("%s@EndpointHandler:%s", this.getClass().getSimpleName(), AbstractDialogEndpointHandler.this.getStringID());
        }
    }

    private class AbortInfo
    extends TerminationInfo {
        AbortInfo(ProtocolMesg.ConnectionAbort.Cause protocolCause, String detail) {
            super(AbstractDialogEndpointHandler.this.causeToException(protocolCause, detail));
        }

        AbortInfo(ConnectionException exception) {
            super(exception);
        }
    }

    private class ShutdownInfo
    extends TerminationInfo {
        ShutdownInfo(String detail) {
            super(new ConnectionEndpointShutdownException(false, detail));
        }
    }

    private class TerminationInfo {
        private final State preState;
        private final ConnectionException exception;
        private final String stackTrace;

        TerminationInfo(ConnectionException exception) {
            this.preState = AbstractDialogEndpointHandler.this.state;
            this.exception = exception;
            this.stackTrace = CommonLoggerUtils.getStackTrace(exception);
        }

        boolean fromRemote() {
            return this.exception.fromRemote();
        }

        ConnectionException exception() {
            return this.exception;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            sb.append("preState=").append((Object)this.preState);
            sb.append(" exception=").append(this.exception);
            sb.append(" fromRemote=").append(this.fromRemote());
            sb.append(" stackTrace=").append(this.stackTrace);
            sb.append(")");
            return sb.toString();
        }
    }

    private class ContextNewWriteFlushTask
    implements Runnable {
        private final AtomicBoolean alreadyScheduled = new AtomicBoolean(false);

        private ContextNewWriteFlushTask() {
        }

        @Override
        public void run() {
            this.alreadyScheduled.set(false);
            AbstractDialogEndpointHandler.this.flushOrTerminate();
        }

        public void schedule() {
            if (this.alreadyScheduled.compareAndSet(false, true)) {
                AbstractDialogEndpointHandler.this.getSchedExecService().execute(this);
            }
        }
    }

    private static enum State {
        NEED_EXECUTOR,
        CONNECTING,
        HANDSHAKING_STEP1,
        HANDSHAKING_STEP2,
        NORMAL,
        SHUTTINGDOWN,
        TERMINATING,
        TERMINATED;

    }
}

