/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import com.sleepycat.util.PackedInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import oracle.kv.impl.async.IOBufSliceImpl;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.IOBufferPool;

public class ChannelOutput {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final IOBufferPool pool;
    private final IOBufSliceList slices = new IOBufSliceList();
    private boolean lastChunkDone = false;
    private boolean closed = false;

    public ChannelOutput(IOBufferPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(IOBufSliceList toExtend) {
        IOBufSliceList iOBufSliceList = this.slices;
        synchronized (iOBufSliceList) {
            if (this.closed) {
                return;
            }
            toExtend.extend(this.slices);
        }
    }

    public Chunk beginChunk(int maxScatterSize, boolean last) {
        return new Chunk(maxScatterSize, last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IOBufSliceList iOBufSliceList = this.slices;
        synchronized (iOBufSliceList) {
            this.closed = true;
            this.slices.freeEntries();
        }
    }

    public class Chunk {
        private final IOBufSliceImpl sliceForScatter;
        private final ByteBuffer bufForScatter;
        private final byte[] bytesForScatter;
        private int addBufPos = 0;
        private final IOBufSliceList outputs;
        private final boolean last;

        public Chunk(int maxScatterSize, boolean last) {
            this.sliceForScatter = IOBufSliceImpl.OutputPoolBufSlice.createFromPool(ChannelOutput.this.pool, "scatter data for channel output chunk");
            this.bufForScatter = this.sliceForScatter.buf();
            this.bytesForScatter = this.bufForScatter.array();
            this.outputs = new IOBufSliceList();
            this.last = last;
            if (this.bytesForScatter.length < maxScatterSize) {
                throw new IllegalStateException(String.format("Chunk scatter data size %d is larger than pool buffer size %d", maxScatterSize, this.bytesForScatter.length));
            }
        }

        public void writeByte(byte v) {
            this.bufForScatter.put(v);
        }

        public void writePackedLong(long v) {
            int pos = this.bufForScatter.position();
            int newPos = PackedInteger.writeLong(this.bytesForScatter, pos, v);
            this.bufForScatter.position(newPos);
        }

        public void writeUTF8(String s, int maxLength) {
            CharBuffer chbuf = CharBuffer.wrap(s);
            ByteBuffer buf = utf8.encode(chbuf);
            int length = buf.limit();
            if (length > maxLength) {
                buf.limit(maxLength);
                length = buf.limit();
            }
            this.writePackedLong(length);
            this.addBuf();
            this.outputs.add(new IOBufSliceImpl.HeapBufSlice(buf));
        }

        public void writeBytes(IOBufSliceList bytes) {
            this.addBuf();
            this.outputs.extend(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.addBuf();
            IOBufSliceList iOBufSliceList = ChannelOutput.this.slices;
            synchronized (iOBufSliceList) {
                if (!ChannelOutput.this.closed && !ChannelOutput.this.lastChunkDone) {
                    ChannelOutput.this.slices.extend(this.outputs);
                    if (this.last) {
                        ChannelOutput.this.lastChunkDone = true;
                    }
                } else {
                    this.outputs.freeEntries();
                }
            }
            this.sliceForScatter.markFree();
        }

        public boolean last() {
            return this.last;
        }

        private void addBuf() {
            int pos = this.bufForScatter.position();
            if (this.addBufPos > pos) {
                throw new IllegalStateException(String.format("Wrong position for scatter buffer pos=%d, addBufPos=%d", pos, this.addBufPos));
            }
            if (this.addBufPos == pos) {
                return;
            }
            this.outputs.add(this.sliceForScatter.forkBackwards(pos - this.addBufPos, "add scatter data for channel output chunk"));
            this.addBufPos = pos;
        }
    }
}

