/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.async.BytesInput;
import oracle.kv.impl.async.DialogContext;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.DialogEndpointHandler;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.ProtocolViolationException;
import oracle.kv.impl.async.dialog.ProtocolWriter;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;
import oracle.kv.impl.async.exception.ConnectionException;
import oracle.kv.impl.async.exception.ConnectionUnknownException;
import oracle.kv.impl.async.exception.ContextWriteExceedsLimitException;
import oracle.kv.impl.async.exception.ContextWriteFinException;
import oracle.kv.impl.async.exception.DialogNoSuchTypeException;
import oracle.kv.impl.async.exception.DialogUnknownException;
import oracle.kv.impl.async.perf.DialogPerf;
import oracle.kv.impl.util.CommonLoggerUtils;

class DialogContextImpl
implements DialogContext {
    public static final String TIMEOUT_INFO_PREFIX = "Dialog timed out: ";
    private final DialogEndpointHandler endpointHandler;
    private final Logger logger;
    private final ProtocolWriter protocolWriter;
    private final DialogHandler dialogHandler;
    private final boolean onCreatingSide;
    private final long contextId;
    private volatile long dialogId;
    private final int typeno;
    private final long timeoutMillis;
    private volatile State state;
    private static final int WS_PENDINGMESG = 1;
    private static final int WS_CALLBACK = 2;
    private final AtomicInteger writeState = new AtomicInteger(0);
    private volatile boolean lastMesgWritten = false;
    private Queue<IOBufSliceList> outputFrames = null;
    private final Object frameAndAbortSync = new Object();
    private Queue<MessageInput> inputMessages = new LinkedList<MessageInput>();
    private MessageInput messageReceiving = new MessageInput();
    private int sizeOfMessageReceiving = 0;
    private boolean lastMesgReceived = false;
    private final DialogTimeoutTask timeoutTask = new DialogTimeoutTask();
    private volatile AbortInfo abortInfo = null;
    private final AtomicBoolean dialogAbortWritten = new AtomicBoolean(false);
    private final OnStartTask onStartTask = new OnStartTask();
    private final OnCanReadTask onCanReadTask = new OnCanReadTask();
    private final OnCanWriteTask onCanWriteTask = new OnCanWriteTask();
    private final OnAbortTask onAbortTask = new OnAbortTask();
    private final AtomicBoolean onStartEntered = new AtomicBoolean(false);
    private final Object onStartLock = new Object();
    private volatile boolean onStartExited = false;
    private boolean callOnCanReadAfterStart = false;
    private boolean callOnCanWriteAfterStart = false;
    private boolean callOnAbortAfterStart = false;
    private final AtomicBoolean onAbortCalled = new AtomicBoolean(false);
    private static final ThreadLocal<Boolean> callingOnAbort = ThreadLocal.withInitial(() -> false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final DialogPerf perf = new DialogPerf(this);

    DialogContextImpl(DialogEndpointHandler endpointHandler, DialogHandler dialogHandler, long contextId, long dialogId, int typeno, long timeoutMillis) {
        this.endpointHandler = endpointHandler;
        this.logger = endpointHandler.getLogger();
        this.protocolWriter = endpointHandler.getProtocolWriter();
        this.dialogHandler = dialogHandler;
        this.onCreatingSide = dialogId == 0L;
        this.contextId = contextId;
        this.dialogId = dialogId;
        this.typeno = typeno;
        this.timeoutMillis = timeoutMillis;
        State state = this.state = dialogId == 0L ? State.INITED_NEED_DIALOGSTART : State.STARTED;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Created dialog context: {0}", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(MessageOutput mesg, boolean finished) {
        State prev;
        int maxTotLen;
        int mesgSize = mesg.size();
        if (mesgSize > (maxTotLen = this.endpointHandler.getMaxOutputTotLen())) {
            throw new ContextWriteExceedsLimitException(mesgSize, maxTotLen);
        }
        Queue<IOBufSliceList> frames = mesg.pollFrames(this.endpointHandler.getMaxOutputProtocolMesgLen());
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            switch (this.state) {
                case WRITE_FIN0: 
                case WRITE_FIN: 
                case READ_FIN0_WRITE_FIN0: 
                case READ_FIN_WRITE_FIN0: 
                case READ_FIN0_WRITE_FIN: 
                case FIN: {
                    throw new ContextWriteFinException(this.perf.getNumOutputsWritten());
                }
                case ABORTED: {
                    return false;
                }
            }
            if (!this.setWriteState()) {
                return false;
            }
            prev = this.state;
            switch (this.state) {
                case INITED_NEED_DIALOGSTART: 
                case STARTED: {
                    if (finished) {
                        this.state = State.WRITE_FIN0;
                        break;
                    }
                    this.state = State.STARTED;
                    break;
                }
                case READ_FIN0: {
                    if (!finished) break;
                    this.state = State.READ_FIN0_WRITE_FIN0;
                    break;
                }
                case READ_FIN: {
                    if (!finished) break;
                    this.state = State.READ_FIN_WRITE_FIN0;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (finished) {
                this.lastMesgWritten = true;
            }
            this.outputFrames = frames;
        }
        this.perf.onEvent(DialogPerf.Event.WRITE);
        if (prev == State.INITED_NEED_DIALOGSTART && !frames.isEmpty()) {
            assert (this.dialogId == 0L);
            IOBufSliceList frame = frames.poll();
            boolean cont = !frames.isEmpty();
            boolean last = finished && !cont;
            this.dialogId = this.endpointHandler.writeDialogStartForContext(last, cont, this.typeno, this.timeoutMillis, frame, this);
            this.perf.onEvent(DialogPerf.Event.SEND);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Dialog Id assigned to the context: {0}", this);
            }
        }
        if (this.isAborted()) {
            this.writeDialogAbort();
            return false;
        }
        boolean framesDone = this.onWriteDialogFrame();
        if (!framesDone) {
            this.endpointHandler.onContextNewWrite(this);
        } else {
            this.endpointHandler.flushOrTerminate();
        }
        if (this.isFin()) {
            this.cleanupContext();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageInput read() {
        MessageInput input;
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            if (this.inputMessages == null) {
                return null;
            }
            input = this.inputMessages.poll();
            if (input == null) {
                return null;
            }
            if (this.inputMessages.isEmpty()) {
                switch (this.state) {
                    case INITED_NEED_DIALOGSTART: 
                    case STARTED: {
                        break;
                    }
                    case READ_FIN0: {
                        this.state = State.READ_FIN;
                        break;
                    }
                    case WRITE_FIN0: 
                    case WRITE_FIN: 
                    case READ_FIN: {
                        break;
                    }
                    case READ_FIN0_WRITE_FIN0: {
                        this.state = State.READ_FIN_WRITE_FIN0;
                        break;
                    }
                    case READ_FIN_WRITE_FIN0: {
                        break;
                    }
                    case READ_FIN0_WRITE_FIN: {
                        this.state = State.FIN;
                        break;
                    }
                    case FIN: {
                        throw new IllegalStateException();
                    }
                    case ABORTED: {
                        return null;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        this.perf.onEvent(DialogPerf.Event.READ);
        if (this.isFin()) {
            this.cleanupContext();
        }
        return input;
    }

    @Override
    public long getDialogId() {
        return this.dialogId;
    }

    @Override
    public long getConnectionId() {
        return this.endpointHandler.getConnID();
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.endpointHandler.getRemoteAddress();
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.endpointHandler.getSchedExecService();
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    public boolean isFin() {
        return this.state == State.FIN;
    }

    public boolean isAborted() {
        return this.state == State.ABORTED;
    }

    public DialogHandler getDialogHandler() {
        return this.dialogHandler;
    }

    public DialogPerf getPerf() {
        return this.perf;
    }

    void startTimeout() {
        this.timeoutTask.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReadDialogFrame(boolean finish, boolean cont, BytesInput frame) {
        this.endpointHandler.assertInExecutorThread();
        int readableBytes = frame.remaining();
        int size = this.sizeOfMessageReceiving + readableBytes;
        int maxTotLen = this.endpointHandler.getMaxInputTotLen();
        if (size > maxTotLen) {
            throw new ProtocolViolationException(false, "Max totlen exceeded:" + String.format("Received DialogFrame, limit=%d, mesgTotLen=%d, context=%s", maxTotLen, size, this));
        }
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            this.sizeOfMessageReceiving = !cont ? 0 : (this.sizeOfMessageReceiving += readableBytes);
            switch (this.state) {
                case INITED_NEED_DIALOGSTART: {
                    throw new AssertionError();
                }
                case STARTED: {
                    if (!finish) break;
                    this.state = State.READ_FIN0;
                    break;
                }
                case READ_FIN0: 
                case READ_FIN: {
                    throw new ProtocolViolationException(false, "Invalid dialog state:" + String.format("Received DialogFrame, context=%s", this));
                }
                case WRITE_FIN0: {
                    if (!finish) break;
                    this.state = State.READ_FIN0_WRITE_FIN0;
                    break;
                }
                case WRITE_FIN: {
                    if (!finish) break;
                    this.state = State.READ_FIN0_WRITE_FIN;
                    break;
                }
                case READ_FIN0_WRITE_FIN0: 
                case READ_FIN_WRITE_FIN0: 
                case READ_FIN0_WRITE_FIN: 
                case FIN: {
                    throw new ProtocolViolationException(false, "Invalid dialog state:" + String.format("Received DialogFrame, context=%s", this));
                }
                case ABORTED: {
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.messageReceiving.add(frame);
            this.perf.onEvent(DialogPerf.Event.RECV);
            if (cont) {
                return;
            }
            this.inputMessages.add(this.messageReceiving);
            this.messageReceiving = new MessageInput();
            this.lastMesgReceived = finish;
        }
        this.onCanReadTask.incNumInvokes();
        this.callOnCanRead(true);
        if (this.isFin()) {
            this.cleanupContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onWriteDialogFrame() {
        boolean lastFrame;
        IOBufSliceList frame = null;
        Object object = this;
        synchronized (object) {
            if (this.isAborted()) {
                return true;
            }
            if (this.outputFrames == null) {
                lastFrame = true;
            } else {
                frame = this.outputFrames.poll();
                lastFrame = this.outputFrames.isEmpty();
            }
            if (lastFrame) {
                switch (this.state) {
                    case INITED_NEED_DIALOGSTART: {
                        throw new AssertionError();
                    }
                    case STARTED: 
                    case READ_FIN0: 
                    case READ_FIN: {
                        break;
                    }
                    case WRITE_FIN0: {
                        this.state = State.WRITE_FIN;
                        break;
                    }
                    case WRITE_FIN: {
                        break;
                    }
                    case READ_FIN0_WRITE_FIN0: {
                        this.state = State.READ_FIN0_WRITE_FIN;
                        break;
                    }
                    case READ_FIN_WRITE_FIN0: {
                        this.state = State.FIN;
                        break;
                    }
                    case READ_FIN0_WRITE_FIN: 
                    case FIN: {
                        throw new AssertionError();
                    }
                    case ABORTED: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.outputFrames = null;
            }
        }
        if (frame != null) {
            object = this.frameAndAbortSync;
            synchronized (object) {
                if (this.state != State.ABORTED) {
                    this.protocolWriter.writeDialogFrame(this.lastMesgWritten && lastFrame, !lastFrame, this.dialogId, frame);
                    this.perf.onEvent(DialogPerf.Event.SEND);
                }
            }
        }
        if (lastFrame) {
            this.onWrittenLastFrame();
        }
        if (this.isFin()) {
            this.cleanupContext();
        }
        return lastFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReadDialogAbort(ProtocolMesg.DialogAbort.Cause cause, String detail) {
        this.endpointHandler.assertInExecutorThread();
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            if (this.isAborted() || this.isFin()) {
                return;
            }
            this.abortInfo = new AbortInfo(cause, detail);
            this.state = State.ABORTED;
        }
        this.cleanupContext();
        this.callOnAbort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLocalAbortTimeout() {
        this.endpointHandler.assertInExecutorThread();
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            if (this.isAborted() || this.isFin()) {
                return;
            }
            this.abortInfo = new AbortInfo(new RequestTimeoutException((int)this.timeoutMillis, TIMEOUT_INFO_PREFIX + this.toString(), null, false), ProtocolMesg.DialogAbort.Cause.TIMED_OUT);
            this.state = State.ABORTED;
        }
        this.writeDialogAbort();
        this.cleanupContext();
        this.callOnAbort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLocalAbortHandlerError(Throwable cause) {
        this.endpointHandler.assertInExecutorThread();
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            if (this.isAborted() || this.isFin()) {
                return;
            }
            this.abortInfo = new AbortInfo(new DialogUnknownException(this.hasSideEffect(), false, cause.getMessage(), cause), ProtocolMesg.DialogAbort.Cause.UNKNOWN_REASON);
            this.state = State.ABORTED;
        }
        this.writeDialogAbort();
        this.cleanupContext();
        this.callOnAbort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLocalAbortConnectionException(ConnectionException cause) {
        DialogContextImpl dialogContextImpl = this;
        synchronized (dialogContextImpl) {
            if (this.isAborted() || this.isFin()) {
                return;
            }
            this.abortInfo = new AbortInfo(cause.getDialogException(this.hasSideEffect()), ProtocolMesg.DialogAbort.Cause.CONNECTION_ABORT);
            this.state = State.ABORTED;
        }
        this.writeDialogAbort();
        this.cleanupContext();
        this.callOnAbort(false);
    }

    private boolean hasSideEffect() {
        if (!this.onCreatingSide) {
            return true;
        }
        return this.state != State.INITED_NEED_DIALOGSTART;
    }

    private void onWrittenLastFrame() {
        boolean callOnCanWrite = this.clearWriteState();
        if (!callOnCanWrite) {
            return;
        }
        this.callOnCanWrite();
    }

    private boolean setWriteState() {
        while (true) {
            int next;
            int curr;
            if (((curr = this.writeState.get()) & 1) != 0) {
                if ((curr & 2) != 0) {
                    return false;
                }
                next = curr | 2;
                if (!this.writeState.compareAndSet(curr, next)) continue;
                return false;
            }
            if ((curr & 2) != 0) {
                throw new IllegalStateException(String.format("No pending write but need callback is set. Context=%s", this));
            }
            next = curr | 1;
            if (this.writeState.compareAndSet(curr, next)) break;
        }
        return true;
    }

    private boolean clearWriteState() {
        int curr;
        do {
            if (((curr = this.writeState.get()) & 1) == 0) {
                throw new IllegalStateException(String.format("Message write is done, but no pending write in the first place. Context=%s", this));
            }
            boolean next = false;
        } while (!this.writeState.compareAndSet(curr, 0));
        return (curr & 2) != 0;
    }

    void callOnStart() {
        this.onStartTask.run();
    }

    private void callOnCanRead(boolean inExecutorThread) {
        if (!inExecutorThread) {
            this.getSchedExecService().execute(this.onCanReadTask);
            return;
        }
        this.onCanReadTask.run();
    }

    private void callOnCanWrite() {
        this.getSchedExecService().execute(this.onCanWriteTask);
    }

    private void callOnAbort(boolean inExecutorThread) {
        this.onStartTask.run();
        if (!callingOnAbort.get().booleanValue() && inExecutorThread) {
            this.onAbortTask.run();
            return;
        }
        this.getSchedExecService().execute(this.onAbortTask);
    }

    private Throwable causeToThrowable(ProtocolMesg.DialogAbort.Cause c, String d) {
        switch (c) {
            case UNKNOWN_REASON: {
                return new DialogUnknownException(this.hasSideEffect(), true, d, null);
            }
            case CONNECTION_ABORT: {
                return new ConnectionUnknownException(d).getDialogException(this.hasSideEffect());
            }
            case ENDPOINT_SHUTTINGDOWN: {
                return new ConnectionEndpointShutdownException(true, d).getDialogException(false);
            }
            case TIMED_OUT: {
                return new RequestTimeoutException((int)this.timeoutMillis, TIMEOUT_INFO_PREFIX + this.toString(), null, true);
            }
            case UNKNOWN_TYPE: {
                return new DialogNoSuchTypeException(d);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown dialog abort cause: %s", new Object[]{c}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupContext() {
        if (this.isDone.compareAndSet(false, true)) {
            DialogContextImpl dialogContextImpl = this;
            synchronized (dialogContextImpl) {
                if (this.outputFrames != null) {
                    IOBufSliceList outputFrame;
                    while ((outputFrame = this.outputFrames.poll()) != null) {
                        outputFrame.freeEntries();
                    }
                    this.outputFrames = null;
                }
                if (this.inputMessages != null) {
                    MessageInput inputMessage;
                    while ((inputMessage = this.inputMessages.poll()) != null) {
                        inputMessage.discard();
                    }
                    this.inputMessages = null;
                }
                this.messageReceiving.discard();
                this.messageReceiving = null;
            }
            this.timeoutTask.cancel();
            if (this.isAborted()) {
                this.perf.onEvent(DialogPerf.Event.ABORT);
            } else {
                this.perf.onEvent(DialogPerf.Event.FIN);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Dialog context done: {0}", this);
            }
            this.endpointHandler.onContextDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDialogAbort() {
        if (this.abortInfo == null) {
            return;
        }
        if (this.abortInfo.fromRemote) {
            return;
        }
        if (this.dialogId == 0L) {
            return;
        }
        if (this.dialogAbortWritten.compareAndSet(false, true)) {
            Object object = this.frameAndAbortSync;
            synchronized (object) {
                this.protocolWriter.writeDialogAbort(this.abortInfo.cause, this.dialogId, this.abortInfo.detail);
            }
        }
    }

    public String getStringID() {
        return String.format("%s:%s", Long.toString(this.dialogId, 16), this.endpointHandler.getStringID());
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder("DialogContext");
        builder.append("[");
        builder.append(" dialogId=").append(this.getStringID());
        builder.append(" contextId=").append(Long.toString(this.contextId, 16));
        builder.append(" dialogType=").append(this.typeno);
        builder.append(" dialogHandler=").append(this.dialogHandler);
        builder.append(" onCreatingEndpoint=").append(this.onCreatingSide);
        builder.append(" timeout=").append(this.timeoutMillis);
        builder.append(" state=").append((Object)this.state);
        builder.append(" writeState=").append(this.writeState.get());
        builder.append(" abortInfo=").append(this.abortInfo);
        builder.append(" perf=").append(this.perf);
        builder.append("]");
        return builder.toString();
    }

    private class DialogTimeoutTask
    extends DialogTask {
        private volatile Future<?> future;

        private DialogTimeoutTask() {
            this.future = null;
        }

        @Override
        public void run() {
            DialogContextImpl.this.onLocalAbortTimeout();
        }

        void schedule() {
            if (this.future != null) {
                return;
            }
            ScheduledExecutorService executor = DialogContextImpl.this.getSchedExecService();
            if (executor == null) {
                return;
            }
            try {
                this.future = executor.schedule(this, DialogContextImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                DialogContextImpl.this.onLocalAbortConnectionException(new ConnectionUnknownException(e));
            }
        }

        void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }

    private class AbortInfo {
        private final State preState;
        private final ProtocolMesg.DialogAbort.Cause cause;
        private final String detail;
        private final Throwable throwable;
        private final boolean fromRemote;

        AbortInfo(ProtocolMesg.DialogAbort.Cause cause, String detail) {
            this.preState = DialogContextImpl.this.state;
            this.cause = cause;
            this.detail = this.getDetail(detail);
            this.throwable = DialogContextImpl.this.causeToThrowable(cause, detail);
            this.fromRemote = true;
        }

        AbortInfo(Throwable throwable, ProtocolMesg.DialogAbort.Cause cause) {
            this.preState = DialogContextImpl.this.state;
            this.cause = cause;
            this.detail = this.getDetail(throwable.getMessage());
            this.throwable = throwable;
            this.fromRemote = false;
        }

        String getDetail(String s) {
            return s == null ? "null" : s;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            sb.append("preState=").append((Object)this.preState);
            sb.append(" causeToSend=").append((Object)this.cause);
            sb.append(" detail=").append(this.detail);
            sb.append(" throwable=").append(this.throwable);
            sb.append(" fromRemote=").append(this.fromRemote);
            sb.append(")");
            return sb.toString();
        }
    }

    private class OnAbortTask
    extends DialogTask {
        private OnAbortTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!DialogContextImpl.this.onStartExited) {
                Object object = DialogContextImpl.this.onStartLock;
                synchronized (object) {
                    if (!DialogContextImpl.this.onStartExited) {
                        DialogContextImpl.this.callOnAbortAfterStart = true;
                        return;
                    }
                }
            }
            this.doWork();
        }

        private void doWork() {
            if (DialogContextImpl.this.abortInfo == null) {
                throw new AssertionError();
            }
            if (DialogContextImpl.this.onAbortCalled.compareAndSet(false, true)) {
                callingOnAbort.set(true);
                try {
                    DialogContextImpl.this.dialogHandler.onAbort(DialogContextImpl.this, DialogContextImpl.this.abortInfo.throwable);
                }
                catch (Throwable t) {
                    DialogContextImpl.this.logger.log(Level.WARNING, "Exception in dialog handler: {0}", new Object[]{CommonLoggerUtils.getStackTrace(t)});
                    return;
                }
                finally {
                    callingOnAbort.set(false);
                }
            }
        }
    }

    private class OnCanWriteTask
    extends DialogTask {
        private OnCanWriteTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!DialogContextImpl.this.onStartExited) {
                Object object = DialogContextImpl.this.onStartLock;
                synchronized (object) {
                    if (!DialogContextImpl.this.onStartExited) {
                        DialogContextImpl.this.callOnCanWriteAfterStart = true;
                        return;
                    }
                }
            }
            this.doWork();
        }

        private void doWork() {
            if (DialogContextImpl.this.state != State.ABORTED && !DialogContextImpl.this.lastMesgWritten) {
                try {
                    DialogContextImpl.this.dialogHandler.onCanWrite(DialogContextImpl.this);
                }
                catch (Throwable t) {
                    if (DialogContextImpl.this.logger.isLoggable(Level.INFO)) {
                        DialogContextImpl.this.logger.log(Level.INFO, "Encountered error with dialog handler: context={0}, error={1}", new Object[]{DialogContextImpl.this, CommonLoggerUtils.getStackTrace(t)});
                    }
                    DialogContextImpl.this.onLocalAbortHandlerError(t);
                }
            }
        }
    }

    private class OnCanReadTask
    extends DialogTask {
        private int numInvokes;

        private OnCanReadTask() {
            this.numInvokes = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!DialogContextImpl.this.onStartExited) {
                Object object = DialogContextImpl.this.onStartLock;
                synchronized (object) {
                    if (!DialogContextImpl.this.onStartExited) {
                        DialogContextImpl.this.callOnCanReadAfterStart = true;
                        return;
                    }
                }
            }
            while (this.numInvokes > 0) {
                this.doWork();
                --this.numInvokes;
            }
        }

        private void incNumInvokes() {
            ++this.numInvokes;
        }

        private void doWork() {
            try {
                DialogContextImpl.this.dialogHandler.onCanRead(DialogContextImpl.this, DialogContextImpl.this.lastMesgReceived);
            }
            catch (Throwable t) {
                if (DialogContextImpl.this.logger.isLoggable(Level.INFO)) {
                    DialogContextImpl.this.logger.log(Level.INFO, "Encountered error with dialog handler: context={0}, error={1}", new Object[]{DialogContextImpl.this, CommonLoggerUtils.getStackTrace(t)});
                }
                DialogContextImpl.this.onLocalAbortHandlerError(t);
            }
        }
    }

    private class OnStartTask
    extends DialogTask {
        private OnStartTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DialogContextImpl.this.onStartEntered.compareAndSet(false, true)) {
                try {
                    DialogContextImpl.this.dialogHandler.onStart(DialogContextImpl.this, DialogContextImpl.this.isAborted());
                }
                catch (Throwable t) {
                    DialogContextImpl.this.onLocalAbortHandlerError(t);
                }
                Object object = DialogContextImpl.this.onStartLock;
                synchronized (object) {
                    DialogContextImpl.this.onStartExited = true;
                    if (DialogContextImpl.this.callOnCanReadAfterStart) {
                        DialogContextImpl.this.callOnCanRead(false);
                        DialogContextImpl.this.callOnCanReadAfterStart = false;
                    }
                    if (DialogContextImpl.this.callOnCanWriteAfterStart) {
                        DialogContextImpl.this.callOnCanWrite();
                        DialogContextImpl.this.callOnCanWriteAfterStart = false;
                    }
                    if (DialogContextImpl.this.callOnAbortAfterStart) {
                        DialogContextImpl.this.callOnAbort(false);
                        DialogContextImpl.this.callOnAbortAfterStart = false;
                    }
                }
            }
        }
    }

    private abstract class DialogTask
    implements Runnable {
        private DialogTask() {
        }

        public String toString() {
            return String.format("%s@Dialog:%s", this.getClass().getSimpleName(), DialogContextImpl.this.getStringID());
        }
    }

    static enum State {
        INITED_NEED_DIALOGSTART,
        STARTED,
        READ_FIN0,
        READ_FIN,
        WRITE_FIN0,
        WRITE_FIN,
        READ_FIN0_WRITE_FIN0,
        READ_FIN_WRITE_FIN0,
        READ_FIN0_WRITE_FIN,
        FIN,
        ABORTED;

    }
}

