/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import java.util.Arrays;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.dialog.ChannelInput;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.ProtocolViolationException;

public class ProtocolReader {
    private final ChannelInput input;
    private final int maxMesgLen;

    public ProtocolReader(ChannelInput input, int maxLength) {
        this.input = input;
        this.maxMesgLen = maxLength;
    }

    public ProtocolMesg read() {
        if (this.input.readableBytes() < 1) {
            return null;
        }
        this.input.mark();
        byte ident = this.input.readByte();
        switch (ProtocolMesg.getType(ident)) {
            case 1: {
                return this.readProtocolVersion();
            }
            case 2: {
                return this.readProtocolVersionResponse();
            }
            case 3: {
                return this.readConnectionConfig();
            }
            case 4: {
                return this.readConnectionConfigResponse();
            }
            case 8: {
                return this.readNoOperation();
            }
            case 9: {
                return this.readConnectionAbort();
            }
            case 10: {
                return this.readPing();
            }
            case 11: {
                return this.readPingAck();
            }
            case 16: {
                return this.readDialogStart(ident);
            }
            case 32: {
                return this.readDialogFrame(ident);
            }
            case 48: {
                return this.readDialogAbort();
            }
        }
        throw new ProtocolViolationException(false, String.format("%s%x, %s", "Unknown identifier:", ident, this.input));
    }

    private ProtocolMesg readProtocolVersion() {
        if (this.input.readableBytes() < 4) {
            this.input.reset();
            return null;
        }
        byte[] magicNumber = new byte[]{1, this.input.readByte(), this.input.readByte(), this.input.readByte()};
        if (!Arrays.equals(magicNumber, ProtocolMesg.MAGIC_NUMBER)) {
            throw new ProtocolViolationException(false, String.format("%sExpected %s, but got %s", "Invalid magic number:", BytesUtil.toString(magicNumber, 1, 3), BytesUtil.toString(ProtocolMesg.MAGIC_NUMBER, 1, 3)));
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.ProtocolVersion((int)this.input.readPackedLong());
    }

    private ProtocolMesg readProtocolVersionResponse() {
        if (this.input.readableBytes() < 4) {
            this.input.reset();
            return null;
        }
        byte[] magicNumber = new byte[]{1, this.input.readByte(), this.input.readByte(), this.input.readByte()};
        if (!Arrays.equals(magicNumber, ProtocolMesg.MAGIC_NUMBER)) {
            throw new ProtocolViolationException(false, String.format("%sExpected %s, but got %s", "Invalid magic number:", BytesUtil.toString(magicNumber, 1, 3), BytesUtil.toString(ProtocolMesg.MAGIC_NUMBER, 1, 3)));
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.ProtocolVersionResponse((int)this.input.readPackedLong());
    }

    private ProtocolMesg readConnectionConfig() {
        if (this.input.readableBytes() < 5) {
            this.input.reset();
            return null;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long uuid = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxDialogs = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxLength = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxTotLen = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long interval = this.input.readPackedLong();
        if (maxDialogs <= 0L || maxLength <= 0L || maxTotLen <= 0L || interval <= 0L) {
            throw new ProtocolViolationException(false, String.format("%s Received ConnectionConfig(uuid=%x maxDialogs=%d maxLength=%d maxTotLen=%d interval=%d)", "Invalid field value:", uuid, maxDialogs, maxLength, maxTotLen, interval));
        }
        return new ProtocolMesg.ConnectionConfig(uuid, maxDialogs, maxLength, maxTotLen, interval);
    }

    private ProtocolMesg readConnectionConfigResponse() {
        if (this.input.readableBytes() < 4) {
            this.input.reset();
            return null;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxDialogs = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxLength = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long maxTotLen = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long interval = this.input.readPackedLong();
        if (maxDialogs <= 0L || maxLength <= 0L || maxTotLen <= 0L || interval <= 0L) {
            throw new ProtocolViolationException(false, String.format("%s Received ConnectionConfig(maxDialogs=%d maxLength=%d maxTotLen=%d interval=%d)", "Invalid field value:", maxDialogs, maxLength, maxTotLen, interval));
        }
        return new ProtocolMesg.ConnectionConfigResponse(maxDialogs, maxLength, maxTotLen, interval);
    }

    private ProtocolMesg readNoOperation() {
        return new ProtocolMesg.NoOperation();
    }

    private ProtocolMesg readConnectionAbort() {
        if (this.input.readableBytes() < 2) {
            this.input.reset();
            return null;
        }
        byte errno = this.input.readByte();
        if (errno < 0 || errno >= ProtocolMesg.ConnectionAbort.CAUSES.length) {
            errno = 0;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        int length = (int)this.input.readPackedLong();
        if (length < 0) {
            throw new ProtocolViolationException(false, String.format("%s Received negative length in ConnectionAbort, length=%d", "Invalid field value:", length));
        }
        if (length > this.maxMesgLen) {
            length = 0;
        }
        if (this.input.readableBytes() < length) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.ConnectionAbort(ProtocolMesg.ConnectionAbort.CAUSES[errno], this.input.readUTF8(length));
    }

    private ProtocolMesg readPing() {
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.Ping(this.input.readPackedLong());
    }

    private ProtocolMesg readPingAck() {
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.PingAck(this.input.readPackedLong());
    }

    private ProtocolMesg readDialogStart(byte ident) {
        boolean cont;
        boolean sampled = (ident & 4) != 0;
        boolean finish = (ident & 2) != 0;
        boolean bl = cont = (ident & 1) != 0;
        if (finish && cont) {
            throw new ProtocolViolationException(false, "Invalid field value:Both finish and cont are true in DialogStart");
        }
        if (this.input.readableBytes() < 4) {
            this.input.reset();
            return null;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        int typeno = (int)this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long dialogId = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long timeout = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        int length = (int)this.input.readPackedLong();
        if (dialogId == 0L || timeout <= 0L || length < 0) {
            throw new ProtocolViolationException(false, String.format("%s Received DialogStart (dialogId=%s timeout=%d length=%d)", "Invalid field value:", Long.toString(dialogId, 16), timeout, length));
        }
        this.checkMaxLength(length, "DialogStart");
        if (this.input.readableBytes() < length) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.DialogStart(sampled, finish, cont, typeno, dialogId, timeout, this.input.readBytes(length));
    }

    private ProtocolMesg readDialogFrame(byte ident) {
        boolean cont;
        boolean finish = (ident & 2) != 0;
        boolean bl = cont = (ident & 1) != 0;
        if (finish && cont) {
            throw new ProtocolViolationException(false, "Invalid field value:Both finish and cont are true in DialogStart");
        }
        if (this.input.readableBytes() < 2) {
            this.input.reset();
            return null;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long dialogId = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        int length = (int)this.input.readPackedLong();
        if (dialogId == 0L || length < 0) {
            throw new ProtocolViolationException(false, String.format("%s Received DialogFrame (dialogId=%s length=%d)", "Invalid field value:", Long.toString(dialogId, 16), length));
        }
        this.checkMaxLength(length, "DialogFrame");
        if (this.input.readableBytes() < length) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.DialogFrame(finish, cont, dialogId, this.input.readBytes(length));
    }

    private ProtocolMesg readDialogAbort() {
        if (this.input.readableBytes() < 3) {
            this.input.reset();
            return null;
        }
        byte errno = this.input.readByte();
        if (errno < 0 || errno >= ProtocolMesg.DialogAbort.CAUSES.length) {
            errno = 0;
        }
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        long dialogId = this.input.readPackedLong();
        if (!this.input.canReadPackedLong()) {
            this.input.reset();
            return null;
        }
        int length = (int)this.input.readPackedLong();
        if (dialogId == 0L || length < 0) {
            throw new ProtocolViolationException(false, String.format("%s Received DialogAbort (dialogId=%s length=%d)", "Invalid field value:", Long.toString(dialogId, 16), length));
        }
        this.checkMaxLength(length, "DialogAbort");
        if (this.input.readableBytes() < length) {
            this.input.reset();
            return null;
        }
        return new ProtocolMesg.DialogAbort(ProtocolMesg.DialogAbort.CAUSES[errno], dialogId, this.input.readUTF8(length));
    }

    private void checkMaxLength(int length, String mesg) {
        if (length > this.maxMesgLen) {
            throw new ProtocolViolationException(false, String.format("%s Received %s with length=%d, but the limit is %d", "Max length exceeded:", mesg, length, this.maxMesgLen));
        }
    }
}

