/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import oracle.kv.impl.async.BytesInput;

class NettyBytesInput
implements BytesInput {
    private final ByteBuf buffer;

    NettyBytesInput(ByteBuf buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        if (this.buffer.readableBytes() < len) {
            throw new EOFException();
        }
        this.buffer.readBytes(b, off, len);
        this.discardIfEmpty();
    }

    @Override
    public void skipBytes(int n) throws EOFException {
        if (this.buffer.readableBytes() < n) {
            throw new EOFException();
        }
        this.buffer.readerIndex(this.buffer.readerIndex() + n);
        this.discardIfEmpty();
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.buffer.readableBytes() == 0) {
            throw new EOFException();
        }
        byte b = this.buffer.readByte();
        this.discardIfEmpty();
        return b;
    }

    @Override
    public int remaining() {
        return this.buffer.readableBytes();
    }

    @Override
    public void discard() {
        this.buffer.release();
    }

    public void discardIfEmpty() {
        if (this.buffer.readableBytes() == 0) {
            this.buffer.release();
        }
    }
}

