/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractCreatorEndpoint;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.netty.NettyEndpointGroup;
import oracle.kv.impl.async.dialog.netty.NettyUtil;
import oracle.kv.impl.async.dialog.netty.PreWriteWrappedEndpointHandler;

class NettyCreatorEndpoint
extends AbstractCreatorEndpoint {
    private final NettyEndpointGroup endpointGroup;
    private final EventLoopGroup eventLoopGroup;

    NettyCreatorEndpoint(NettyEndpointGroup endpointGroup, EventLoopGroup eventLoopGroup, NetworkAddress remoteAddress, NetworkAddress localAddress, EndpointConfig endpointConfig) {
        super(endpointGroup, remoteAddress, localAddress, endpointConfig);
        this.endpointGroup = endpointGroup;
        this.eventLoopGroup = eventLoopGroup;
    }

    @Override
    protected EndpointHandler newEndpointHandler() throws IOException {
        NetworkAddress address = this.getRemoteAddress();
        PreWriteWrappedEndpointHandler handler = new PreWriteWrappedEndpointHandler(this, this.endpointConfig, address);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new Initializer(handler));
        NettyUtil.connect(bootstrap, this.endpointConfig, address);
        return handler;
    }

    Logger getLogger() {
        return this.endpointGroup.getLogger();
    }

    private class Initializer
    extends ChannelInitializer<SocketChannel> {
        private final PreWriteWrappedEndpointHandler handler;

        Initializer(PreWriteWrappedEndpointHandler handler) {
            this.handler = handler;
        }

        public void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{this.handler});
        }
    }
}

