/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.io.EOFException;
import java.nio.ByteBuffer;
import oracle.kv.impl.async.BytesInput;
import oracle.kv.impl.async.IOBufSliceList;

class NioBytesInput
implements BytesInput {
    private int remaining;
    private final IOBufSliceList buflist;

    NioBytesInput(int remaining, IOBufSliceList buflist) {
        this.remaining = remaining;
        this.buflist = buflist;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        if (len == 0) {
            return;
        }
        if (this.remaining < len) {
            throw new EOFException();
        }
        do {
            IOBufSliceList.Entry slice;
            if ((slice = this.buflist.head()) == null) {
                throw new IllegalStateException("Incorrect buffer accounting");
            }
            ByteBuffer buf = slice.buf();
            int n = Math.min(len, buf.remaining());
            buf.get(b, off, n);
            len -= n;
            off += n;
            this.remaining -= n;
            if (buf.remaining() != 0) continue;
            this.buflist.poll();
            slice.markFree();
        } while (len != 0);
    }

    @Override
    public void skipBytes(int n) throws EOFException {
        if (this.remaining < n) {
            throw new EOFException();
        }
        do {
            IOBufSliceList.Entry slice;
            if ((slice = this.buflist.head()) == null) {
                throw new IllegalStateException("Incorrect buffer accounting");
            }
            ByteBuffer buf = slice.buf();
            int toskip = Math.min(n, buf.remaining());
            buf.position(buf.position() + toskip);
            n -= toskip;
            this.remaining -= toskip;
            if (buf.remaining() != 0) continue;
            this.buflist.poll();
            slice.markFree();
        } while (n != 0);
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.remaining == 0) {
            throw new EOFException();
        }
        while (true) {
            IOBufSliceList.Entry slice;
            if ((slice = this.buflist.head()) == null) {
                throw new IllegalStateException("Incorrect buffer accounting");
            }
            ByteBuffer buf = slice.buf();
            if (buf.remaining() != 0) {
                --this.remaining;
                return buf.get();
            }
            this.buflist.poll();
            slice.markFree();
        }
    }

    @Override
    public int remaining() {
        return this.remaining;
    }

    @Override
    public void discard() {
        IOBufSliceList.Entry slice;
        while ((slice = this.buflist.poll()) != null) {
            slice.markFree();
        }
        return;
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.buflist);
    }
}

