/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.util.PackedInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import oracle.kv.impl.async.BytesInput;
import oracle.kv.impl.async.IOBufSliceImpl;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.IOBufferPool;
import oracle.kv.impl.async.dialog.ChannelInput;
import oracle.kv.impl.async.dialog.nio.NioBytesInput;

class NioChannelInput
implements ChannelInput {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    private static final IOBufSliceImpl emptySlice = new IOBufSliceImpl.HeapBufSlice(emptyBuf);
    private final IOBufferPool pool;
    private final IOBufSliceList inputSliceList;
    private IOBufSliceImpl chnlSlice0;
    private ByteBuffer chnlBuf0;
    private IOBufSliceImpl chnlSlice1;
    private ByteBuffer chnlBuf1;
    private final ByteBuffer[] chnlArray = new ByteBuffer[2];
    private int chnlPos;
    private IOBufSliceImpl protoSlice;
    private ByteBuffer protoBuf;
    private int protoPos;
    private int markPos;
    private int readableBytes = 0;
    private final byte[] packedLongBytes = new byte[9];
    private boolean closed = false;

    NioChannelInput() {
        this(IOBufferPool.CHNL_IN_POOL);
    }

    NioChannelInput(IOBufferPool pool) {
        this.pool = pool;
        this.chnlSlice0 = IOBufSliceImpl.InputPoolBufSlice.createFromPool(pool, "chnlSlice0 for channel input");
        this.chnlBuf0 = this.chnlSlice0.buf();
        this.chnlSlice1 = IOBufSliceImpl.InputPoolBufSlice.createFromPool(pool, "chnlSlice1 for channel input");
        this.chnlBuf1 = this.chnlSlice1.buf();
        this.chnlArray[0] = this.chnlBuf0;
        this.chnlArray[1] = this.chnlBuf1;
        this.chnlPos = 0;
        this.inputSliceList = new IOBufSliceList();
        this.inputSliceList.add(this.chnlSlice0);
        this.inputSliceList.add(this.chnlSlice1);
        this.protoSlice = this.chnlSlice0;
        this.protoBuf = this.chnlBuf0;
        this.protoPos = 0;
        this.markPos = 0;
    }

    @Override
    public void mark() {
        this.pollUntilProtoSlice();
        this.markPos = this.protoBuf.position();
    }

    @Override
    public void reset() {
        for (IOBufSliceList.Entry slice = this.inputSliceList.head(); slice != null; slice = slice.next()) {
            ByteBuffer buf = slice.buf();
            this.readableBytes += buf.position();
            buf.position(0);
            if (slice == this.protoSlice) break;
        }
        this.protoSlice = (IOBufSliceImpl)this.inputSliceList.head();
        this.protoBuf = this.protoSlice.buf();
        this.protoBuf.position(this.markPos);
        this.readableBytes -= this.markPos;
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public byte readByte() {
        this.ensureProtoSliceNotConsumed();
        byte b = this.protoBuf.get();
        --this.readableBytes;
        return b;
    }

    @Override
    public BytesInput readBytes(int len) {
        if (len == 0) {
            return new NioBytesInput(0, null);
        }
        IOBufSliceList bufs = new IOBufSliceList();
        int n = len;
        while (true) {
            int chunkLen;
            if ((chunkLen = Math.min(n, this.protoBuf.remaining())) != 0) {
                bufs.add(this.protoSlice.forkAndAdvance(chunkLen, "read bytes from channel input"));
                n -= chunkLen;
            }
            if (n == 0) break;
            this.ensureProtoSliceNotConsumed();
        }
        this.readableBytes -= len;
        return new NioBytesInput(len, bufs);
    }

    @Override
    public boolean canReadPackedLong() {
        if (this.readableBytes == 0) {
            return false;
        }
        return this.readableBytes >= this.peekPackedLongLength();
    }

    @Override
    public long readPackedLong() {
        int rest;
        int len = this.peekPackedLongLength();
        if (len <= (rest = this.protoBuf.remaining())) {
            this.protoBuf.get(this.packedLongBytes, 0, len);
        } else {
            this.protoBuf.get(this.packedLongBytes, 0, rest);
            this.ensureProtoSliceNotConsumed();
            this.protoBuf.get(this.packedLongBytes, rest, len - rest);
        }
        this.readableBytes -= len;
        return PackedInteger.readLong(this.packedLongBytes, 0);
    }

    private int peekPackedLongLength() {
        this.ensureProtoSliceNotConsumed();
        this.packedLongBytes[0] = this.protoBuf.get(this.protoBuf.position());
        return PackedInteger.getReadLongLength(this.packedLongBytes, 0);
    }

    @Override
    public String readUTF8(int length) {
        if (this.readableBytes < length) {
            return null;
        }
        int len = length;
        byte[] bytes = new byte[length];
        int offset = 0;
        while (true) {
            int n = Math.min(length, this.protoBuf.remaining());
            this.protoBuf.get(bytes, offset, n);
            offset += n;
            if ((length -= n) == 0) break;
            this.ensureProtoSliceNotConsumed();
        }
        this.readableBytes -= len;
        return utf8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    @Override
    public void close() {
        this.closed = true;
        this.inputSliceList.freeEntries();
        this.chnlBuf1 = this.protoBuf = emptyBuf;
        this.chnlBuf0 = this.protoBuf;
        this.chnlSlice1 = this.protoSlice = emptySlice;
        this.chnlSlice0 = this.protoSlice;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelInput");
        builder.append(" chnlPos=").append(this.chnlPos);
        builder.append(" markPos=").append(this.markPos);
        builder.append(" protoPos=").append(this.protoPos);
        builder.append(" readable=").append(this.readableBytes);
        builder.append(" bufs={");
        for (IOBufSliceList.Entry slice = this.inputSliceList.head(); slice != null; slice = slice.next()) {
            if (slice == this.protoSlice) {
                builder.append("Proto");
            }
            if (slice == this.chnlSlice0) {
                builder.append("Chnl0");
            }
            if (slice == this.chnlSlice1) {
                builder.append("Chnl1");
            }
            builder.append(slice);
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    ByteBuffer[] flipToChannelRead() {
        this.markPos = 0;
        this.pollUntilProtoSlice();
        this.protoPos = this.protoBuf.position();
        this.chnlBuf0.position(this.chnlPos);
        this.chnlBuf0.limit(this.chnlBuf0.capacity());
        return this.chnlArray;
    }

    void flipToProtocolRead() {
        this.readableBytes += this.chnlBuf0.position() - this.chnlPos;
        this.readableBytes += this.chnlBuf1.position();
        while (this.chnlBuf0.remaining() == 0) {
            this.chnlBuf0.limit(this.chnlBuf0.capacity());
            this.chnlBuf0.position(0);
            this.chnlSlice0 = this.chnlSlice1;
            this.chnlSlice1 = this.closed ? emptySlice : IOBufSliceImpl.InputPoolBufSlice.createFromPool(this.pool, "new chnlSlice1 for channel input");
            this.chnlBuf0 = this.chnlSlice0.buf();
            this.chnlBuf1 = this.chnlSlice1.buf();
            this.chnlArray[0] = this.chnlBuf0;
            this.chnlArray[1] = this.chnlBuf1;
            this.inputSliceList.add(this.chnlSlice1);
        }
        this.chnlPos = this.chnlBuf0.position();
        this.chnlBuf0.limit(this.chnlPos);
        this.chnlBuf0.position(0);
        this.pollUntilProtoSlice();
        this.protoBuf.position(this.protoPos);
    }

    private void pollUntilProtoSlice() {
        IOBufSliceList.Entry slice;
        while ((slice = this.inputSliceList.head()) != null && slice != this.protoSlice) {
            this.inputSliceList.poll();
            slice.markFree();
        }
    }

    private void ensureProtoSliceNotConsumed() {
        ByteBuffer buf;
        IOBufSliceList.Entry curr = this.protoSlice;
        while ((buf = curr.buf()).remaining() <= 0) {
            if ((curr = curr.next()) != null) continue;
            throw new IllegalStateException(String.format("There is not enough data, should check readableBytes before read, input=%s", this.toString()));
        }
        this.protoSlice = curr;
        this.protoBuf = this.protoSlice.buf();
    }
}

