/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.nio.ByteBuffer;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.IOBufSliceList;
import oracle.kv.impl.async.IOBufferPool;
import oracle.kv.impl.async.dialog.ChannelOutput;

class NioChannelOutput
extends ChannelOutput {
    private static final int ARRAY_LENGTH = 128;
    private final Bufs bufsToFlush;
    private final int arrayLength;

    NioChannelOutput() {
        this(128);
    }

    NioChannelOutput(int arrayLength) {
        super(IOBufferPool.CHNL_OUT_POOL);
        this.arrayLength = arrayLength;
        this.bufsToFlush = new Bufs();
    }

    NioChannelOutput(int arrayLength, IOBufferPool pool) {
        super(pool);
        this.arrayLength = arrayLength;
        this.bufsToFlush = new Bufs();
    }

    Bufs getBufs() {
        this.bufsToFlush.update();
        return this.bufsToFlush;
    }

    boolean hasRemaining() {
        return !this.bufsToFlush.fetchlist.isEmpty() || this.bufsToFlush.length() != 0;
    }

    @Override
    public void close() {
        super.close();
        this.bufsToFlush.fetchlist.freeEntries();
        this.bufsToFlush.freelist.freeEntries();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelOutput");
        builder.append(":Array");
        builder.append("(").append(this.bufsToFlush.offset()).append(",").append(this.bufsToFlush.length()).append(")");
        builder.append(BytesUtil.toString(this.bufsToFlush.array(), this.bufsToFlush.offset(), this.bufsToFlush.length(), 32));
        builder.append("free").append(this.bufsToFlush.freelist);
        builder.append("fetch").append(this.bufsToFlush.fetchlist);
        return builder.toString();
    }

    class Bufs {
        private ByteBuffer[] array;
        private int offset;
        private final IOBufSliceList freelist;
        private final IOBufSliceList fetchlist;

        Bufs() {
            this.array = new ByteBuffer[NioChannelOutput.this.arrayLength];
            this.offset = 0;
            this.freelist = new IOBufSliceList();
            this.fetchlist = new IOBufSliceList();
        }

        ByteBuffer[] array() {
            return this.array;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.freelist.size();
        }

        void update() {
            this.free();
            if (this.length() < NioChannelOutput.this.arrayLength / 2) {
                this.fill();
            }
        }

        void free() {
            int off = this.offset;
            int len = this.length();
            for (int i = off; i < off + len; ++i) {
                if (this.array[i].remaining() != 0) {
                    this.offset = i;
                    break;
                }
                this.freelist.poll().markFree();
            }
            if (this.freelist.isEmpty()) {
                this.offset = 0;
            }
        }

        void fill() {
            int length = this.length();
            if (this.fetchlist.size() + length < NioChannelOutput.this.arrayLength) {
                NioChannelOutput.this.fetch(this.fetchlist);
            }
            if (this.fetchlist.isEmpty()) {
                return;
            }
            System.arraycopy(this.array, this.offset, this.array, 0, length);
            this.offset = 0;
            int inc = Math.min(this.fetchlist.size(), NioChannelOutput.this.arrayLength - length);
            for (int i = 0; i < inc; ++i) {
                IOBufSliceList.Entry slice = this.fetchlist.poll();
                this.freelist.add(slice);
                this.array[length + i] = slice.buf();
            }
        }
    }
}

