/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractEndpointGroup;
import oracle.kv.impl.async.AbstractListener;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.nio.ChannelAccepter;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.async.dialog.nio.NioChannelThreadPool;
import oracle.kv.impl.async.dialog.nio.NioCreatorEndpoint;
import oracle.kv.impl.async.dialog.nio.NioResponderEndpoint;
import oracle.kv.impl.async.dialog.nio.NioUtil;
import oracle.kv.impl.util.CommonLoggerUtils;

public class NioEndpointGroup
extends AbstractEndpointGroup {
    private final NioChannelThreadPool channelThreadPool;

    public NioEndpointGroup(Logger logger, int nthreads) throws Exception {
        super(logger);
        this.channelThreadPool = new NioChannelThreadPool(logger, nthreads);
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.channelThreadPool.next();
    }

    @Override
    protected NioCreatorEndpoint newCreatorEndpoint(NetworkAddress remoteAddress, NetworkAddress localAddress, EndpointConfig endpointConfig) {
        return new NioCreatorEndpoint(this, this.channelThreadPool, remoteAddress, localAddress, endpointConfig);
    }

    @Override
    protected NioListener newListener(AbstractEndpointGroup endpointGroup, ListenerConfig listenerConfig, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
        return new NioListener(endpointGroup, listenerConfig, dialogHandlerFactories);
    }

    @Override
    protected void shutdownInternal(boolean force) {
        this.channelThreadPool.shutdown(force);
    }

    class NioListener
    extends AbstractListener {
        private volatile ServerSocketChannel listeningChannel;
        private NioChannelExecutor channelExecutor;
        private final NioChannelAccepter channelAccepter;

        NioListener(AbstractEndpointGroup endpointGroup, ListenerConfig listenerConfig, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
            super(endpointGroup, listenerConfig, dialogHandlerFactories);
            this.listeningChannel = null;
            this.channelExecutor = null;
            this.channelAccepter = new NioChannelAccepter();
        }

        @Override
        protected void createChannel() throws IOException {
            if (this.listeningChannel == null) {
                this.listeningChannel = NioUtil.listen(this.listenerConfig);
                try {
                    this.listeningChannel.configureBlocking(false);
                    this.channelExecutor = NioEndpointGroup.this.channelThreadPool.next();
                    this.channelExecutor.registerAccept(this.listeningChannel, this.channelAccepter);
                }
                catch (IOException e) {
                    this.listeningChannel.close();
                    this.channelExecutor.wakeup();
                    this.listeningChannel = null;
                    throw e;
                }
            }
        }

        @Override
        protected void closeChannel() {
            if (this.listeningChannel == null) {
                return;
            }
            try {
                this.listeningChannel.close();
                this.channelExecutor.wakeup();
            }
            catch (IOException e) {
                NioEndpointGroup.this.getLogger().log(Level.INFO, "Error closing server channel: {0}", e);
            }
            this.listeningChannel = null;
            this.channelExecutor = null;
        }

        @Override
        protected NetworkAddress getLocalAddress() {
            if (this.listeningChannel == null) {
                return null;
            }
            return NioUtil.getLocalAddress(this.listeningChannel);
        }

        public String toString() {
            return String.format("NioListener[listeningChannel=%s]", this.listeningChannel);
        }

        class NioChannelAccepter
        implements ChannelAccepter {
            NioChannelAccepter() {
            }

            @Override
            public void onAccept(SocketChannel socketChannel) throws IOException {
                Logger logger = NioEndpointGroup.this.getLogger();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "{0} accepting a connection: {1}", new Object[]{this.getClass().getSimpleName(), socketChannel.socket()});
                }
                NetworkAddress remoteAddress = NioUtil.getRemoteAddress(socketChannel);
                NioChannelExecutor executor = NioEndpointGroup.this.channelThreadPool.next();
                final NioResponderEndpoint endpoint = new NioResponderEndpoint(NioEndpointGroup.this, remoteAddress, NioListener.this.listenerConfig, NioListener.this, NioListener.this.endpointConfig, executor, NioUtil.getDataChannel(socketChannel, NioListener.this.endpointConfig, NioEndpointGroup.this.getLogger()));
                NioListener.this.acceptedEndpoints.add(endpoint);
                NioEndpointGroup.this.addResponderEndpoint(endpoint);
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        endpoint.getHandler().onConnected();
                    }
                });
            }

            @Override
            public void onClosing() {
                NioEndpointGroup.this.getLogger().log(Level.FINE, "Accept handler closed: {0}", NioListener.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable t, SelectableChannel channel) {
                Logger logger = NioEndpointGroup.this.getLogger();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Got error when accept, {0}: {1}", new Object[]{NioListener.this, CommonLoggerUtils.getStackTrace(t)});
                }
                try {
                    if (!(t instanceof SecurityException)) {
                        // empty if block
                    }
                    if (!(t instanceof Exception || t instanceof OutOfMemoryError || t instanceof NoClassDefFoundError)) {
                        NioListener.this.shutdown();
                    }
                }
                catch (Throwable throwable) {
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)channel;
                    NioListener.this.onChannelError(t, !serverSocketChannel.isOpen());
                    throw throwable;
                }
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)channel;
                NioListener.this.onChannelError(t, !serverSocketChannel.isOpen());
            }
        }
    }
}

