/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.AbstractDialogEndpointHandler;
import oracle.kv.impl.async.dialog.ProtocolReader;
import oracle.kv.impl.async.dialog.ProtocolWriter;
import oracle.kv.impl.async.dialog.nio.ChannelHandler;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.async.dialog.nio.NioChannelInput;
import oracle.kv.impl.async.dialog.nio.NioChannelOutput;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.util.CommonLoggerUtils;

public class NioEndpointHandler
extends AbstractDialogEndpointHandler
implements ChannelHandler {
    public static volatile ExceptionTestHook<NioEndpointHandler, IOException> readHook;
    private final NioChannelExecutor channelExecutor;
    private final DataChannel dataChannel;
    private final NioChannelInput channelInput;
    private final NioChannelOutput channelOutput;
    private final ProtocolReader protocolReader;
    private final ProtocolWriter protocolWriter;
    private volatile boolean handedOffToSync = false;
    private final CloseHandler closeHandler = new CloseHandler();
    private final IncompletionHandler incompletionHandler = new IncompletionHandler();

    public NioEndpointHandler(Logger logger, EndpointHandlerManager parent, EndpointConfig endpointConfig, boolean isCreator, NetworkAddress remoteAddress, NioChannelExecutor channelExecutor, Map<Integer, DialogHandlerFactory> dialogHandlerFactories, DataChannel dataChannel) {
        super(logger, parent, endpointConfig, isCreator, remoteAddress, dialogHandlerFactories);
        this.channelExecutor = channelExecutor;
        this.dataChannel = dataChannel;
        this.channelInput = new NioChannelInput();
        this.channelOutput = new NioChannelOutput();
        this.protocolReader = new ProtocolReader(this.channelInput, this.getMaxInputProtocolMesgLen());
        this.protocolWriter = new ProtocolWriter(this.channelOutput, this.getMaxOutputProtocolMesgLen());
        this.onExecutorReady();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created endpoint handler: handler={0}, executor={1}", new Object[]{this, channelExecutor});
        }
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.channelExecutor;
    }

    @Override
    public ProtocolReader getProtocolReader() {
        return this.protocolReader;
    }

    @Override
    public ProtocolWriter getProtocolWriter() {
        return this.protocolWriter;
    }

    @Override
    public void assertInExecutorThread() {
        if (!this.channelExecutor.inExecutorThread()) {
            throw new IllegalStateException("The method is not executed in the thread of executor");
        }
    }

    @Override
    public void onConnected() {
        throw new IllegalStateException();
    }

    @Override
    public void onRead() {
        try {
            assert (ExceptionTestHookExecute.doHookIfSet(readHook, this));
            this.read();
            this.incompletionHandler.flushOnRead();
        }
        catch (IOException e) {
            this.markTerminating(e);
            this.terminate();
        }
    }

    private void read() throws IOException {
        boolean again;
        boolean eos = false;
        do {
            long n;
            ByteBuffer[] buffers = this.channelInput.flipToChannelRead();
            again = true;
            while ((n = this.dataChannel.read(buffers)) > 0L) {
            }
            if (n < 0L) {
                eos = true;
                again = false;
            } else {
                again = this.incompletionHandler.handleRead();
            }
            this.channelInput.flipToProtocolRead();
            this.onChannelInputRead();
        } while (again);
        if (eos) {
            this.markTerminating(new ConnectionEndpointShutdownException(true, "Got eof when reading"));
            this.terminate();
        }
    }

    @Override
    public void onWrite() {
        try {
            this.flush();
            this.incompletionHandler.readOnWrite();
        }
        catch (IOException e) {
            this.markTerminating(e);
            this.terminate();
        }
    }

    @Override
    public void onError(Throwable t, SelectableChannel channel) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Error on read/write, terminating handler: {0}", CommonLoggerUtils.getStackTrace(t));
        }
        this.markTerminating(t);
        this.terminate();
    }

    @Override
    public void onClosing() {
        this.markTerminating(new ConnectionEndpointShutdownException(false, "Executor is closing"));
        this.terminate();
    }

    @Override
    public void onSelected() {
        this.incompletionHandler.interestOps.onSelected();
    }

    @Override
    public void onProcessed() {
        try {
            this.incompletionHandler.interestOps.onProcessed();
        }
        catch (IOException e) {
            this.markTerminating(e);
            this.terminate();
        }
    }

    void handedOffToSync() {
        this.handedOffToSync = true;
    }

    @Override
    protected boolean flushInternal(boolean again) throws IOException {
        if (this.handedOffToSync) {
            return true;
        }
        long writtenTotal = 0L;
        while (true) {
            boolean canRetry;
            NioChannelOutput.Bufs bufs = this.channelOutput.getBufs();
            long written = this.dataChannel.write(bufs.array(), bufs.offset(), bufs.length());
            writtenTotal += written;
            boolean dataLeft = this.channelOutput.hasRemaining();
            if (written > 0L && dataLeft) continue;
            boolean flushDone = this.dataChannel.flush();
            if (writtenTotal != 0L && flushDone && dataLeft) {
                writtenTotal = 0L;
                continue;
            }
            if (again) {
                this.incompletionHandler.interestOps.registerReadWrite();
            }
            if (flushDone && !dataLeft) {
                return true;
            }
            boolean bl = canRetry = !again;
            if (!(dataLeft ? this.incompletionHandler.handleWriteOrFlush(DataChannel.AsyncIO.Type.WRITE) && canRetry : this.incompletionHandler.handleWriteOrFlush(DataChannel.AsyncIO.Type.FLUSH) && canRetry)) break;
        }
        return false;
    }

    @Override
    protected void cleanup() throws IOException {
        try {
            this.channelExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    NioEndpointHandler.this.channelInput.close();
                    NioEndpointHandler.this.channelOutput.close();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.channelOutput.close();
            this.scheduleChannelInputClose();
        }
        if (!this.handedOffToSync) {
            this.closeHandler.closeAsync();
        }
    }

    private void scheduleChannelInputClose() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (NioEndpointHandler.this.channelExecutor.isTerminated()) {
                    NioEndpointHandler.this.channelInput.close();
                    return;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    return;
                }
                ForkJoinPool.commonPool().submit(this);
            }
        };
        ForkJoinPool.commonPool().submit(task);
    }

    private class IncompletionHandler {
        private boolean needReadOnWrite = false;
        private boolean needFlushOnRead = false;
        private final Runnable needFlushOnReadSetter = () -> {
            this.needFlushOnRead = true;
        };
        private final Runnable readAfterExecution = () -> NioEndpointHandler.this.channelExecutor.submit(NioEndpointHandler.this::onRead);
        private final Runnable writeAfterExecution = () -> NioEndpointHandler.this.channelExecutor.submit(NioEndpointHandler.this::onWrite);
        private final InterestOps interestOps = new InterestOps();

        private IncompletionHandler() {
        }

        private boolean handleRead() throws IOException {
            assert (NioEndpointHandler.this.channelExecutor.inExecutorThread());
            DataChannel.AsyncIO.ContinueAction action = NioEndpointHandler.this.dataChannel.getAsyncIOContinueAction(DataChannel.AsyncIO.Type.READ);
            switch (action) {
                case RETRY_NOW: {
                    return true;
                }
                case WAIT_FOR_CHNL_READ: {
                    return false;
                }
                case WAIT_FOR_CHNL_WRITE_THEN_FLUSH: {
                    this.needReadOnWrite = true;
                    this.interestOps.registerReadWrite();
                    return false;
                }
                case APP_READ: {
                    return true;
                }
                case WAIT_FOR_TASKS_EXECUTION: {
                    NioEndpointHandler.this.dataChannel.executeTasks(ForkJoinPool.commonPool(), this.readAfterExecution);
                    return false;
                }
            }
            throw new IllegalStateException("Unknown continue action: " + (Object)((Object)action));
        }

        boolean handleWriteOrFlush(DataChannel.AsyncIO.Type type) throws IOException {
            DataChannel.AsyncIO.ContinueAction action = NioEndpointHandler.this.dataChannel.getAsyncIOContinueAction(type);
            switch (action) {
                case RETRY_NOW: {
                    return true;
                }
                case WAIT_FOR_CHNL_READ: {
                    this.runInExecutorThread(this.needFlushOnReadSetter);
                    return false;
                }
                case WAIT_FOR_CHNL_WRITE_THEN_FLUSH: {
                    this.interestOps.registerReadWrite();
                    return false;
                }
                case WAIT_FOR_TASKS_EXECUTION: {
                    NioEndpointHandler.this.dataChannel.executeTasks(ForkJoinPool.commonPool(), this.writeAfterExecution);
                    return false;
                }
                case APP_READ: {
                    this.runInExecutorThread(this.needFlushOnReadSetter);
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected close incompletion due to " + (Object)((Object)action));
        }

        private void runInExecutorThread(Runnable r) {
            if (NioEndpointHandler.this.channelExecutor.inExecutorThread()) {
                r.run();
            } else {
                NioEndpointHandler.this.channelExecutor.submit(r);
            }
        }

        private boolean handleClose() throws IOException {
            DataChannel.AsyncIO.ContinueAction action = NioEndpointHandler.this.dataChannel.getAsyncIOContinueAction(DataChannel.AsyncIO.Type.CLOSE);
            this.interestOps.setClosing();
            switch (action) {
                case RETRY_NOW: {
                    return true;
                }
                case WAIT_FOR_CHNL_READ: {
                    this.interestOps.registerRead();
                    return false;
                }
                case WAIT_FOR_CHNL_WRITE_THEN_FLUSH: {
                    this.interestOps.registerReadWrite();
                    return false;
                }
                case WAIT_FOR_TASKS_EXECUTION: {
                    NioEndpointHandler.this.dataChannel.executeTasks(ForkJoinPool.commonPool(), () -> IncompletionHandler.lambda$handleClose$3(NioEndpointHandler.this.closeHandler));
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected close incompletion due to " + (Object)((Object)action));
        }

        private void readOnWrite() throws IOException {
            assert (NioEndpointHandler.this.channelExecutor.inExecutorThread());
            if (this.needReadOnWrite) {
                this.needReadOnWrite = false;
                NioEndpointHandler.this.read();
            }
        }

        private void flushOnRead() throws IOException {
            assert (NioEndpointHandler.this.channelExecutor.inExecutorThread());
            if (this.needFlushOnRead) {
                this.needFlushOnRead = false;
                NioEndpointHandler.this.flush();
            }
        }

        private static /* synthetic */ void lambda$handleClose$3(CloseHandler rec$) {
            rec$.closeAsync();
        }

        private class InterestOps {
            private final ThreadLocal<Boolean> processing = ThreadLocal.withInitial(() -> false);
            private boolean registeredWrite;
            private boolean closing;
            private boolean requestedWriteDuringProcess;
            private final Runnable readRegister = () -> {
                try {
                    this.registerRead();
                }
                catch (IOException e) {
                    NioEndpointHandler.this.markTerminating(e);
                    NioEndpointHandler.this.terminate();
                }
            };
            private final Runnable writeRegister = () -> {
                try {
                    this.registerReadWrite();
                }
                catch (IOException e) {
                    NioEndpointHandler.this.markTerminating(e);
                    NioEndpointHandler.this.terminate();
                }
            };

            private InterestOps() {
            }

            private void onSelected() {
                this.requestedWriteDuringProcess = false;
                this.processing.set(true);
            }

            private void onProcessed() throws IOException {
                this.processing.set(false);
                if (this.requestedWriteDuringProcess) {
                    this.registerReadWrite();
                } else {
                    this.registerRead();
                }
            }

            private void registerReadWrite() throws IOException {
                if (this.processing.get().booleanValue()) {
                    this.requestedWriteDuringProcess = true;
                    return;
                }
                if (NioEndpointHandler.this.channelExecutor.inExecutorThread()) {
                    if (this.registeredWrite && !this.closing) {
                        return;
                    }
                    NioEndpointHandler.this.getLogger().log(Level.FINEST, () -> String.format("Registering for read/write: %s", NioEndpointHandler.this));
                    this.registeredWrite = true;
                    ChannelHandler handlerToRegister = this.closing ? NioEndpointHandler.this.closeHandler : NioEndpointHandler.this;
                    NioEndpointHandler.this.channelExecutor.registerReadWrite(NioEndpointHandler.this.dataChannel.getSocketChannel(), handlerToRegister);
                    return;
                }
                NioEndpointHandler.this.channelExecutor.submit(this.writeRegister);
            }

            private void registerRead() throws IOException {
                if (this.processing.get().booleanValue()) {
                    return;
                }
                if (NioEndpointHandler.this.channelExecutor.inExecutorThread()) {
                    if (!this.registeredWrite && !this.closing) {
                        return;
                    }
                    NioEndpointHandler.this.getLogger().log(Level.FINEST, () -> String.format("Registering for read: %s", NioEndpointHandler.this));
                    this.registeredWrite = false;
                    ChannelHandler handlerToRegister = this.closing ? NioEndpointHandler.this.closeHandler : NioEndpointHandler.this;
                    NioEndpointHandler.this.channelExecutor.registerRead(NioEndpointHandler.this.dataChannel.getSocketChannel(), handlerToRegister);
                    return;
                }
                NioEndpointHandler.this.channelExecutor.submit(this.readRegister);
            }

            private void setClosing() {
                IncompletionHandler.this.runInExecutorThread(() -> {
                    this.closing = true;
                });
            }
        }
    }

    private class CloseHandler
    implements ChannelHandler {
        private CloseHandler() {
        }

        @Override
        public void onConnected() {
        }

        @Override
        public void onRead() {
            this.closeAsync();
        }

        @Override
        public void onWrite() {
            this.closeAsync();
        }

        @Override
        public void onError(Throwable throwable, SelectableChannel channel) {
            try {
                NioEndpointHandler.this.dataChannel.closeForcefully();
                NioEndpointHandler.this.channelExecutor.wakeup();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }

        @Override
        public void onClosing() {
            try {
                NioEndpointHandler.this.dataChannel.closeForcefully();
                NioEndpointHandler.this.channelExecutor.wakeup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void closeAsync() {
            try {
                boolean finished;
                while (!(finished = NioEndpointHandler.this.dataChannel.closeAsync()) && NioEndpointHandler.this.incompletionHandler.handleClose()) {
                }
                return;
            }
            catch (Throwable t) {
                if (NioEndpointHandler.this.getLogger().isLoggable(Level.FINE)) {
                    NioEndpointHandler.this.getLogger().log(Level.FINE, "Error close channel asynchronously, handler={0}: {1}", new Object[]{NioEndpointHandler.this, CommonLoggerUtils.getStackTrace(t)});
                }
                return;
            }
        }
    }
}

