/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.nio.ChannelHandler;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.async.dialog.nio.NioCreatorEndpoint;
import oracle.kv.impl.async.dialog.nio.NioEndpointHandler;
import oracle.kv.impl.util.CommonLoggerUtils;

class PreWriteWrappedEndpointHandler
implements EndpointHandler,
EndpointHandlerManager,
ChannelHandler {
    private final NioCreatorEndpoint creatorEndpoint;
    private final NetworkAddress remoteAddress;
    private final NioChannelExecutor channelExecutor;
    private final SocketChannel socketChannel;
    private final ByteBuffer preWriteBytes = ByteBuffer.wrap(ProtocolMesg.MAGIC_NUMBER);
    private final NioEndpointHandler endpointHandler;
    private final AtomicBoolean doneShutdownCallback = new AtomicBoolean(false);

    PreWriteWrappedEndpointHandler(NioCreatorEndpoint creatorEndpoint, EndpointConfig endpointConfig, NetworkAddress remoteAddress, NioChannelExecutor channelExecutor, Map<Integer, DialogHandlerFactory> dialogHandlerFactories, DataChannel dataChannel) {
        this.creatorEndpoint = creatorEndpoint;
        this.remoteAddress = remoteAddress;
        this.channelExecutor = channelExecutor;
        this.socketChannel = dataChannel.getSocketChannel();
        this.endpointHandler = new NioEndpointHandler(creatorEndpoint.getLogger(), this, endpointConfig, true, remoteAddress, channelExecutor, dialogHandlerFactories, dataChannel);
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.channelExecutor;
    }

    @Override
    public long getUUID() {
        return this.endpointHandler.getUUID();
    }

    @Override
    public long getConnID() {
        return this.endpointHandler.getConnID();
    }

    @Override
    public String getStringID() {
        return this.endpointHandler.getStringID();
    }

    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        this.endpointHandler.startDialog(dialogType, dialogHandler, timeoutMillis);
    }

    @Override
    public int getNumDialogsLimit() {
        return this.endpointHandler.getNumDialogsLimit();
    }

    @Override
    public void shutdown(String detail, boolean force) {
        this.endpointHandler.shutdown(detail, force);
        if (this.doneShutdownCallback.compareAndSet(false, true)) {
            this.creatorEndpoint.onHandlerShutdown(this);
        }
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handler) {
        if (this.doneShutdownCallback.compareAndSet(false, true)) {
            this.creatorEndpoint.onHandlerShutdown(this);
        }
    }

    @Override
    public void onConnected() {
        this.getLogger().log(Level.FINE, "Connected to {0} and pre-writing", this.remoteAddress);
        try {
            if (!this.onChannelPreWrite()) {
                this.channelExecutor.registerReadWrite(this.socketChannel, this);
            }
        }
        catch (IOException e) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Error registering for read/write after pre-write: remoteAddress={0}, error={1}", new Object[]{this.remoteAddress, CommonLoggerUtils.getStackTrace(e)});
            }
            this.shutdown(e.getMessage(), true);
        }
    }

    @Override
    public void onRead() {
        throw new IllegalStateException();
    }

    @Override
    public void onWrite() {
        this.onChannelPreWrite();
    }

    @Override
    public void onClosing() {
        this.shutdown("Executor closing", true);
    }

    @Override
    public void onError(Throwable t, SelectableChannel channel) {
        this.endpointHandler.onError(t, channel);
    }

    public Logger getLogger() {
        return this.creatorEndpoint.getLogger();
    }

    private boolean onChannelPreWrite() {
        try {
            this.socketChannel.write(this.preWriteBytes);
            if (this.preWriteBytes.remaining() != 0) {
                return false;
            }
            this.channelExecutor.registerRead(this.socketChannel, this.endpointHandler);
            this.endpointHandler.onChannelReady();
            this.endpointHandler.onRead();
            return true;
        }
        catch (Throwable t) {
            Level level = Level.INFO;
            if (t instanceof IOException) {
                level = Level.FINE;
            }
            if (this.getLogger().isLoggable(level)) {
                this.getLogger().log(level, "Error while doing pre-write, remoteAddress={0}: {1}", new Object[]{this.remoteAddress, CommonLoggerUtils.getStackTrace(t)});
            }
            this.shutdown(t.getMessage(), true);
            return true;
        }
    }
}

