/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.exception;

import java.io.IOException;
import oracle.kv.impl.async.exception.DialogBackoffException;
import oracle.kv.impl.async.exception.DialogException;
import oracle.kv.impl.async.exception.DialogNoBackoffException;
import oracle.kv.impl.async.exception.GetUserException;

public abstract class ConnectionException
extends RuntimeException
implements GetUserException {
    private static final long serialVersionUID = 1L;
    private final boolean fromRemote;

    public ConnectionException(boolean fromRemote, String message, Throwable cause) {
        super(message, cause);
        this.fromRemote = fromRemote;
    }

    public boolean fromRemote() {
        return this.fromRemote;
    }

    public DialogException getDialogException(boolean hasSideEffect) {
        this.checkSideEffect(hasSideEffect);
        if (this.shouldBackoff()) {
            return new DialogBackoffException(hasSideEffect, this.fromRemote(), this.getMessage(), this);
        }
        return new DialogNoBackoffException(hasSideEffect, this.fromRemote(), this.getMessage(), this);
    }

    @Override
    public Throwable getUserException() {
        Throwable cause = this.getCause();
        return cause != null ? cause : new IOException(this.getMessage(), this);
    }

    public void checkSideEffect(boolean hasSideEffect) {
    }

    public abstract boolean shouldBackoff();
}

