/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.exception;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.exception.ConnectionException;
import oracle.kv.impl.util.ObjectUtil;

public class ConnectionIOException
extends ConnectionException {
    private static final long serialVersionUID = 1L;
    private final NetworkAddress remoteAddress;
    private boolean shouldBackoff;

    public ConnectionIOException(IOException cause, NetworkAddress remoteAddress) {
        super(false, cause.getMessage(), cause);
        this.remoteAddress = ObjectUtil.checkNull("remoteAddress", remoteAddress);
        this.shouldBackoff = cause instanceof ConnectException ? false : cause instanceof UnknownHostException;
    }

    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public boolean shouldBackoff() {
        return this.shouldBackoff;
    }

    @Override
    public Throwable getUserException() {
        if (this.getCause() instanceof ConnectException) {
            NetworkAddress address = this.getRemoteAddress();
            ConnectException connectException = new ConnectException("Unable to connect to host " + address.getHostName() + ", port " + address.getPort());
            connectException.initCause(this);
            return connectException;
        }
        return super.getUserException();
    }
}

