/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.exception;

import java.io.IOException;
import oracle.kv.impl.async.exception.ConnectionException;
import oracle.kv.impl.async.exception.GetUserException;

public abstract class DialogException
extends RuntimeException
implements GetUserException {
    private static final long serialVersionUID = 1L;
    private final boolean hasSideEffect;
    private final boolean fromRemote;

    protected DialogException(boolean hasSideEffect, boolean fromRemote, String message, Throwable cause) {
        super(message, cause);
        this.hasSideEffect = hasSideEffect;
        this.fromRemote = fromRemote;
    }

    public abstract boolean shouldBackoff();

    public boolean hasSideEffect() {
        return this.hasSideEffect;
    }

    public boolean fromRemote() {
        return this.fromRemote;
    }

    public Throwable getUnderlyingException() {
        Throwable cause = this.getCause();
        if (cause instanceof ConnectionException) {
            cause = cause.getCause();
        }
        return cause != null ? cause : this;
    }

    @Override
    public Throwable getUserException() {
        Throwable cause = this.getCause();
        if (cause instanceof GetUserException) {
            return ((GetUserException)((Object)cause)).getUserException();
        }
        if (cause instanceof IOException || cause instanceof Error) {
            return cause;
        }
        return new IllegalStateException(this.getMessage(), this);
    }
}

