/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.registry;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncVersionedRemoteAPI;
import oracle.kv.impl.async.CreatorEndpoint;
import oracle.kv.impl.async.DialogTypeFamily;
import oracle.kv.impl.async.FailureResultHandler;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.StandardDialogTypeFamily;
import oracle.kv.impl.async.registry.ServiceEndpoint;
import oracle.kv.impl.async.registry.ServiceRegistry;
import oracle.kv.impl.async.registry.ServiceRegistryInitiator;
import oracle.kv.impl.util.CommonLoggerUtils;

public class ServiceRegistryAPI
extends AsyncVersionedRemoteAPI {
    private final ServiceRegistry proxyRemote;

    protected ServiceRegistryAPI(ServiceRegistry remote, short serialVersion) {
        super(serialVersion);
        this.proxyRemote = remote;
    }

    public static void wrap(CreatorEndpoint endpoint, long timeoutMillis, Logger logger, ResultHandler<ServiceRegistryAPI> handler) {
        Factory.INSTANCE.wrap(endpoint, timeoutMillis, logger, handler);
    }

    public void lookup(String name, final DialogTypeFamily dialogTypeFamily, long timeoutMillis, final ResultHandler<ServiceEndpoint> resultHandler) {
        class LookupResultHandler
        extends FailureResultHandler<ServiceEndpoint> {
            LookupResultHandler() {
                super(resultHandler2);
            }

            @Override
            protected void onResultInternal(ServiceEndpoint result, Throwable exception) {
                DialogTypeFamily serviceDialogTypeFamily;
                if (result != null && dialogTypeFamily != null && (serviceDialogTypeFamily = result.getDialogType().getDialogTypeFamily()) != dialogTypeFamily) {
                    resultHandler.onResult(null, new IllegalStateException("Unexpected dialog type family for service endpoint.  Expected: " + dialogTypeFamily + ", found: " + serviceDialogTypeFamily));
                    return;
                }
                resultHandler.onResult(result, exception);
            }
        }
        this.proxyRemote.lookup(this.getSerialVersion(), name, timeoutMillis, new LookupResultHandler());
    }

    public void bind(String name, ServiceEndpoint endpoint, long timeoutMillis, ResultHandler<Void> handler) {
        this.proxyRemote.bind(this.getSerialVersion(), name, endpoint, timeoutMillis, handler);
    }

    public void unbind(String name, long timeoutMillis, ResultHandler<Void> handler) {
        this.proxyRemote.unbind(this.getSerialVersion(), name, timeoutMillis, handler);
    }

    public void list(long timeoutMillis, ResultHandler<List<String>> handler) {
        this.proxyRemote.list(this.getSerialVersion(), timeoutMillis, handler);
    }

    public static class Factory {
        static final Factory INSTANCE = new Factory();

        protected ServiceRegistryAPI createAPI(ServiceRegistry remote, short serialVersion) {
            return new ServiceRegistryAPI(remote, serialVersion);
        }

        public void wrap(final CreatorEndpoint endpoint, long timeoutMillis, final Logger logger, final ResultHandler<ServiceRegistryAPI> handler) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ServiceRegistryAPI.Factory.wrap called for endpoint {0}\n{1}", new Object[]{endpoint, CommonLoggerUtils.getStackTrace(new Throwable())});
            }
            final ServiceRegistryInitiator initiator = new ServiceRegistryInitiator(endpoint, logger);
            class WrapHandler
            extends FailureResultHandler<Short> {
                WrapHandler() {
                    super(resultHandler);
                }

                @Override
                protected void onResultInternal(Short serialVersion, Throwable t) {
                    if (t != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "ServiceRegistryAPI.wrap fails for endpoint " + endpoint, t);
                        }
                        handler.onResult(null, t);
                    } else {
                        logger.log(Level.FINE, "ServiceRegistryAPI.wrap returns for endpoint {0}", endpoint);
                        handler.onResult(Factory.this.createAPI(initiator, serialVersion), null);
                    }
                }

                public String toString() {
                    return "Handler[dialogType=" + StandardDialogTypeFamily.SERVICE_REGISTRY_DIALOG_TYPE + " methodOp=" + ServiceRegistry.RegistryMethodOp.GET_SERIAL_VERSION + "]";
                }
            }
            ServiceRegistryAPI.computeSerialVersion(initiator, timeoutMillis, new WrapHandler());
        }
    }
}

