/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.net.URI;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.impl.util.registry.RemoteAPI;
import oracle.kv.util.ErrorMessage;

public class ClientAdminServiceAPI
extends RemoteAPI {
    private static final AuthContext NULL_CTX = null;
    private final ClientAdminService proxyRemote;
    public static volatile ExceptionTestHook<String, RemoteException> REMOTE_FAULT_HOOK;

    private ClientAdminServiceAPI(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static ClientAdminServiceAPI wrap(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        return new ClientAdminServiceAPI(remote, loginHdl);
    }

    public ExecutionInfo execute(char[] statement, String namespace, boolean validateNamespace, TableLimits limits, LogContext lc, AuthContext auth) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "execute"));
        if (limits != null) {
            this.checkMethodSupported((short)16);
        }
        if (namespace != null) {
            this.checkMethodSupported((short)14);
        }
        if (this.getSerialVersion() < 14) {
            return this.convertInfo(this.proxyRemote.execute(new String(statement), NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 15) {
            return this.convertInfo(this.proxyRemote.execute(new String(statement), namespace, NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 16) {
            return this.convertInfo(this.proxyRemote.execute(statement, namespace, NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 18) {
            return this.convertInfo(this.proxyRemote.execute(statement, namespace, limits, lc, NULL_CTX, this.getSerialVersion()));
        }
        return this.convertInfo(this.proxyRemote.execute(statement, namespace, validateNamespace, limits, lc, auth == null ? NULL_CTX : auth, this.getSerialVersion()));
    }

    public ExecutionInfo setTableLimits(String namespace, String tableName, TableLimits limits) throws RemoteException {
        this.checkMethodSupported((short)16);
        return this.proxyRemote.setTableLimits(namespace, tableName, limits, NULL_CTX, this.getSerialVersion());
    }

    public ExecutionInfo getExecutionStatus(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "getExecutionStatus"));
        return this.getExecutionStatus(planId, NULL_CTX);
    }

    public ExecutionInfo getExecutionStatus(int planId, AuthContext authCtx) throws RemoteException {
        return this.proxyRemote.getExecutionStatus(planId, authCtx, this.getSerialVersion());
    }

    public boolean canHandleDDL() throws RemoteException {
        return this.proxyRemote.canHandleDDL(NULL_CTX, this.getSerialVersion());
    }

    public URI getMasterRmiAddress() throws RemoteException {
        return this.proxyRemote.getMasterRmiAddress(NULL_CTX, this.getSerialVersion());
    }

    public ExecutionInfo interruptAndCancel(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "interruptAndCancel"));
        return this.interruptAndCancel(planId, NULL_CTX);
    }

    public ExecutionInfo interruptAndCancel(int planId, AuthContext authCtx) throws RemoteException {
        return this.proxyRemote.interruptAndCancel(planId, authCtx, this.getSerialVersion());
    }

    private ExecutionInfo convertInfo(ExecutionInfo execInfo) {
        return execInfo;
    }

    private void checkMethodSupported(short expectVersion) throws UnsupportedOperationException {
        if (this.getSerialVersion() < expectVersion) {
            String errMsg = "Command not available because service has not yet been upgraded.  (Internal local version=" + expectVersion + ", internal service version=" + this.getSerialVersion() + ")";
            throw new AdminFaultException(new UnsupportedOperationException(errMsg), errMsg, ErrorMessage.NOSQL_5200, CommandResult.NO_CLEANUP_JOBS);
        }
    }
}

