/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.rmi.RemoteException;
import java.util.logging.Logger;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.DdlStatementExecutor;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.security.AuthContext;

class DdlCheckTask
implements Runnable {
    private final Logger logger;
    private final int planId;
    private final DdlStatementExecutor statementExec;
    private final int maxRetries;
    private final long delayMs;
    private final AuthContext authCtx;

    DdlCheckTask(int planId, DdlStatementExecutor statementExec, int maxRetries, long delayMs, Logger logger, AuthContext authCtx) {
        assert (maxRetries > 0);
        this.planId = planId;
        this.statementExec = statementExec;
        this.maxRetries = maxRetries;
        this.delayMs = delayMs;
        this.logger = logger;
        this.authCtx = authCtx;
    }

    @Override
    public void run() {
        try {
            ExecutionInfo newInfo = this.statementExec.getClientAdminService().getExecutionStatus(this.planId);
            newInfo = DdlFuture.checkForNeedsCancel(newInfo, this.statementExec, this.planId, this.authCtx);
            this.statementExec.updateWaiters(newInfo, null, false);
            this.statementExec.scheduleCheckTask(this.planId, this.maxRetries, this.delayMs, this.authCtx);
        }
        catch (RemoteException e) {
            int remaining = this.maxRetries - 1;
            this.logger.fine("Got " + e + ", " + remaining + " retries remaining");
            if (remaining > 0) {
                this.statementExec.scheduleCheckTask(this.planId, remaining, this.delayMs, this.authCtx);
                return;
            }
            this.statementExec.shutdownWaitersDueToError(this.planId, e);
        }
        catch (Throwable t) {
            this.logger.info("DDL polling task for plan " + this.planId + " shut down due to " + t);
            this.statementExec.shutdownWaitersDueToError(this.planId, t);
        }
    }
}

