/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.ExecutionFuture;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.StatementResult;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.client.admin.ClientAdminServiceAPI;
import oracle.kv.impl.client.admin.DdlCheckTask;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;
import oracle.kv.impl.client.admin.FindClientAdminService;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.query.ExecuteOptions;

public class DdlStatementExecutor {
    private ClientAdminServiceAPI clientAdminService;
    private final ScheduledExecutorService completionChecker;
    private final Map<Integer, ScheduledFuture<?>> scheduledFutures;
    private final Map<Integer, Set<DdlFuture>> notificationTargets;
    private final Topology topo;
    private LoginManager loginManager;
    private final Logger logger;
    private final int maxCheckRetries;
    private final long checkIntervalMillis;

    public DdlStatementExecutor(KVStoreImpl store) {
        this(store.getDispatcher().getTopologyManager().getTopology(), KVStoreImpl.getLoginManager(store), store.getMaxCheckRetries(), store.getCheckIntervalMillis(), store.getLogger());
    }

    public DdlStatementExecutor(Topology topo, LoginManager loginManager, int maxCheckRetries, long checkIntervalMillis, Logger logger) {
        this.topo = topo;
        this.loginManager = loginManager;
        this.maxCheckRetries = maxCheckRetries;
        this.checkIntervalMillis = checkIntervalMillis;
        this.logger = logger;
        this.scheduledFutures = new HashMap();
        this.notificationTargets = new HashMap<Integer, Set<DdlFuture>>();
        this.completionChecker = new ScheduledThreadPoolExecutor(1, new KVThreadFactory("DDLChecks", logger));
        try {
            this.ensureClientAdminService();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized ClientAdminServiceAPI getClientAdminService() {
        this.ensureClientAdminService();
        return this.clientAdminService;
    }

    public synchronized void renewLoginManager(LoginManager loginManger) {
        this.loginManager = loginManger;
        FindClientAdminService finder = new FindClientAdminService(this.topo, this.logger, this.loginManager);
        this.clientAdminService = finder.getDDLService();
    }

    private void ensureClientAdminService() throws FaultException {
        if (this.clientAdminService != null) {
            try {
                if (this.clientAdminService.canHandleDDL()) {
                    return;
                }
            }
            catch (RemoteException e) {
                this.logger.fine("Ensuring connection, got " + e);
            }
            this.clientAdminService = null;
        }
        this.logger.info("Establishing RMI connection for admin DDL");
        FindClientAdminService finder = new FindClientAdminService(this.topo, this.logger, this.loginManager);
        this.clientAdminService = finder.getDDLService();
        if (this.clientAdminService == null) {
            throw new FaultException("Couldn't connect to a store Admin service capable of executing an administrative table statement. Contacted nodes " + finder.getTargets(), false);
        }
    }

    synchronized void startPolling(int planId, DdlFuture ddlFuture) {
        Set<DdlFuture> targets;
        if (!this.scheduledFutures.containsKey(planId)) {
            this.scheduleCheckTask(planId, this.maxCheckRetries, 10L, ddlFuture.getAuthContext());
        }
        if ((targets = this.notificationTargets.get(planId)) == null) {
            targets = new HashSet<DdlFuture>();
            this.notificationTargets.put(planId, targets);
        }
        targets.add(ddlFuture);
    }

    void shutdownWaitersDueToError(int planId, Throwable t) {
        ExecutionInfoImpl errorInfo = new ExecutionInfoImpl(planId, false, null, null, false, false, t.getMessage(), false, null);
        this.updateWaiters(errorInfo, t, true);
    }

    void updateWaiters(ExecutionInfo newInfo) {
        this.updateWaiters(newInfo, null, false);
    }

    synchronized void updateWaiters(ExecutionInfo newInfo, Throwable t, boolean stopPolling) {
        int planId = newInfo.getPlanId();
        Set<DdlFuture> waiters = this.notificationTargets.get(planId);
        if (waiters != null) {
            for (DdlFuture waiter : waiters) {
                waiter.applyNewInfo(newInfo, t);
            }
        }
        if (stopPolling || newInfo.isTerminated()) {
            ScheduledFuture<?> taskFuture = this.scheduledFutures.get(planId);
            if (taskFuture != null) {
                this.logger.fine("Polling task for plan " + planId + " finished, info = " + newInfo);
                taskFuture.cancel(true);
                this.scheduledFutures.remove(planId);
            }
            this.notificationTargets.remove(planId);
        }
    }

    void taskFailed(int planId, RemoteException e) {
        throw new UnsupportedOperationException(e);
    }

    public ExecutionFuture executeDdl(char[] statement, String namespace, ExecuteOptions options, TableLimits limits, LoginManager login) throws IllegalArgumentException, FaultException {
        try {
            this.loginManager = login;
            AuthContext authCtx = options == null ? null : options.getAuthContext();
            ExecutionInfo info = this.getClientAdminService().execute(statement, namespace, options == null || options.isValidateNamespace(), limits, options == null ? null : options.getLogContext(), authCtx);
            return new DdlFuture(statement, info, this, authCtx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (WrappedClientException wce) {
            if (wce.getCause() instanceof IllegalStateException && this.logger != null) {
                this.logger.warning(wce.getCause().toString());
            }
            throw (RuntimeException)wce.getCause();
        }
        catch (AdminFaultException e) {
            if (e.getFaultClassName().equals(IllegalCommandException.class.getName())) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (e.getFaultClassName().equals(FaultException.class.getName())) {
                throw new FaultException(e.getMessage(), false);
            }
            throw new FaultException(e.getMessage(), e, false);
        }
        catch (KVSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaultException(e.getMessage(), e, false);
        }
    }

    public ExecutionFuture setTableLimits(String namespace, String tableName, TableLimits limits, LoginManager login) throws IllegalArgumentException, FaultException {
        try {
            this.loginManager = login;
            ExecutionInfo info = this.getClientAdminService().setTableLimits(namespace, tableName, limits);
            return new DdlFuture(info.getPlanId(), this);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (AdminFaultException e) {
            if (e.getFaultClassName().equals(IllegalCommandException.class.getName())) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (e.getFaultClassName().equals(FaultException.class.getName())) {
                throw new FaultException(e.getMessage(), false);
            }
            throw new FaultException(e.getMessage(), e, false);
        }
        catch (KVSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaultException(e.getMessage(), e, false);
        }
    }

    public static StatementResult waitExecutionResult(ExecutionFuture future) throws FaultException, IllegalArgumentException {
        try {
            StatementResult r = future.get();
            return r;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof FaultException) {
                    throw (FaultException)e.getCause();
                }
                throw new FaultException(e.getMessage(), e.getCause(), false);
            }
            throw new FaultException(e.getMessage(), false);
        }
        catch (KVSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaultException(e.getMessage(), e, false);
        }
    }

    void scheduleCheckTask(int planId, int retries, long delayMs, AuthContext authCtx) {
        long nextDelayMs = Math.min(2L * delayMs, this.checkIntervalMillis);
        ScheduledFuture<?> f = this.completionChecker.schedule(new DdlCheckTask(planId, this, retries, nextDelayMs, this.logger, authCtx), delayMs, TimeUnit.MILLISECONDS);
        this.scheduledFutures.put(planId, f);
    }
}

