/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprDeleteRow;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprSort;
import oracle.kv.impl.query.compiler.ExprUpdateRow;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.ExprVisitor;
import oracle.kv.impl.query.compiler.ExprWalker;
import oracle.kv.impl.query.compiler.FuncArithOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;

class Distributer
extends ExprVisitor {
    QueryControlBlock theQCB;
    FunctionLib theFuncLib = CompilerAPI.getFuncLib();
    private final ExprWalker theWalker;

    Distributer(QueryControlBlock qcb) {
        this.theQCB = qcb;
        this.theWalker = new ExprWalker(this, false);
    }

    void distributeQuery() {
        this.theWalker.walk(this.theQCB.getRootExpr());
    }

    @Override
    void exit(ExprDeleteRow del) {
        Expr topExpr;
        Expr input = del.getInput();
        PreparedStatementImpl.DistributionKind dkind = null;
        if (input.getKind() != Expr.ExprKind.RECEIVE) {
            topExpr = del;
            Function func = input.getFunction(FunctionLib.FuncCode.FN_SEQ_CONCAT);
            if (func == null) {
                throw new QueryStateException("Input to local delete iterator is not seq_concat()");
            }
            ExprFuncCall emptyExpr = (ExprFuncCall)input;
            if (emptyExpr.getNumArgs() != 0) {
                throw new QueryStateException("Input to local delete iterator is not seq_concat()");
            }
        } else {
            ExprReceive rcv = (ExprReceive)del.getInput();
            del.setInput(rcv.getInput(), false);
            rcv.setInput(del, false);
            del.replace(rcv, false);
            dkind = rcv.getDistributionKind();
            topExpr = rcv;
        }
        if (!del.hasReturningClause() && dkind != PreparedStatementImpl.DistributionKind.SINGLE_PARTITION) {
            QueryException.Location loc = del.getLocation();
            ExprSFW clientSFW = new ExprSFW(this.theQCB, del.getSctx(), loc);
            topExpr.replace(clientSFW, false);
            String varName = this.theQCB.createInternalVarName("delcount");
            ExprVar var = clientSFW.createFromVar(topExpr, varName);
            ExprFieldStep field = new ExprFieldStep(this.theQCB, del.getSctx(), loc, (Expr)var, 0);
            Expr sum = ExprFuncCall.create(this.theQCB, del.getSctx(), loc, FunctionLib.FuncCode.FN_SUM, (Expr)field);
            ArrayList<Expr> selectList = new ArrayList<Expr>(1);
            ArrayList<String> selectNames = new ArrayList<String>(1);
            selectList.add(sum);
            selectNames.add("numRowsDeleted");
            clientSFW.setNumGroupByExprs(0);
            clientSFW.addSelectClause(selectNames, selectList);
        }
    }

    @Override
    void exit(ExprUpdateRow upd) {
        if (upd.getInput().getKind() != Expr.ExprKind.RECEIVE) {
            return;
        }
        ExprReceive recv = (ExprReceive)upd.getInput();
        upd.setArg(0, recv.getInput(), false);
        upd.replace(recv, false);
        recv.setInput(upd, false);
        assert (recv.getDistributionKind() == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION);
    }

    @Override
    void exit(ExprBaseTable e) {
        ExprReceive recv = new ExprReceive(this.theQCB, this.theQCB.getInitSctx());
        e.replace(recv, false);
        recv.setInput(e, false);
        recv.setEliminateIndexDups(e.getEliminateIndexDups());
        recv.setIsUpdate(e.getIsUpdate() || e.getIsDelete());
    }

    @Override
    boolean enter(ExprSFW sfw) {
        this.theWalker.walk(sfw.getDomainExpr(0));
        if (sfw.getDomainExpr(0).getKind() != Expr.ExprKind.RECEIVE) {
            return false;
        }
        boolean inDelete = sfw.hasParents() && sfw.getParent(0).getKind() == Expr.ExprKind.DELETE_ROW;
        ExprReceive rcv = (ExprReceive)sfw.getDomainExpr(0);
        sfw.setDomainExpr(0, rcv.getInput(), false);
        rcv.setInput(sfw, false);
        sfw.replace(rcv, false);
        if (inDelete) {
            rcv.setEliminateIndexDups(false);
        }
        Expr offset = sfw.getOffset();
        Expr limit = sfw.getLimit();
        boolean hasSort = sfw.hasSort();
        boolean hasGroupBy = sfw.hasGroupBy();
        boolean hasNear = sfw.hasNearPred();
        boolean hasOffset = offset != null;
        boolean hasLimit = limit != null;
        boolean eliminateIndexDups = rcv.getEliminateIndexDups();
        boolean isSinglePartition = rcv.getDistributionKind() == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION;
        this.theQCB.setHasSort(hasSort);
        this.theQCB.setHasGroupBy(hasGroupBy);
        this.theQCB.setHasGroupByExpr(sfw.getNumGroupByExprs() > 0);
        this.theQCB.setGroupByExprCompleteShardKey(sfw.getGroupByExprCompleteShardKey());
        if (sfw.getNumFroms() > 1) {
            eliminateIndexDups = false;
            rcv.setEliminateIndexDups(false);
        }
        if (isSinglePartition && !hasNear) {
            return false;
        }
        if (!(hasSort || hasGroupBy || eliminateIndexDups || hasOffset || hasLimit)) {
            return false;
        }
        ExprSort sort = null;
        int numFields = sfw.getNumFields();
        boolean isSelectStar = sfw.isSelectStar();
        StaticContext sctx = sfw.getSctx();
        QueryException.Location loc = sfw.getLocation();
        if (hasSort) {
            int[] sortExprPositions = sfw.addSortExprsToSelect();
            if (hasNear) {
                sort = new ExprSort(this.theQCB, sctx, loc, sortExprPositions, sfw.getSortSpecs());
                rcv.replace(sort, false);
                rcv.setType(rcv.computeType());
                sort.setInput(rcv, false);
            } else {
                rcv.addSort(sortExprPositions, sfw.getSortSpecs());
            }
            sfw.setDoNullOnEmpty(false);
        }
        if (eliminateIndexDups) {
            int[] primKeyPositions = sfw.addPrimKeyToSelect();
            rcv.addPrimKeyPositions(primKeyPositions);
        }
        if (!(numFields != sfw.getNumFields() || hasGroupBy || hasOffset || hasLimit)) {
            return false;
        }
        ExprSFW clientSFW = new ExprSFW(this.theQCB, sctx, loc);
        Expr clientSFWInput = sort != null ? sort : rcv;
        ExprVar fromVar = clientSFW.createFromVar(clientSFWInput, this.theQCB.createInternalVarName("from"));
        ArrayList<Expr> fieldExprs = new ArrayList<Expr>(numFields);
        ArrayList<String> fieldNames = new ArrayList<String>(numFields);
        if (sfw.getConstructsRecord()) {
            if (numFields == sfw.getNumFields() && !hasGroupBy) {
                fieldExprs.add(fromVar);
                fieldNames.add(fromVar.getName());
                isSelectStar = true;
            } else {
                for (int i = 0; i < numFields; ++i) {
                    Expr clientFieldExpr = new ExprFieldStep(this.theQCB, sfw.getSctx(), sfw.getFieldExpr(i).getLocation(), (Expr)fromVar, sfw.getFieldName(i));
                    if (hasGroupBy && !sfw.isGroupingField(i)) {
                        ExprFuncCall aggrExpr = (ExprFuncCall)sfw.getFieldExpr(i);
                        clientFieldExpr = this.getRegroupingExpr(aggrExpr, clientFieldExpr);
                    }
                    fieldExprs.add(clientFieldExpr);
                    fieldNames.add(sfw.getFieldName(i));
                }
            }
        } else {
            assert (numFields == 1);
            Expr clientFieldExpr = fromVar;
            if (hasGroupBy && !sfw.isGroupingField(0)) {
                ExprFuncCall aggrExpr = (ExprFuncCall)sfw.getFieldExpr(0);
                clientFieldExpr = this.getRegroupingExpr(aggrExpr, clientFieldExpr);
            }
            fieldExprs.add(clientFieldExpr);
            fieldNames.add(sfw.getFieldName(0));
        }
        clientSFW.addSelectClause(fieldNames, fieldExprs);
        clientSFW.setIsSelectStar(isSelectStar);
        if (hasGroupBy) {
            int numGBExprs = sfw.getNumGroupByExprs();
            clientSFW.setNumGroupByExprs(numGBExprs);
            if (numGBExprs > 0) {
                int[] sortPositions = new int[numGBExprs];
                SortSpec[] sortSpecs = new SortSpec[numGBExprs];
                for (int i = 0; i < numGBExprs; ++i) {
                    sortPositions[i] = i;
                    sortSpecs[i] = new SortSpec(false, false);
                }
                rcv.addSort(sortPositions, sortSpecs);
                if (this.theQCB.getOptions().getDriverQueryVersion() >= 2) {
                    this.theQCB.setHasSort(true);
                }
            }
        }
        if (hasOffset || hasLimit) {
            if (hasLimit && hasOffset) {
                sfw.removeOffset(false);
                Expr newLimit = FuncArithOp.createArithExpr(offset, limit, "+");
                sfw.setLimit(newLimit, false);
            } else if (hasOffset) {
                sfw.removeOffset(false);
            }
            clientSFW.addOffsetLimit(offset, limit);
        }
        clientSFWInput.replace(clientSFW, false);
        return false;
    }

    private Expr getRegroupingExpr(ExprFuncCall aggrExpr, Expr inputExpr) {
        Function aggrFunc = aggrExpr.getFunction(null);
        switch (aggrFunc.getCode()) {
            case FN_COUNT: 
            case FN_COUNT_STAR: 
            case FN_COUNT_NUMBERS: 
            case FN_SUM: {
                aggrFunc = this.theFuncLib.getFunc(FunctionLib.FuncCode.FN_SUM);
                break;
            }
            case FN_MIN: {
                aggrFunc = this.theFuncLib.getFunc(FunctionLib.FuncCode.FN_MIN);
                break;
            }
            case FN_MAX: {
                aggrFunc = this.theFuncLib.getFunc(FunctionLib.FuncCode.FN_MAX);
                break;
            }
            default: {
                throw new QueryStateException("Unknown aggregate function: " + (Object)((Object)aggrFunc.getCode()));
            }
        }
        return ExprFuncCall.create(this.theQCB, aggrExpr.getSctx(), aggrExpr.getLocation(), aggrFunc, inputExpr);
    }
}

