/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprArrayFilter
extends Expr {
    private Expr theInput;
    private Expr thePredExpr;
    private Object theConstValue;
    private ExprVar theCtxItemVar;
    private ExprVar theCtxElemVar;
    private ExprVar theCtxElemPosVar;

    ExprArrayFilter(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input) {
        super(qcb, sctx, Expr.ExprKind.ARRAY_FILTER, location);
        this.theInput = input;
        this.theInput.addParent(this);
    }

    void addCtxVars(ExprVar ctxItemVar, ExprVar ctxElemVar, ExprVar ctxElemPosVar) {
        this.theCtxItemVar = ctxItemVar;
        this.theCtxElemVar = ctxElemVar;
        this.theCtxElemPosVar = ctxElemPosVar;
    }

    void addPredExpr(Expr pred) {
        assert (this.thePredExpr == null && pred != null);
        this.thePredExpr = pred;
        this.thePredExpr.addParent(this);
        this.checkConst();
        if (!this.isConst()) {
            ExprType predType = this.thePredExpr.getType();
            if (!(predType.isAny() || predType.isAnyJson() || predType.isAnyAtomic() || predType.isAnyJsonAtomic() || predType.isSubType(TypeManager.LONG_STAR()) || predType.isSubType(TypeManager.BOOLEAN_STAR()))) {
                throw new QueryException("Predicate expression in filter step has invalid type:\nExpected type is integer, long, or boolean. Actual type is\n" + predType, pred.getLocation());
            }
            this.thePredExpr = ExprPromote.create(this, this.thePredExpr, TypeManager.ANY_ATOMIC_QSTN());
        }
        this.removeCtxVars();
    }

    @Override
    int getNumChildren() {
        return this.thePredExpr != null ? 2 : 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    Expr getPredExpr() {
        return this.thePredExpr;
    }

    void setPredExpr(Expr newExpr, boolean destroy) {
        this.thePredExpr.removeParent(this, destroy);
        this.thePredExpr = newExpr;
        newExpr.addParent(this);
        this.removeCtxVars();
        this.checkConst();
    }

    void removePredExpr(boolean destroy) {
        this.thePredExpr.removeParent(this, destroy);
        this.thePredExpr = null;
        this.removeCtxVars();
        this.checkConst();
    }

    ExprVar getCtxItemVar() {
        return this.theCtxItemVar;
    }

    ExprVar getCtxElemVar() {
        return this.theCtxElemVar;
    }

    ExprVar getCtxElemPosVar() {
        return this.theCtxElemPosVar;
    }

    Object getConstValue() {
        return this.theConstValue;
    }

    Long getNumericConst() {
        return this.theConstValue instanceof Long ? (Long)this.theConstValue : null;
    }

    boolean isConst() {
        return this.thePredExpr == null;
    }

    void checkConst() {
        if (this.isConst()) {
            assert (this.theCtxItemVar == null);
            assert (this.theCtxElemVar == null);
            assert (this.theCtxElemPosVar == null);
            return;
        }
        if (this.thePredExpr.getKind() == Expr.ExprKind.CONST) {
            ExprType.TypeCode c = this.thePredExpr.getType().getCode();
            FieldValueImpl value = ((ExprConst)this.thePredExpr).getValue();
            if (c == ExprType.TypeCode.INT || c == ExprType.TypeCode.LONG) {
                this.theConstValue = value.getLong();
            } else if (c == ExprType.TypeCode.BOOLEAN) {
                this.theConstValue = value;
            } else {
                throw new QueryException("Predicate expression in filter step has invalid type.\nExpected type is integer, long, or boolean. Actual type is\n" + this.thePredExpr.getType(), this.thePredExpr.getLocation());
            }
            this.thePredExpr.removeParent(this, true);
            this.thePredExpr = null;
            this.theCtxItemVar = null;
            this.theCtxElemVar = null;
            this.theCtxElemPosVar = null;
        }
    }

    void removeCtxVars() {
        if (this.theCtxItemVar != null && !this.theCtxItemVar.hasParents()) {
            this.theCtxItemVar = null;
        }
        if (this.theCtxElemVar != null && !this.theCtxElemVar.hasParents()) {
            this.theCtxElemVar = null;
        }
        if (this.theCtxElemPosVar != null && !this.theCtxElemPosVar.hasParents()) {
            this.theCtxElemPosVar = null;
        }
    }

    Expr convertToSliceStep() {
        if (this.getNumericConst() != null) {
            this.theInput.removeParent(this, false);
            ExprArraySlice sliceStep = new ExprArraySlice(this.theQCB, this.theSctx, this.getLocation(), this.theInput, this.getNumericConst());
            this.replace(sliceStep, true);
            return sliceStep;
        }
        if (this.thePredExpr != null && this.thePredExpr.getType().isNumeric()) {
            return this;
        }
        return this;
    }

    @Override
    public ExprType computeType() {
        boolean val;
        boolean isNotArray;
        ExprType inType = this.theInput.getType();
        boolean bl = isNotArray = inType.isAtomic() || inType.isRecord() || inType.isMap();
        if (this.theQCB.strictMode() && isNotArray) {
            throw new QueryException("Wrong input type for [] operator. Expected an array type. Actual type is :\n" + inType.getDef().getDDLString(), this.theLocation);
        }
        this.checkConst();
        if (this.isConst() && this.theConstValue instanceof BooleanValueImpl && !(val = ((BooleanValueImpl)this.theConstValue).getBoolean())) {
            return TypeManager.EMPTY();
        }
        ExprType.Quantifier inQuant = inType.getQuantifier();
        ExprType.Quantifier outQuant = ExprType.Quantifier.STAR;
        if (isNotArray) {
            outQuant = TypeManager.getUnionQuant(inQuant, ExprType.Quantifier.QSTN);
        }
        return inType.getArrayElementType(outQuant);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.thePredExpr != null || this.getNumericConst() != null || this.theConstValue == BooleanValueImpl.falseValue || this.theInput.mayReturnNULL() || this.getType().isAny() || this.getType().isAnyJson();
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
        if (this.isConst()) {
            sb.append("[");
            sb.append(this.theConstValue);
            sb.append("]");
        } else {
            sb.append(".\n");
            formatter.indent(sb);
            sb.append("[\n");
            formatter.incIndent();
            this.thePredExpr.display(sb, formatter);
            formatter.decIndent();
            sb.append("\n");
            formatter.indent(sb);
            sb.append("]");
        }
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
    }
}

